/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.aaa;

import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Modified;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.onlab.packet.DeserializationException;
import org.onlab.packet.EAP;
import org.onlab.packet.EAPOL;
import org.onlab.packet.EthType;
import org.onlab.packet.Ethernet;
import org.onlab.packet.IPacket;
import org.onlab.packet.IPv4;
import org.onlab.packet.Ip4Address;
import org.onlab.packet.IpAddress;
import org.onlab.packet.MacAddress;
import org.onlab.packet.RADIUS;
import org.onlab.packet.TpPort;
import org.onlab.packet.UDP;
import org.onlab.util.Tools;
import org.onosproject.aaa.StateMachine;
import org.onosproject.aaa.StateMachineException;
import org.onosproject.cfg.ComponentConfigService;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreService;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DeviceId;
import org.onosproject.net.Host;
import org.onosproject.net.PortNumber;
import org.onosproject.net.flow.DefaultTrafficSelector;
import org.onosproject.net.flow.DefaultTrafficTreatment;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.host.HostService;
import org.onosproject.net.packet.DefaultOutboundPacket;
import org.onosproject.net.packet.InboundPacket;
import org.onosproject.net.packet.OutboundPacket;
import org.onosproject.net.packet.PacketContext;
import org.onosproject.net.packet.PacketPriority;
import org.onosproject.net.packet.PacketProcessor;
import org.onosproject.net.packet.PacketService;
import org.onosproject.xosintegration.VoltTenantService;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
public class AAA {
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected CoreService coreService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected PacketService packetService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected HostService hostService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected VoltTenantService voltTenantService;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private ReactivePacketProcessor processor = new ReactivePacketProcessor();
    private ApplicationId appId;
    Map stateMachineMap = null;
    private static final String DEFAULT_RADIUS_IP = "192.168.1.10";
    private static final String DEFAULT_NAS_IP = "192.168.1.11";
    private static final int DEFAULT_RADIUS_UPLINK = 2;
    private static final String DEFAULT_RADIUS_SECRET = "ONOSecret";
    private static final String RADIUS_MAC_ADDRESS = "00:00:00:00:01:10";
    private static final String NAS_MAC_ADDRESS = "00:00:00:00:10:01";
    private static final String DEFAULT_RADIUS_SWITCH = "of:90e2ba82f97791e9";
    private static final String DEFAULT_RADIUS_PORT = "129";
    @Property(name="radiusIpAddress", value={"192.168.1.10"}, label="RADIUS IP Address")
    private String radiusIpAddress = "192.168.1.10";
    @Property(name="nasIpAddress", value={"192.168.1.11"}, label="NAS IP Address")
    private String nasIpAddress = "192.168.1.11";
    @Property(name="radiusMacAddress", value={"00:00:00:00:01:10"}, label="RADIUS MAC Address")
    private String radiusMacAddress = "00:00:00:00:01:10";
    @Property(name="nasMacAddress", value={"00:00:00:00:10:01"}, label="NAS MAC Address")
    private String nasMacAddress = "00:00:00:00:10:01";
    @Property(name="radiusSecret", value={"ONOSecret"}, label="RADIUS shared secret")
    private String radiusSecret = "ONOSecret";
    @Property(name="radiusSwitchId", value={"of:90e2ba82f97791e9"}, label="Radius switch")
    private String radiusSwitch = "of:90e2ba82f97791e9";
    @Property(name="radiusPortNumber", value={"129"}, label="Radius port")
    private String radiusPort = "129";
    protected InetAddress parsedRadiusIpAddress;
    protected InetAddress parsedNasIpAddress;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ComponentConfigService cfgService;

    @Modified
    public void modified(ComponentContext context) {
        Dictionary properties = context.getProperties();
        String s = Tools.get((Dictionary)properties, (String)"radiusIpAddress");
        try {
            this.parsedRadiusIpAddress = InetAddress.getByName(s);
            this.radiusIpAddress = Strings.isNullOrEmpty((String)s) ? DEFAULT_RADIUS_IP : s;
        }
        catch (UnknownHostException e) {
            this.log.error("Invalid RADIUS IP address specification: {}", (Object)s);
        }
        try {
            s = Tools.get((Dictionary)properties, (String)"nasIpAddress");
            this.parsedNasIpAddress = InetAddress.getByName(s);
            this.nasIpAddress = Strings.isNullOrEmpty((String)s) ? DEFAULT_NAS_IP : s;
        }
        catch (UnknownHostException e) {
            this.log.error("Invalid NAS IP address specification: {}", (Object)s);
        }
        s = Tools.get((Dictionary)properties, (String)"radiusMacAddress");
        this.radiusMacAddress = Strings.isNullOrEmpty((String)s) ? RADIUS_MAC_ADDRESS : s;
        s = Tools.get((Dictionary)properties, (String)"nasMacAddress");
        this.nasMacAddress = Strings.isNullOrEmpty((String)s) ? NAS_MAC_ADDRESS : s;
        s = Tools.get((Dictionary)properties, (String)"radiusSecret");
        this.radiusSecret = Strings.isNullOrEmpty((String)s) ? DEFAULT_RADIUS_SECRET : s;
        s = Tools.get((Dictionary)properties, (String)"radiusSwitchId");
        this.radiusSwitch = Strings.isNullOrEmpty((String)s) ? DEFAULT_RADIUS_SWITCH : s;
        s = Tools.get((Dictionary)properties, (String)"radiusPortNumber");
        this.radiusPort = Strings.isNullOrEmpty((String)s) ? DEFAULT_RADIUS_PORT : s;
    }

    @Activate
    public void activate(ComponentContext context) {
        this.cfgService.registerProperties(this.getClass());
        this.modified(context);
        this.appId = this.coreService.registerApplication("org.onosproject.aaa");
        this.packetService.addProcessor((PacketProcessor)this.processor, PacketProcessor.director((int)2));
        this.requestIntercepts();
        this.stateMachineMap = Collections.synchronizedMap(Maps.newHashMap());
        this.hostService.startMonitoringIp(IpAddress.valueOf((String)this.radiusIpAddress));
    }

    @Deactivate
    public void deactivate() {
        this.cfgService.unregisterProperties(this.getClass(), false);
        this.appId = this.coreService.registerApplication("org.onosproject.aaa");
        this.withdrawIntercepts();
        this.packetService.removeProcessor((PacketProcessor)this.processor);
        this.processor = null;
    }

    private void requestIntercepts() {
        TrafficSelector.Builder selector = DefaultTrafficSelector.builder();
        selector.matchEthType(EthType.EtherType.EAPOL.ethType().toShort());
        this.packetService.requestPackets(selector.build(), PacketPriority.CONTROL, this.appId);
        TrafficSelector radSelector = DefaultTrafficSelector.builder().matchEthType(EthType.EtherType.IPV4.ethType().toShort()).matchIPProtocol((byte)17).matchUdpDst(TpPort.tpPort((int)1812)).matchUdpSrc(TpPort.tpPort((int)1812)).build();
        this.packetService.requestPackets(radSelector, PacketPriority.CONTROL, this.appId);
    }

    private void withdrawIntercepts() {
        TrafficSelector.Builder selector = DefaultTrafficSelector.builder();
        selector.matchEthType(EthType.EtherType.EAPOL.ethType().toShort());
        this.packetService.cancelPackets(selector.build(), PacketPriority.CONTROL, this.appId);
        TrafficSelector radSelector = DefaultTrafficSelector.builder().matchEthType(EthType.EtherType.IPV4.ethType().toShort()).matchIPProtocol((byte)17).matchUdpDst(TpPort.tpPort((int)1812)).matchUdpSrc(TpPort.tpPort((int)1812)).build();
        this.packetService.cancelPackets(radSelector, PacketPriority.CONTROL, this.appId);
    }

    private static Ethernet buildEapolResponse(MacAddress dstMac, MacAddress srcMac, short vlan, byte eapolType, EAP eap) {
        Ethernet eth = new Ethernet();
        eth.setDestinationMACAddress(dstMac.toBytes());
        eth.setSourceMACAddress(srcMac.toBytes());
        eth.setEtherType(EthType.EtherType.EAPOL.ethType().toShort());
        if (vlan != -1) {
            eth.setVlanID(vlan);
        }
        EAPOL eapol = new EAPOL();
        eapol.setEapolType(eapolType);
        eapol.setPacketLength(eap.getLength());
        eapol.setPayload((IPacket)eap);
        eth.setPayload((IPacket)eapol);
        eth.setPad(true);
        return eth;
    }

    protected void bindCoreService(CoreService coreService) {
        this.coreService = coreService;
    }

    protected void unbindCoreService(CoreService coreService) {
        if (this.coreService == coreService) {
            this.coreService = null;
        }
    }

    protected void bindPacketService(PacketService packetService) {
        this.packetService = packetService;
    }

    protected void unbindPacketService(PacketService packetService) {
        if (this.packetService == packetService) {
            this.packetService = null;
        }
    }

    protected void bindHostService(HostService hostService) {
        this.hostService = hostService;
    }

    protected void unbindHostService(HostService hostService) {
        if (this.hostService == hostService) {
            this.hostService = null;
        }
    }

    protected void bindVoltTenantService(VoltTenantService voltTenantService) {
        this.voltTenantService = voltTenantService;
    }

    protected void unbindVoltTenantService(VoltTenantService voltTenantService) {
        if (this.voltTenantService == voltTenantService) {
            this.voltTenantService = null;
        }
    }

    protected void bindCfgService(ComponentConfigService componentConfigService) {
        this.cfgService = componentConfigService;
    }

    protected void unbindCfgService(ComponentConfigService componentConfigService) {
        if (this.cfgService == componentConfigService) {
            this.cfgService = null;
        }
    }

    private class ReactivePacketProcessor
    implements PacketProcessor {
        private ReactivePacketProcessor() {
        }

        public void process(PacketContext context) {
            InboundPacket pkt = context.inPacket();
            Ethernet ethPkt = pkt.parsed();
            if (ethPkt == null) {
                return;
            }
            switch (EthType.EtherType.lookup((short)ethPkt.getEtherType())) {
                case EAPOL: {
                    this.handleSupplicantPacket(context.inPacket());
                    break;
                }
                case IPV4: {
                    RADIUS radiusPacket;
                    IPv4 ipv4Packet = (IPv4)ethPkt.getPayload();
                    Ip4Address srcIp = Ip4Address.valueOf((int)ipv4Packet.getSourceAddress());
                    Ip4Address radiusIp4Address = Ip4Address.valueOf((InetAddress)AAA.this.parsedRadiusIpAddress);
                    if (!srcIp.equals((Object)radiusIp4Address) || ipv4Packet.getProtocol() != 17) break;
                    UDP udpPacket = (UDP)ipv4Packet.getPayload();
                    byte[] datagram = udpPacket.getPayload().serialize();
                    try {
                        radiusPacket = (RADIUS)RADIUS.deserializer().deserialize(datagram, 0, datagram.length);
                    }
                    catch (DeserializationException e) {
                        AAA.this.log.warn("Unable to deserialize RADIUS packet:", (Throwable)e);
                        return;
                    }
                    this.handleRadiusPacket(radiusPacket);
                    break;
                }
                default: {
                    return;
                }
            }
        }

        private void handleSupplicantPacket(InboundPacket inPacket) {
            Ethernet ethPkt = inPacket.parsed();
            MacAddress srcMAC = ethPkt.getSourceMAC();
            DeviceId deviceId = inPacket.receivedFrom().deviceId();
            PortNumber portNumber = inPacket.receivedFrom().port();
            String sessionId = deviceId.toString() + portNumber.toString();
            StateMachine stateMachine = this.getStateMachine(sessionId);
            EAPOL eapol = (EAPOL)ethPkt.getPayload();
            block3 : switch (eapol.getEapolType()) {
                case 1: {
                    try {
                        stateMachine.start();
                        stateMachine.supplicantConnectpoint = inPacket.receivedFrom();
                        EAP eapPayload = new EAP(1, stateMachine.getIdentifier(), 1, null);
                        Ethernet eth = AAA.buildEapolResponse(srcMAC, MacAddress.valueOf((long)1L), ethPkt.getVlanID(), (byte)0, eapPayload);
                        stateMachine.supplicantAddress = srcMAC;
                        stateMachine.vlanId = ethPkt.getVlanID();
                        this.sendPacketToSupplicant(eth, stateMachine.supplicantConnectpoint);
                    }
                    catch (StateMachineException e) {
                        e.printStackTrace();
                    }
                    break;
                }
                case 0: {
                    EAP eapPacket = (EAP)eapol.getPayload();
                    byte dataType = eapPacket.getDataType();
                    switch (dataType) {
                        case 1: {
                            try {
                                RADIUS radiusPayload = new RADIUS(1, eapPacket.getIdentifier());
                                radiusPayload.setIdentifier(stateMachine.getIdentifier());
                                radiusPayload.setAttribute((byte)1, eapPacket.getData());
                                stateMachine.setUsername(eapPacket.getData());
                                radiusPayload.setAttribute((byte)4, AAA.this.parsedNasIpAddress.getAddress());
                                radiusPayload.encapsulateMessage(eapPacket);
                                stateMachine.setRequestAuthenticator(radiusPayload.generateAuthCode());
                                radiusPayload.addMessageAuthenticator(AAA.this.radiusSecret);
                                this.sendRadiusMessage(radiusPayload);
                                stateMachine.requestAccess();
                            }
                            catch (StateMachineException e) {
                                e.printStackTrace();
                            }
                            break block3;
                        }
                        case 4: {
                            if (eapPacket.getIdentifier() != stateMachine.getChallengeIdentifier()) break block3;
                            RADIUS radiusPayload = new RADIUS(1, eapPacket.getIdentifier());
                            radiusPayload.setIdentifier(stateMachine.getChallengeIdentifier());
                            radiusPayload.setAttribute((byte)1, stateMachine.getUsername());
                            radiusPayload.setAttribute((byte)4, AAA.this.parsedNasIpAddress.getAddress());
                            radiusPayload.encapsulateMessage(eapPacket);
                            radiusPayload.setAttribute((byte)24, stateMachine.getChallengeState());
                            radiusPayload.addMessageAuthenticator(AAA.this.radiusSecret);
                            this.sendRadiusMessage(radiusPayload);
                            break block3;
                        }
                        case 13: {
                            try {
                                RADIUS radiusPayload = new RADIUS(1, eapPacket.getIdentifier());
                                radiusPayload.setIdentifier(stateMachine.getIdentifier());
                                radiusPayload.setAttribute((byte)1, stateMachine.getUsername());
                                radiusPayload.setAttribute((byte)4, AAA.this.parsedNasIpAddress.getAddress());
                                radiusPayload.encapsulateMessage(eapPacket);
                                radiusPayload.setAttribute((byte)24, stateMachine.getChallengeState());
                                stateMachine.setRequestAuthenticator(radiusPayload.generateAuthCode());
                                radiusPayload.addMessageAuthenticator(AAA.this.radiusSecret);
                                this.sendRadiusMessage(radiusPayload);
                                stateMachine.requestAccess();
                            }
                            catch (StateMachineException e) {
                                e.printStackTrace();
                            }
                            break block3;
                        }
                        default: {
                            return;
                        }
                    }
                }
                default: {
                    return;
                }
            }
        }

        private void handleRadiusPacket(RADIUS radiusPacket) {
            StateMachine stateMachine = this.getStateMachineById(radiusPacket.getIdentifier());
            if (stateMachine == null) {
                AAA.this.log.error("Invalid session identifier, exiting...");
                return;
            }
            EAP eapPayload = new EAP();
            Ethernet eth = null;
            switch (radiusPacket.getCode()) {
                case 11: {
                    byte[] challengeState = radiusPacket.getAttribute((byte)24).getValue();
                    eapPayload = radiusPacket.decapsulateMessage();
                    stateMachine.setChallengeInfo(eapPayload.getIdentifier(), challengeState);
                    eth = AAA.buildEapolResponse(stateMachine.supplicantAddress, MacAddress.valueOf((long)1L), stateMachine.vlanId, (byte)0, eapPayload);
                    this.sendPacketToSupplicant(eth, stateMachine.supplicantConnectpoint);
                    break;
                }
                case 2: {
                    try {
                        byte[] eapMessage = radiusPacket.getAttribute((byte)79).getValue();
                        eapPayload = new EAP();
                        eapPayload = (EAP)eapPayload.deserialize(eapMessage, 0, eapMessage.length);
                        eth = AAA.buildEapolResponse(stateMachine.supplicantAddress, MacAddress.valueOf((long)1L), stateMachine.vlanId, (byte)0, eapPayload);
                        this.sendPacketToSupplicant(eth, stateMachine.supplicantConnectpoint);
                        stateMachine.authorizeAccess();
                    }
                    catch (StateMachineException e) {
                        e.printStackTrace();
                    }
                    break;
                }
                case 3: {
                    try {
                        stateMachine.denyAccess();
                    }
                    catch (StateMachineException e) {
                        e.printStackTrace();
                    }
                    break;
                }
                default: {
                    AAA.this.log.warn("Unknown RADIUS message received with code: {}", (Object)radiusPacket.getCode());
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private StateMachine getStateMachineById(byte identifier) {
            StateMachine stateMachine = null;
            Set stateMachineSet = AAA.this.stateMachineMap.entrySet();
            Map map = AAA.this.stateMachineMap;
            synchronized (map) {
                for (Map.Entry entry : stateMachineSet) {
                    stateMachine = (StateMachine)entry.getValue();
                    if (identifier != stateMachine.getIdentifier()) continue;
                    stateMachine = (StateMachine)entry.getValue();
                    break;
                }
            }
            return stateMachine;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private StateMachine getStateMachine(String sessionId) {
            StateMachine stateMachine = null;
            Set stateMachineSet = AAA.this.stateMachineMap.entrySet();
            Map map = AAA.this.stateMachineMap;
            synchronized (map) {
                for (Map.Entry entry : stateMachineSet) {
                    if (!sessionId.equals(entry.getKey())) continue;
                    stateMachine = (StateMachine)entry.getValue();
                    break;
                }
            }
            if (stateMachine == null) {
                stateMachine = new StateMachine(sessionId, AAA.this.voltTenantService);
                AAA.this.stateMachineMap.put(sessionId, stateMachine);
            }
            return stateMachine;
        }

        private void sendRadiusMessage(RADIUS radiusMessage) {
            Set hosts = AAA.this.hostService.getHostsByIp(IpAddress.valueOf((String)AAA.this.radiusIpAddress));
            Optional<Host> odst = hosts.stream().filter(h -> h.vlan().toShort() == -1).findFirst();
            if (!odst.isPresent()) {
                AAA.this.log.info("Radius server {} is not present", (Object)AAA.this.radiusIpAddress);
                return;
            }
            Host dst = odst.get();
            UDP udp = new UDP();
            IPv4 ip4Packet = new IPv4();
            Ethernet ethPkt = new Ethernet();
            radiusMessage.setParent((IPacket)udp);
            udp.setDestinationPort(1812);
            udp.setSourcePort(1812);
            udp.setPayload((IPacket)radiusMessage);
            udp.setParent((IPacket)ip4Packet);
            ip4Packet.setSourceAddress(AAA.this.nasIpAddress);
            ip4Packet.setDestinationAddress(AAA.this.radiusIpAddress);
            ip4Packet.setProtocol((byte)17);
            ip4Packet.setPayload((IPacket)udp);
            ip4Packet.setParent((IPacket)ethPkt);
            ethPkt.setDestinationMACAddress(AAA.this.radiusMacAddress);
            ethPkt.setSourceMACAddress(AAA.this.nasMacAddress);
            ethPkt.setEtherType(Ethernet.TYPE_IPV4);
            ethPkt.setPayload((IPacket)ip4Packet);
            TrafficTreatment treatment = DefaultTrafficTreatment.builder().setOutput(PortNumber.portNumber((long)Integer.parseInt(AAA.this.radiusPort))).build();
            DefaultOutboundPacket packet = new DefaultOutboundPacket(DeviceId.deviceId((String)AAA.this.radiusSwitch), treatment, ByteBuffer.wrap(ethPkt.serialize()));
            AAA.this.packetService.emit((OutboundPacket)packet);
        }

        private void sendPacketToSupplicant(Ethernet ethernetPkt, ConnectPoint connectPoint) {
            TrafficTreatment treatment = DefaultTrafficTreatment.builder().setOutput(connectPoint.port()).build();
            DefaultOutboundPacket packet = new DefaultOutboundPacket(connectPoint.deviceId(), treatment, ByteBuffer.wrap(ethernetPkt.serialize()));
            AAA.this.packetService.emit((OutboundPacket)packet);
        }
    }
}

