/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.aaa;

import java.util.BitSet;
import org.onlab.packet.MacAddress;
import org.onosproject.aaa.Authorized;
import org.onosproject.aaa.Idle;
import org.onosproject.aaa.Pending;
import org.onosproject.aaa.Started;
import org.onosproject.aaa.State;
import org.onosproject.aaa.StateMachineException;
import org.onosproject.aaa.StateMachineInvalidTransitionException;
import org.onosproject.aaa.Unauthorized;
import org.onosproject.net.ConnectPoint;
import org.onosproject.xosintegration.VoltTenant;
import org.onosproject.xosintegration.VoltTenantService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class StateMachine {
    static final int STATE_IDLE = 0;
    static final int STATE_STARTED = 1;
    static final int STATE_PENDING = 2;
    static final int STATE_AUTHORIZED = 3;
    static final int STATE_UNAUTHORIZED = 4;
    static final int TRANSITION_START = 0;
    static final int TRANSITION_REQUEST_ACCESS = 1;
    static final int TRANSITION_AUTHORIZE_ACCESS = 2;
    static final int TRANSITION_DENY_ACCESS = 3;
    static final int TRANSITION_LOGOFF = 4;
    static BitSet bitSet = new BitSet();
    private final VoltTenantService voltService;
    private int identifier = -1;
    private byte challengeIdentifier;
    private byte[] challengeState;
    private byte[] username;
    private byte[] requestAuthenticator;
    protected ConnectPoint supplicantConnectpoint;
    protected MacAddress supplicantAddress;
    protected short vlanId;
    private String sessionId = null;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private State[] states = new State[]{new Idle(), new Started(), new Pending(), new Authorized(), new Unauthorized()};
    private int[] idleTransition = new int[]{1, 0, 0, 0, 0};
    private int[] startedTransition = new int[]{1, 2, 1, 1, 1};
    private int[] pendingTransition = new int[]{2, 2, 3, 4, 2};
    private int[] authorizedTransition = new int[]{3, 3, 3, 3, 0};
    private int[] unauthorizedTransition = new int[]{4, 4, 4, 4, 0};
    private int[][] transition = new int[][]{this.idleTransition, this.startedTransition, this.pendingTransition, this.authorizedTransition, this.unauthorizedTransition};
    private int currentState = 0;

    public StateMachine(String sessionId, VoltTenantService voltService) {
        this.log.info("Creating a new state machine for {}", (Object)sessionId);
        this.sessionId = sessionId;
        this.voltService = voltService;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    private void createIdentifier() throws StateMachineException {
        this.log.debug("Creating Identifier.");
        int index = -1;
        try {
            index = bitSet.nextClearBit(0);
            if (index == 256) {
                throw new StateMachineException("Cannot handle any new identifier. Limit is 256.");
            }
        }
        catch (IndexOutOfBoundsException e) {
            throw new StateMachineException(e.getMessage());
        }
        this.log.info("Assigning identifier {}", (Object)index);
        bitSet.set(index);
        this.identifier = index;
    }

    protected void setChallengeInfo(byte challengeIdentifier, byte[] challengeState) {
        this.challengeIdentifier = challengeIdentifier;
        this.challengeState = challengeState;
    }

    protected void setChallengeIdentifier(byte challengeIdentifier) {
        this.log.info("Set Challenge Identifier to {}", (Object)challengeIdentifier);
        this.challengeIdentifier = challengeIdentifier;
    }

    protected byte getChallengeIdentifier() {
        return this.challengeIdentifier;
    }

    protected void setChallengeState(byte[] challengeState) {
        this.log.info("Set Challenge State");
        this.challengeState = challengeState;
    }

    protected byte[] getChallengeState() {
        return this.challengeState;
    }

    protected void setUsername(byte[] username) {
        this.username = username;
    }

    protected byte[] getReqeustAuthenticator() {
        return this.requestAuthenticator;
    }

    protected void setRequestAuthenticator(byte[] authenticator) {
        this.requestAuthenticator = authenticator;
    }

    protected byte[] getUsername() {
        return this.username;
    }

    public byte getIdentifier() {
        return (byte)this.identifier;
    }

    protected void deleteIdentifier() {
        if (this.identifier != -1) {
            this.log.info("Freeing up " + this.identifier);
            bitSet.clear(this.identifier);
            this.identifier = -1;
        }
    }

    private void next(int msg) {
        this.currentState = this.transition[this.currentState][msg];
        this.log.info("Current State " + this.currentState);
    }

    public void start() throws StateMachineException {
        try {
            this.states[this.currentState].start();
            this.next(0);
            this.createIdentifier();
        }
        catch (StateMachineInvalidTransitionException e) {
            e.printStackTrace();
        }
    }

    public void requestAccess() throws StateMachineException {
        try {
            this.states[this.currentState].requestAccess();
            this.next(1);
        }
        catch (StateMachineInvalidTransitionException e) {
            e.printStackTrace();
        }
    }

    public void authorizeAccess() throws StateMachineException {
        try {
            this.states[this.currentState].radiusAccepted();
            this.next(2);
            if (this.voltService != null) {
                this.voltService.addTenant(VoltTenant.builder().withHumanReadableName("VCPE-" + this.identifier).withId((long)this.identifier).withProviderService(1L).withServiceSpecificId(String.valueOf(this.identifier)).withPort(this.supplicantConnectpoint).withVlanId(String.valueOf(this.vlanId)).build());
            }
            this.deleteIdentifier();
        }
        catch (StateMachineInvalidTransitionException e) {
            e.printStackTrace();
        }
    }

    public void denyAccess() throws StateMachineException {
        try {
            this.states[this.currentState].radiusDenied();
            this.next(3);
            this.deleteIdentifier();
        }
        catch (StateMachineInvalidTransitionException e) {
            e.printStackTrace();
        }
    }

    public void logoff() throws StateMachineException {
        try {
            this.states[this.currentState].logoff();
            this.next(4);
        }
        catch (StateMachineInvalidTransitionException e) {
            e.printStackTrace();
        }
    }

    public int getState() {
        return this.currentState;
    }

    public String toString() {
        return "sessionId: " + this.sessionId + "\t" + "identifier: " + this.identifier + "\t" + "state: " + this.currentState;
    }
}

