/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.aaa;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.onosproject.core.ApplicationId;
import org.onosproject.net.config.Config;
import org.onosproject.net.config.basics.BasicElementConfig;

public class AaaConfig
extends Config<ApplicationId> {
    private static final String RADIUS_IP = "radiusIp";
    private static final String RADIUS_SERVER_PORT = "1812";
    private static final String RADIUS_MAC = "radiusMac";
    private static final String NAS_IP = "nasIp";
    private static final String NAS_MAC = "nasMac";
    private static final String RADIUS_SECRET = "radiusSecret";
    private static final String RADIUS_SWITCH = "radiusSwitch";
    private static final String RADIUS_PORT = "radiusPort";
    protected static final String DEFAULT_RADIUS_IP = "10.128.10.4";
    protected static final String DEFAULT_RADIUS_MAC = "00:00:00:00:01:10";
    protected static final String DEFAULT_NAS_IP = "10.128.9.244";
    protected static final String DEFAULT_NAS_MAC = "00:00:00:00:10:01";
    protected static final String DEFAULT_RADIUS_SECRET = "ONOSecret";
    protected static final String DEFAULT_RADIUS_SWITCH = "of:90e2ba82f97791e9";
    protected static final String DEFAULT_RADIUS_PORT = "129";
    protected static final String DEFAULT_RADIUS_SERVER_PORT = "1812";

    private String getStringProperty(String name, String defaultValue) {
        if (this.object == null) {
            return defaultValue;
        }
        return this.get(name, defaultValue);
    }

    public InetAddress nasIp() {
        try {
            return InetAddress.getByName(this.getStringProperty(NAS_IP, DEFAULT_NAS_IP));
        }
        catch (UnknownHostException e) {
            return null;
        }
    }

    public BasicElementConfig nasIp(String ip) {
        return (BasicElementConfig)this.setOrClear(NAS_IP, ip);
    }

    public InetAddress radiusIp() {
        try {
            return InetAddress.getByName(this.getStringProperty(RADIUS_IP, DEFAULT_RADIUS_IP));
        }
        catch (UnknownHostException e) {
            return null;
        }
    }

    public BasicElementConfig radiusIp(String ip) {
        return (BasicElementConfig)this.setOrClear(RADIUS_IP, ip);
    }

    public String radiusMac() {
        return this.getStringProperty(RADIUS_MAC, DEFAULT_RADIUS_MAC);
    }

    public BasicElementConfig radiusMac(String mac) {
        return (BasicElementConfig)this.setOrClear(RADIUS_MAC, mac);
    }

    public String nasMac() {
        return this.getStringProperty(NAS_MAC, DEFAULT_NAS_MAC);
    }

    public BasicElementConfig nasMac(String mac) {
        return (BasicElementConfig)this.setOrClear(NAS_MAC, mac);
    }

    public String radiusSecret() {
        return this.getStringProperty(RADIUS_SECRET, DEFAULT_RADIUS_SECRET);
    }

    public BasicElementConfig radiusSecret(String secret) {
        return (BasicElementConfig)this.setOrClear(RADIUS_SECRET, secret);
    }

    public String radiusSwitch() {
        return this.getStringProperty(RADIUS_SWITCH, DEFAULT_RADIUS_SWITCH);
    }

    public BasicElementConfig radiusSwitch(String switchId) {
        return (BasicElementConfig)this.setOrClear(RADIUS_SWITCH, switchId);
    }

    public long radiusPort() {
        return Integer.parseInt(this.getStringProperty(RADIUS_PORT, DEFAULT_RADIUS_PORT));
    }

    public BasicElementConfig radiusPort(long port) {
        return (BasicElementConfig)this.setOrClear(RADIUS_PORT, port);
    }

    public short radiusServerUdpPort() {
        return Short.parseShort(this.getStringProperty("1812", "1812"));
    }

    public BasicElementConfig radiusServerUdpPort(short port) {
        return (BasicElementConfig)this.setOrClear("1812", Long.valueOf(port));
    }
}

