/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.aaa;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.onlab.packet.DeserializationException;
import org.onlab.packet.EAP;
import org.onlab.packet.EAPOL;
import org.onlab.packet.EthType;
import org.onlab.packet.Ethernet;
import org.onlab.packet.IPacket;
import org.onlab.packet.MacAddress;
import org.onlab.packet.RADIUS;
import org.onlab.packet.RADIUSAttribute;
import org.onosproject.aaa.AaaConfig;
import org.onosproject.aaa.StateMachine;
import org.onosproject.aaa.StateMachineException;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreService;
import org.onosproject.event.EventListener;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DeviceId;
import org.onosproject.net.PortNumber;
import org.onosproject.net.config.ConfigFactory;
import org.onosproject.net.config.NetworkConfigEvent;
import org.onosproject.net.config.NetworkConfigListener;
import org.onosproject.net.config.NetworkConfigRegistry;
import org.onosproject.net.config.basics.SubjectFactories;
import org.onosproject.net.flow.DefaultTrafficSelector;
import org.onosproject.net.flow.DefaultTrafficTreatment;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.packet.DefaultOutboundPacket;
import org.onosproject.net.packet.InboundPacket;
import org.onosproject.net.packet.OutboundPacket;
import org.onosproject.net.packet.PacketContext;
import org.onosproject.net.packet.PacketPriority;
import org.onosproject.net.packet.PacketProcessor;
import org.onosproject.net.packet.PacketService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
public class AaaManager {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected CoreService coreService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected PacketService packetService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected NetworkConfigRegistry netCfgService;
    protected InetAddress radiusIpAddress;
    protected String radiusMacAddress;
    protected InetAddress nasIpAddress;
    protected String nasMacAddress;
    protected String radiusSecret;
    protected String radiusSwitch;
    protected long radiusPort;
    protected short radiusServerPort;
    private ReactivePacketProcessor processor = new ReactivePacketProcessor();
    private ApplicationId appId;
    private DatagramSocket radiusSocket;
    private ExecutorService executor;
    private final ConfigFactory factory = new ConfigFactory<ApplicationId, AaaConfig>(SubjectFactories.APP_SUBJECT_FACTORY, AaaConfig.class, "AAA"){

        public AaaConfig createConfig() {
            return new AaaConfig();
        }
    };
    private final InternalConfigListener cfgListener = new InternalConfigListener();
    RadiusListener radiusListener = new RadiusListener();

    private static Ethernet buildEapolResponse(MacAddress dstMac, MacAddress srcMac, short vlan, byte eapolType, EAP eap) {
        Ethernet eth = new Ethernet();
        eth.setDestinationMACAddress(dstMac.toBytes());
        eth.setSourceMACAddress(srcMac.toBytes());
        eth.setEtherType(EthType.EtherType.EAPOL.ethType().toShort());
        if (vlan != -1) {
            eth.setVlanID(vlan);
        }
        EAPOL eapol = new EAPOL();
        eapol.setEapolType(eapolType);
        eapol.setPacketLength(eap.getLength());
        eapol.setPayload((IPacket)eap);
        eth.setPayload((IPacket)eapol);
        eth.setPad(true);
        return eth;
    }

    private void initializeLocalState() {
        try {
            this.radiusSocket = new DatagramSocket(this.radiusServerPort);
        }
        catch (Exception ex) {
            this.log.error("Can't open RADIUS socket", (Throwable)ex);
        }
        this.executor = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setNameFormat("AAA-radius-%d").build());
        this.executor.execute(this.radiusListener);
    }

    @Activate
    public void activate() {
        this.netCfgService.addListener((EventListener)this.cfgListener);
        this.netCfgService.registerConfigFactory(this.factory);
        this.appId = this.coreService.registerApplication("org.onosproject.aaa");
        this.cfgListener.reconfigureNetwork((AaaConfig)this.netCfgService.getConfig((Object)this.appId, AaaConfig.class));
        this.packetService.addProcessor((PacketProcessor)this.processor, PacketProcessor.director((int)2));
        this.requestIntercepts();
        StateMachine.initializeMaps();
        this.initializeLocalState();
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.withdrawIntercepts();
        this.packetService.removeProcessor((PacketProcessor)this.processor);
        this.processor = null;
        StateMachine.destroyMaps();
        this.radiusSocket.close();
        this.executor.shutdownNow();
        this.log.info("Stopped");
    }

    protected void sendRadiusPacket(RADIUS radiusPacket) {
        try {
            byte[] data = radiusPacket.serialize();
            DatagramSocket socket = this.radiusSocket;
            DatagramPacket packet = new DatagramPacket(data, data.length, this.radiusIpAddress, this.radiusServerPort);
            socket.send(packet);
        }
        catch (IOException e) {
            this.log.info("Cannot send packet to RADIUS server", (Throwable)e);
        }
    }

    private void requestIntercepts() {
        TrafficSelector.Builder selector = DefaultTrafficSelector.builder();
        selector.matchEthType(EthType.EtherType.EAPOL.ethType().toShort());
        this.packetService.requestPackets(selector.build(), PacketPriority.CONTROL, this.appId);
    }

    private void withdrawIntercepts() {
        TrafficSelector.Builder selector = DefaultTrafficSelector.builder();
        selector.matchEthType(EthType.EtherType.EAPOL.ethType().toShort());
        this.packetService.cancelPackets(selector.build(), PacketPriority.CONTROL, this.appId);
    }

    private void sendPacketToSupplicant(Ethernet ethernetPkt, ConnectPoint connectPoint) {
        TrafficTreatment treatment = DefaultTrafficTreatment.builder().setOutput(connectPoint.port()).build();
        DefaultOutboundPacket packet = new DefaultOutboundPacket(connectPoint.deviceId(), treatment, ByteBuffer.wrap(ethernetPkt.serialize()));
        this.packetService.emit((OutboundPacket)packet);
    }

    protected void bindCoreService(CoreService coreService) {
        this.coreService = coreService;
    }

    protected void unbindCoreService(CoreService coreService) {
        if (this.coreService == coreService) {
            this.coreService = null;
        }
    }

    protected void bindPacketService(PacketService packetService) {
        this.packetService = packetService;
    }

    protected void unbindPacketService(PacketService packetService) {
        if (this.packetService == packetService) {
            this.packetService = null;
        }
    }

    protected void bindNetCfgService(NetworkConfigRegistry networkConfigRegistry) {
        this.netCfgService = networkConfigRegistry;
    }

    protected void unbindNetCfgService(NetworkConfigRegistry networkConfigRegistry) {
        if (this.netCfgService == networkConfigRegistry) {
            this.netCfgService = null;
        }
    }

    private class InternalConfigListener
    implements NetworkConfigListener {
        private InternalConfigListener() {
        }

        private void reconfigureNetwork(AaaConfig cfg) {
            AaaConfig newCfg = cfg == null ? new AaaConfig() : cfg;
            if (newCfg.nasIp() != null) {
                AaaManager.this.nasIpAddress = newCfg.nasIp();
            }
            if (newCfg.radiusIp() != null) {
                AaaManager.this.radiusIpAddress = newCfg.radiusIp();
            }
            if (newCfg.radiusMac() != null) {
                AaaManager.this.radiusMacAddress = newCfg.radiusMac();
            }
            if (newCfg.nasMac() != null) {
                AaaManager.this.nasMacAddress = newCfg.nasMac();
            }
            if (newCfg.radiusSecret() != null) {
                AaaManager.this.radiusSecret = newCfg.radiusSecret();
            }
            if (newCfg.radiusSwitch() != null) {
                AaaManager.this.radiusSwitch = newCfg.radiusSwitch();
            }
            if (newCfg.radiusPort() != -1L) {
                AaaManager.this.radiusPort = newCfg.radiusPort();
            }
            if (newCfg.radiusServerUdpPort() != -1) {
                AaaManager.this.radiusServerPort = newCfg.radiusServerUdpPort();
            }
        }

        public void event(NetworkConfigEvent event) {
            if ((event.type() == NetworkConfigEvent.Type.CONFIG_ADDED || event.type() == NetworkConfigEvent.Type.CONFIG_UPDATED) && event.configClass().equals(AaaConfig.class)) {
                AaaConfig cfg = (AaaConfig)AaaManager.this.netCfgService.getConfig((Object)AaaManager.this.appId, AaaConfig.class);
                this.reconfigureNetwork(cfg);
                AaaManager.this.radiusSocket.close();
                AaaManager.this.executor.shutdownNow();
                AaaManager.this.initializeLocalState();
                AaaManager.this.log.info("Reconfigured");
            }
        }
    }

    class RadiusListener
    implements Runnable {
        RadiusListener() {
        }

        protected void handleRadiusPacket(RADIUS radiusPacket) throws StateMachineException {
            StateMachine stateMachine = StateMachine.lookupStateMachineById(radiusPacket.getIdentifier());
            if (stateMachine == null) {
                AaaManager.this.log.error("Invalid session identifier, exiting...");
                return;
            }
            switch (radiusPacket.getCode()) {
                case 11: {
                    RADIUSAttribute radiusAttrState = radiusPacket.getAttribute((byte)24);
                    byte[] challengeState = null;
                    if (radiusAttrState != null) {
                        challengeState = radiusAttrState.getValue();
                    }
                    EAP eapPayload = radiusPacket.decapsulateMessage();
                    stateMachine.setChallengeInfo(eapPayload.getIdentifier(), challengeState);
                    Ethernet eth = AaaManager.buildEapolResponse(stateMachine.supplicantAddress(), MacAddress.valueOf((String)AaaManager.this.nasMacAddress), stateMachine.vlanId(), (byte)0, eapPayload);
                    AaaManager.this.sendPacketToSupplicant(eth, stateMachine.supplicantConnectpoint());
                    break;
                }
                case 2: {
                    byte[] eapMessage = radiusPacket.getAttribute((byte)79).getValue();
                    EAP eapPayload = new EAP();
                    eapPayload = (EAP)eapPayload.deserialize(eapMessage, 0, eapMessage.length);
                    Ethernet eth = AaaManager.buildEapolResponse(stateMachine.supplicantAddress(), MacAddress.valueOf((String)AaaManager.this.nasMacAddress), stateMachine.vlanId(), (byte)0, eapPayload);
                    AaaManager.this.sendPacketToSupplicant(eth, stateMachine.supplicantConnectpoint());
                    stateMachine.authorizeAccess();
                    break;
                }
                case 3: {
                    stateMachine.denyAccess();
                    break;
                }
                default: {
                    AaaManager.this.log.warn("Unknown RADIUS message received with code: {}", (Object)radiusPacket.getCode());
                }
            }
        }

        @Override
        public void run() {
            boolean done = false;
            int packetNumber = 1;
            AaaManager.this.log.info("UDP listener thread starting up");
            while (!done) {
                try {
                    byte[] packetBuffer = new byte[4096];
                    DatagramPacket inboundBasePacket = new DatagramPacket(packetBuffer, packetBuffer.length);
                    DatagramSocket socket = AaaManager.this.radiusSocket;
                    socket.receive(inboundBasePacket);
                    AaaManager.this.log.info("Packet #{} received", (Object)packetNumber++);
                    try {
                        RADIUS inboundRadiusPacket = (RADIUS)RADIUS.deserializer().deserialize(inboundBasePacket.getData(), 0, inboundBasePacket.getLength());
                        this.handleRadiusPacket(inboundRadiusPacket);
                    }
                    catch (DeserializationException dex) {
                        AaaManager.this.log.error("Cannot deserialize packet", (Throwable)dex);
                    }
                    catch (StateMachineException sme) {
                        AaaManager.this.log.error("Illegal state machine operation", (Throwable)sme);
                    }
                }
                catch (IOException e) {
                    AaaManager.this.log.info("Socket was closed, exiting listener thread");
                    done = true;
                }
            }
        }
    }

    private class ReactivePacketProcessor
    implements PacketProcessor {
        private ReactivePacketProcessor() {
        }

        public void process(PacketContext context) {
            InboundPacket pkt = context.inPacket();
            Ethernet ethPkt = pkt.parsed();
            if (ethPkt == null) {
                return;
            }
            try {
                switch (EthType.EtherType.lookup((short)ethPkt.getEtherType())) {
                    case EAPOL: {
                        this.handleSupplicantPacket(context.inPacket());
                        break;
                    }
                    default: {
                        AaaManager.this.log.trace("Skipping Ethernet packet type {}", (Object)EthType.EtherType.lookup((short)ethPkt.getEtherType()));
                        break;
                    }
                }
            }
            catch (StateMachineException e) {
                AaaManager.this.log.warn("Unable to process RADIUS packet:", (Throwable)e);
            }
        }

        private RADIUS getRadiusPayload(StateMachine stateMachine, byte identifier, EAP eapPacket) {
            RADIUS radiusPayload = new RADIUS(1, eapPacket.getIdentifier());
            stateMachine.setRequestAuthenticator(radiusPayload.generateAuthCode());
            radiusPayload.setIdentifier(identifier);
            radiusPayload.setAttribute((byte)1, stateMachine.username());
            radiusPayload.setAttribute((byte)4, AaaManager.this.nasIpAddress.getAddress());
            radiusPayload.encapsulateMessage(eapPacket);
            return radiusPayload;
        }

        private void handleSupplicantPacket(InboundPacket inPacket) throws StateMachineException {
            Ethernet ethPkt = inPacket.parsed();
            MacAddress srcMac = ethPkt.getSourceMAC();
            DeviceId deviceId = inPacket.receivedFrom().deviceId();
            PortNumber portNumber = inPacket.receivedFrom().port();
            String sessionId = deviceId.toString() + portNumber.toString();
            StateMachine stateMachine = StateMachine.lookupStateMachineBySessionId(sessionId);
            if (stateMachine == null) {
                stateMachine = new StateMachine(sessionId);
            }
            EAPOL eapol = (EAPOL)ethPkt.getPayload();
            block0 : switch (eapol.getEapolType()) {
                case 1: {
                    stateMachine.start();
                    stateMachine.setSupplicantConnectpoint(inPacket.receivedFrom());
                    EAP eapPayload = new EAP(1, stateMachine.identifier(), 1, null);
                    Ethernet eth = AaaManager.buildEapolResponse(srcMac, MacAddress.valueOf((String)AaaManager.this.nasMacAddress), ethPkt.getVlanID(), (byte)0, eapPayload);
                    stateMachine.setSupplicantAddress(srcMac);
                    stateMachine.setVlanId(ethPkt.getVlanID());
                    AaaManager.this.sendPacketToSupplicant(eth, stateMachine.supplicantConnectpoint());
                    break;
                }
                case 2: {
                    if (stateMachine.state() != 3) break;
                    stateMachine.logoff();
                    break;
                }
                case 0: {
                    EAP eapPacket = (EAP)eapol.getPayload();
                    byte dataType = eapPacket.getDataType();
                    switch (dataType) {
                        case 1: {
                            stateMachine.setUsername(eapPacket.getData());
                            RADIUS radiusPayload = this.getRadiusPayload(stateMachine, stateMachine.identifier(), eapPacket);
                            radiusPayload.addMessageAuthenticator(AaaManager.this.radiusSecret);
                            AaaManager.this.sendRadiusPacket(radiusPayload);
                            stateMachine.requestAccess();
                            break block0;
                        }
                        case 4: {
                            if (eapPacket.getIdentifier() != stateMachine.challengeIdentifier()) break block0;
                            RADIUS radiusPayload = this.getRadiusPayload(stateMachine, stateMachine.identifier(), eapPacket);
                            if (stateMachine.challengeState() != null) {
                                radiusPayload.setAttribute((byte)24, stateMachine.challengeState());
                            }
                            radiusPayload.addMessageAuthenticator(AaaManager.this.radiusSecret);
                            AaaManager.this.sendRadiusPacket(radiusPayload);
                            break block0;
                        }
                        case 13: {
                            RADIUS radiusPayload = this.getRadiusPayload(stateMachine, stateMachine.identifier(), eapPacket);
                            if (stateMachine.challengeState() != null) {
                                radiusPayload.setAttribute((byte)24, stateMachine.challengeState());
                            }
                            stateMachine.setRequestAuthenticator(radiusPayload.generateAuthCode());
                            radiusPayload.addMessageAuthenticator(AaaManager.this.radiusSecret);
                            AaaManager.this.sendRadiusPacket(radiusPayload);
                            if (stateMachine.state() == 2) break block0;
                            stateMachine.requestAccess();
                            break block0;
                        }
                        default: {
                            return;
                        }
                    }
                }
                default: {
                    AaaManager.this.log.trace("Skipping EAPOL message {}", (Object)eapol.getEapolType());
                }
            }
        }
    }
}

