/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.aaa;

import com.google.common.collect.Maps;
import java.util.BitSet;
import java.util.Map;
import org.onlab.packet.MacAddress;
import org.onosproject.aaa.StateMachineException;
import org.onosproject.aaa.StateMachineInvalidTransitionException;
import org.onosproject.net.ConnectPoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class StateMachine {
    static final int STATE_IDLE = 0;
    static final int STATE_STARTED = 1;
    static final int STATE_PENDING = 2;
    static final int STATE_AUTHORIZED = 3;
    static final int STATE_UNAUTHORIZED = 4;
    static final int TRANSITION_START = 0;
    static final int TRANSITION_REQUEST_ACCESS = 1;
    static final int TRANSITION_AUTHORIZE_ACCESS = 2;
    static final int TRANSITION_DENY_ACCESS = 3;
    static final int TRANSITION_LOGOFF = 4;
    static BitSet bitSet = new BitSet();
    private int identifier = -1;
    private byte challengeIdentifier;
    private byte[] challengeState;
    private byte[] username;
    private byte[] requestAuthenticator;
    private ConnectPoint supplicantConnectpoint;
    private MacAddress supplicantAddress;
    private short vlanId;
    private String sessionId = null;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private State[] states = new State[]{new Idle(), new Started(), new Pending(), new Authorized(), new Unauthorized()};
    private int[] idleTransition = new int[]{1, 0, 0, 0, 0};
    private int[] startedTransition = new int[]{1, 2, 1, 1, 1};
    private int[] pendingTransition = new int[]{2, 2, 3, 4, 2};
    private int[] authorizedTransition = new int[]{1, 3, 3, 3, 0};
    private int[] unauthorizedTransition = new int[]{4, 4, 4, 4, 0};
    private int[][] transition = new int[][]{this.idleTransition, this.startedTransition, this.pendingTransition, this.authorizedTransition, this.unauthorizedTransition};
    private int currentState = 0;
    private static Map<String, StateMachine> sessionIdMap;
    private static Map<Integer, StateMachine> identifierMap;

    public static void initializeMaps() {
        sessionIdMap = Maps.newConcurrentMap();
        identifierMap = Maps.newConcurrentMap();
    }

    public static void destroyMaps() {
        sessionIdMap = null;
        identifierMap = null;
    }

    public static Map<String, StateMachine> sessionIdMap() {
        return sessionIdMap;
    }

    public static StateMachine lookupStateMachineById(byte identifier) {
        return identifierMap.get(identifier);
    }

    public static StateMachine lookupStateMachineBySessionId(String sessionId) {
        return sessionIdMap.get(sessionId);
    }

    public StateMachine(String sessionId) {
        this.log.info("Creating a new state machine for {}", (Object)sessionId);
        this.sessionId = sessionId;
        sessionIdMap.put(sessionId, this);
    }

    public ConnectPoint supplicantConnectpoint() {
        return this.supplicantConnectpoint;
    }

    public void setSupplicantConnectpoint(ConnectPoint supplicantConnectpoint) {
        this.supplicantConnectpoint = supplicantConnectpoint;
    }

    public MacAddress supplicantAddress() {
        return this.supplicantAddress;
    }

    public void setSupplicantAddress(MacAddress supplicantAddress) {
        this.supplicantAddress = supplicantAddress;
    }

    public short vlanId() {
        return this.vlanId;
    }

    public void setVlanId(short vlanId) {
        this.vlanId = vlanId;
    }

    public String sessionId() {
        return this.sessionId;
    }

    private void createIdentifier() throws StateMachineException {
        int index;
        this.log.debug("Creating Identifier.");
        try {
            index = bitSet.nextClearBit(0);
            if (index == 256) {
                throw new StateMachineException("Cannot handle any new identifier. Limit is 256.");
            }
        }
        catch (IndexOutOfBoundsException e) {
            throw new StateMachineException(e.getMessage());
        }
        this.log.info("Assigning identifier {}", (Object)index);
        bitSet.set(index);
        this.identifier = index;
    }

    protected void setChallengeInfo(byte challengeIdentifier, byte[] challengeState) {
        this.challengeIdentifier = challengeIdentifier;
        this.challengeState = challengeState;
    }

    protected void setChallengeIdentifier(byte challengeIdentifier) {
        this.log.info("Set Challenge Identifier to {}", (Object)challengeIdentifier);
        this.challengeIdentifier = challengeIdentifier;
    }

    protected byte challengeIdentifier() {
        return this.challengeIdentifier;
    }

    protected void setChallengeState(byte[] challengeState) {
        this.log.info("Set Challenge State");
        this.challengeState = challengeState;
    }

    protected byte[] challengeState() {
        return this.challengeState;
    }

    protected void setUsername(byte[] username) {
        this.username = username;
    }

    protected byte[] requestAuthenticator() {
        return this.requestAuthenticator;
    }

    protected void setRequestAuthenticator(byte[] authenticator) {
        this.requestAuthenticator = authenticator;
    }

    protected byte[] username() {
        return this.username;
    }

    public byte identifier() {
        return (byte)this.identifier;
    }

    protected void deleteIdentifier() {
        if (this.identifier != -1) {
            this.log.info("Freeing up " + this.identifier);
            bitSet.clear(this.identifier);
            this.identifier = -1;
        }
    }

    private void next(int msg) {
        this.currentState = this.transition[this.currentState][msg];
        this.log.info("Current State " + this.currentState);
    }

    public void start() throws StateMachineException {
        this.states[this.currentState].start();
        this.next(0);
        this.createIdentifier();
        identifierMap.put(this.identifier, this);
    }

    public void requestAccess() throws StateMachineException {
        this.states[this.currentState].requestAccess();
        this.next(1);
    }

    public void authorizeAccess() throws StateMachineException {
        this.states[this.currentState].radiusAccepted();
        this.next(2);
        this.deleteIdentifier();
    }

    public void denyAccess() throws StateMachineException {
        this.states[this.currentState].radiusDenied();
        this.next(3);
        this.deleteIdentifier();
    }

    public void logoff() throws StateMachineException {
        this.states[this.currentState].logoff();
        this.next(4);
    }

    public int state() {
        return this.currentState;
    }

    public String toString() {
        return "sessionId: " + this.sessionId + "\t" + "identifier: " + this.identifier + "\t" + "state: " + this.currentState;
    }

    class Unauthorized
    extends State {
        private final Logger log;
        private String name;

        Unauthorized() {
            this.log = LoggerFactory.getLogger(this.getClass());
            this.name = "UNAUTHORIZED_STATE";
        }

        @Override
        public void logoff() {
            this.log.info("Moving from UNAUTHORIZED state to IDLE state.");
        }
    }

    class Authorized
    extends State {
        private final Logger log;
        private String name;

        Authorized() {
            this.log = LoggerFactory.getLogger(this.getClass());
            this.name = "AUTHORIZED_STATE";
        }

        @Override
        public void start() {
            this.log.info("Moving from AUTHORIZED state to STARTED state.");
        }

        @Override
        public void logoff() {
            this.log.info("Moving from AUTHORIZED state to IDLE state.");
        }
    }

    class Pending
    extends State {
        private final Logger log;
        private String name;

        Pending() {
            this.log = LoggerFactory.getLogger(this.getClass());
            this.name = "PENDING_STATE";
        }

        @Override
        public void radiusAccepted() {
            this.log.info("Moving from PENDING state to AUTHORIZED state.");
        }

        @Override
        public void radiusDenied() {
            this.log.info("Moving from PENDING state to UNAUTHORIZED state.");
        }
    }

    class Started
    extends State {
        private final Logger log;
        private String name;

        Started() {
            this.log = LoggerFactory.getLogger(this.getClass());
            this.name = "STARTED_STATE";
        }

        @Override
        public void requestAccess() {
            this.log.info("Moving from STARTED state to PENDING state.");
        }
    }

    class Idle
    extends State {
        private final Logger log;
        private String name;

        Idle() {
            this.log = LoggerFactory.getLogger(this.getClass());
            this.name = "IDLE_STATE";
        }

        @Override
        public void start() {
            this.log.info("Moving from IDLE state to STARTED state.");
        }
    }

    abstract class State {
        private final Logger log = LoggerFactory.getLogger(this.getClass());
        private String name = "State";

        State() {
        }

        public void start() throws StateMachineInvalidTransitionException {
            this.log.warn("START transition from this state is not allowed.");
        }

        public void requestAccess() throws StateMachineInvalidTransitionException {
            this.log.warn("REQUEST ACCESS transition from this state is not allowed.");
        }

        public void radiusAccepted() throws StateMachineInvalidTransitionException {
            this.log.warn("AUTHORIZE ACCESS transition from this state is not allowed.");
        }

        public void radiusDenied() throws StateMachineInvalidTransitionException {
            this.log.warn("DENY ACCESS transition from this state is not allowed.");
        }

        public void logoff() throws StateMachineInvalidTransitionException {
            this.log.warn("LOGOFF transition from this state is not allowed.");
        }
    }
}

