/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.aaa;

import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.onlab.packet.EAP;
import org.onlab.packet.EAPOL;
import org.onlab.packet.Ethernet;
import org.onosproject.aaa.AaaConfig;
import org.onosproject.aaa.AaaManager;
import org.onosproject.aaa.AaaTestBase;
import org.onosproject.aaa.StateMachine;
import org.onosproject.core.CoreServiceAdapter;
import org.onosproject.net.config.Config;
import org.onosproject.net.config.NetworkConfigRegistryAdapter;

@Ignore(value="This should not be run as part of the standard build")
public class AaaIntegrationTest
extends AaaTestBase {
    private AaaManager aaa;

    @Before
    public void setUp() {
        this.aaa = new AaaManager();
        this.aaa.netCfgService = new TestNetworkConfigRegistry();
        this.aaa.coreService = new CoreServiceAdapter();
        this.aaa.packetService = new AaaTestBase.MockPacketService(this);
        this.aaa.activate();
    }

    private Ethernet fetchPacket(int index) {
        for (int iteration = 0; iteration < 20; ++iteration) {
            if (this.savedPackets.size() > index) {
                return (Ethernet)this.savedPackets.get(index);
            }
            try {
                Thread.sleep(250L);
                continue;
            }
            catch (Exception ex) {
                return null;
            }
        }
        return null;
    }

    @Test
    public void testAuthentication() throws Exception {
        Ethernet startPacket = this.constructSupplicantStartPacket();
        this.sendPacket(startPacket);
        Ethernet responsePacket = this.fetchPacket(0);
        Assert.assertThat((Object)responsePacket, (Matcher)Matchers.notNullValue());
        this.checkRadiusPacket(this.aaa, responsePacket, (byte)1);
        Ethernet identifyPacket = this.constructSupplicantIdentifyPacket(null, (byte)1, (byte)1, null);
        this.sendPacket(identifyPacket);
        StateMachine stateMachine = StateMachine.lookupStateMachineBySessionId((String)"of:11");
        Assert.assertThat((Object)stateMachine, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)stateMachine.state(), (Matcher)Matchers.is((Object)2));
        Ethernet radiusChallengeMD5Packet = this.fetchPacket(1);
        Assert.assertThat((Object)radiusChallengeMD5Packet, (Matcher)Matchers.notNullValue());
        this.checkRadiusPacket(this.aaa, radiusChallengeMD5Packet, (byte)1);
        Ethernet md5RadiusPacket = this.constructSupplicantIdentifyPacket(stateMachine, (byte)4, stateMachine.challengeIdentifier(), radiusChallengeMD5Packet);
        this.sendPacket(md5RadiusPacket);
        Ethernet successRadiusPacket = this.fetchPacket(2);
        Assert.assertThat((Object)successRadiusPacket, (Matcher)Matchers.notNullValue());
        EAPOL successEapol = (EAPOL)successRadiusPacket.getPayload();
        EAP successEap = (EAP)successEapol.getPayload();
        Assert.assertThat((Object)successEap.getCode(), (Matcher)Matchers.is((Object)3));
        Assert.assertThat((Object)stateMachine, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)stateMachine.state(), (Matcher)Matchers.is((Object)3));
    }

    static final class TestNetworkConfigRegistry
    extends NetworkConfigRegistryAdapter {
        TestNetworkConfigRegistry() {
        }

        public <S, C extends Config<S>> C getConfig(S subject, Class<C> configClass) {
            return (C)new AaaConfig();
        }
    }
}

