/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.aaa;

import com.google.common.base.Charsets;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.onlab.packet.BasePacket;
import org.onlab.packet.DeserializationException;
import org.onlab.packet.EAP;
import org.onlab.packet.Ethernet;
import org.onlab.packet.IPacket;
import org.onlab.packet.IpAddress;
import org.onlab.packet.RADIUS;
import org.onosproject.aaa.AaaConfig;
import org.onosproject.aaa.AaaManager;
import org.onosproject.aaa.AaaTestBase;
import org.onosproject.aaa.StateMachine;
import org.onosproject.core.CoreServiceAdapter;
import org.onosproject.net.config.Config;
import org.onosproject.net.config.NetworkConfigRegistryAdapter;

public class AaaManagerTest
extends AaaTestBase {
    static final String BAD_IP_ADDRESS = "198.51.100.0";
    private AaaManager aaaManager;

    private RADIUS constructRadiusCodeAccessChallengePacket(byte challengeCode, byte challengeType) {
        String challenge = "12345678901234567";
        EAP eap = new EAP(challengeType, 1, challengeType, challenge.getBytes(Charsets.US_ASCII));
        eap.setIdentifier((byte)1);
        RADIUS radius = new RADIUS();
        radius.setCode(challengeCode);
        radius.setAttribute((byte)24, challenge.getBytes(Charsets.US_ASCII));
        radius.setPayload((IPacket)eap);
        radius.setAttribute((byte)79, eap.serialize());
        return radius;
    }

    @Before
    public void setUp() {
        this.aaaManager = new AaaManagerWithoutRadiusServer();
        this.aaaManager.netCfgService = new TestNetworkConfigRegistry();
        this.aaaManager.coreService = new CoreServiceAdapter();
        this.aaaManager.packetService = new AaaTestBase.MockPacketService(this);
        this.aaaManager.activate();
    }

    @After
    public void tearDown() {
        this.aaaManager.deactivate();
    }

    private void checkRadiusPacketFromSupplicant(RADIUS radius) throws DeserializationException {
        Assert.assertThat((Object)radius, (Matcher)Matchers.notNullValue());
        EAP eap = radius.decapsulateMessage();
        Assert.assertThat((Object)eap, (Matcher)Matchers.notNullValue());
    }

    private BasePacket fetchPacket(int index) {
        BasePacket packet = (BasePacket)this.savedPackets.get(index);
        Assert.assertThat((Object)packet, (Matcher)Matchers.notNullValue());
        return packet;
    }

    @Test
    public void testAuthentication() throws Exception {
        Ethernet startPacket = this.constructSupplicantStartPacket();
        this.sendPacket(startPacket);
        Ethernet responsePacket = (Ethernet)this.fetchPacket(0);
        this.checkRadiusPacket(this.aaaManager, responsePacket, (byte)1);
        Ethernet identifyPacket = this.constructSupplicantIdentifyPacket(null, (byte)1, (byte)1, null);
        this.sendPacket(identifyPacket);
        RADIUS radiusIdentifyPacket = (RADIUS)this.fetchPacket(1);
        this.checkRadiusPacketFromSupplicant(radiusIdentifyPacket);
        Assert.assertThat((Object)radiusIdentifyPacket.getCode(), (Matcher)Matchers.is((Object)1));
        Assert.assertThat((Object)new String(radiusIdentifyPacket.getAttribute((byte)1).getValue()), (Matcher)Matchers.is((Object)"testuser"));
        IpAddress nasIp = IpAddress.valueOf((IpAddress.Version)IpAddress.Version.INET, (byte[])radiusIdentifyPacket.getAttribute((byte)4).getValue());
        Assert.assertThat((Object)nasIp.toString(), (Matcher)Matchers.is((Object)this.aaaManager.nasIpAddress.getHostAddress()));
        StateMachine stateMachine = StateMachine.lookupStateMachineBySessionId((String)"of:11");
        Assert.assertThat((Object)stateMachine, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)stateMachine.state(), (Matcher)Matchers.is((Object)2));
        RADIUS radiusCodeAccessChallengePacket = this.constructRadiusCodeAccessChallengePacket((byte)11, (byte)4);
        this.aaaManager.radiusListener.handleRadiusPacket(radiusCodeAccessChallengePacket);
        Ethernet radiusChallengeMD5Packet = (Ethernet)this.fetchPacket(2);
        this.checkRadiusPacket(this.aaaManager, radiusChallengeMD5Packet, (byte)4);
        Ethernet md5RadiusPacket = this.constructSupplicantIdentifyPacket(stateMachine, (byte)4, stateMachine.challengeIdentifier(), radiusChallengeMD5Packet);
        this.sendPacket(md5RadiusPacket);
        RADIUS responseMd5RadiusPacket = (RADIUS)this.fetchPacket(3);
        this.checkRadiusPacketFromSupplicant(responseMd5RadiusPacket);
        Assert.assertThat((Object)responseMd5RadiusPacket.getIdentifier(), (Matcher)Matchers.is((Object)0));
        Assert.assertThat((Object)responseMd5RadiusPacket.getCode(), (Matcher)Matchers.is((Object)1));
        Assert.assertThat((Object)stateMachine, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)stateMachine.state(), (Matcher)Matchers.is((Object)2));
        RADIUS successPacket = this.constructRadiusCodeAccessChallengePacket((byte)2, (byte)3);
        this.aaaManager.radiusListener.handleRadiusPacket(successPacket);
        Ethernet supplicantSuccessPacket = (Ethernet)this.fetchPacket(4);
        this.checkRadiusPacket(this.aaaManager, supplicantSuccessPacket, (byte)3);
        Assert.assertThat((Object)stateMachine, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)stateMachine.state(), (Matcher)Matchers.is((Object)3));
    }

    @Test
    public void testConfig() {
        Assert.assertThat((Object)this.aaaManager.nasIpAddress.getHostAddress(), (Matcher)Matchers.is((Object)"10.128.9.244"));
        Assert.assertThat((Object)this.aaaManager.nasMacAddress, (Matcher)Matchers.is((Object)"00:00:00:00:10:01"));
        Assert.assertThat((Object)this.aaaManager.radiusIpAddress.getHostAddress(), (Matcher)Matchers.is((Object)BAD_IP_ADDRESS));
        Assert.assertThat((Object)this.aaaManager.radiusMacAddress, (Matcher)Matchers.is((Object)"00:00:00:00:01:10"));
    }

    private static final class TestNetworkConfigRegistry
    extends NetworkConfigRegistryAdapter {
        private TestNetworkConfigRegistry() {
        }

        public <S, C extends Config<S>> C getConfig(S subject, Class<C> configClass) {
            MockAaaConfig aaaConfig = new MockAaaConfig();
            return (C)((Object)aaaConfig);
        }
    }

    static class MockAaaConfig
    extends AaaConfig {
        MockAaaConfig() {
        }

        public InetAddress radiusIp() {
            try {
                return InetAddress.getByName(AaaManagerTest.BAD_IP_ADDRESS);
            }
            catch (UnknownHostException ex) {
                throw new IllegalStateException(ex);
            }
        }
    }

    class AaaManagerWithoutRadiusServer
    extends AaaManager {
        AaaManagerWithoutRadiusServer() {
        }

        protected void sendRadiusPacket(RADIUS radiusPacket) {
            AaaManagerTest.this.savePacket((BasePacket)radiusPacket);
        }
    }
}

