/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.aaa;

import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.util.LinkedList;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.onlab.packet.BasePacket;
import org.onlab.packet.EAP;
import org.onlab.packet.EAPOL;
import org.onlab.packet.EthType;
import org.onlab.packet.Ethernet;
import org.onlab.packet.IPacket;
import org.onlab.packet.MacAddress;
import org.onosproject.aaa.AaaManager;
import org.onosproject.aaa.StateMachine;
import org.onosproject.net.NetTestTools;
import org.onosproject.net.packet.DefaultInboundPacket;
import org.onosproject.net.packet.DefaultPacketContext;
import org.onosproject.net.packet.InboundPacket;
import org.onosproject.net.packet.OutboundPacket;
import org.onosproject.net.packet.PacketContext;
import org.onosproject.net.packet.PacketProcessor;
import org.onosproject.net.packet.PacketServiceAdapter;

public class AaaTestBase {
    MacAddress clientMac = MacAddress.valueOf((String)"1a:1a:1a:1a:1a:1a");
    MacAddress serverMac = MacAddress.valueOf((String)"2a:2a:2a:2a:2a:2a");
    static final String SESSION_ID = "of:11";
    List<BasePacket> savedPackets = new LinkedList<BasePacket>();
    PacketProcessor packetProcessor;

    void savePacket(BasePacket packet) {
        this.savedPackets.add(packet);
    }

    void sendPacket(Ethernet reply) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(reply.serialize());
        DefaultInboundPacket inPacket = new DefaultInboundPacket(NetTestTools.connectPoint((String)"1", (int)1), reply, byteBuffer);
        TestPacketContext context = new TestPacketContext(127L, (InboundPacket)inPacket, null, false);
        this.packetProcessor.process((PacketContext)context);
    }

    Ethernet constructSupplicantIdentifyPacket(StateMachine stateMachine, byte type, byte id, Ethernet radiusChallenge) throws Exception {
        EAPOL eapol;
        Ethernet eth = new Ethernet();
        eth.setDestinationMACAddress(this.clientMac.toBytes());
        eth.setSourceMACAddress(this.serverMac.toBytes());
        eth.setEtherType(EthType.EtherType.EAPOL.ethType().toShort());
        eth.setVlanID((short)2);
        String username = "testuser";
        byte[] data = username.getBytes();
        if (type == 4) {
            String password = "testpassword";
            eapol = (EAPOL)radiusChallenge.getPayload();
            EAP eap = (EAP)eapol.getPayload();
            byte[] identifier = new byte[password.length() + eap.getData().length];
            identifier[0] = stateMachine.challengeIdentifier();
            System.arraycopy(password.getBytes(), 0, identifier, 1, password.length());
            System.arraycopy(eap.getData(), 1, identifier, 1 + password.length(), 16);
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] hash = md.digest(identifier);
            data = new byte[17];
            data[0] = 16;
            System.arraycopy(hash, 0, data, 1, 16);
        }
        EAP eap = new EAP(2, 1, type, data);
        eap.setIdentifier(id);
        eapol = new EAPOL();
        eapol.setEapolType((byte)0);
        eapol.setPacketLength(eap.getLength());
        eapol.setPayload((IPacket)eap);
        eth.setPayload((IPacket)eapol);
        eth.setPad(true);
        return eth;
    }

    Ethernet constructSupplicantStartPacket() {
        Ethernet eth = new Ethernet();
        eth.setDestinationMACAddress(this.clientMac.toBytes());
        eth.setSourceMACAddress(this.serverMac.toBytes());
        eth.setEtherType(EthType.EtherType.EAPOL.ethType().toShort());
        eth.setVlanID((short)2);
        EAP eap = new EAP(1, 2, 1, null);
        EAPOL eapol = new EAPOL();
        eapol.setEapolType((byte)1);
        eapol.setPacketLength(eap.getLength());
        eapol.setPayload((IPacket)eap);
        eth.setPayload((IPacket)eapol);
        eth.setPad(true);
        return eth;
    }

    void checkRadiusPacket(AaaManager aaaManager, Ethernet radiusPacket, byte code) {
        Assert.assertThat((Object)radiusPacket.getSourceMAC(), (Matcher)Matchers.is((Object)MacAddress.valueOf((String)aaaManager.nasMacAddress)));
        Assert.assertThat((Object)radiusPacket.getDestinationMAC(), (Matcher)Matchers.is((Object)this.serverMac));
        Assert.assertThat((Object)radiusPacket.getPayload(), (Matcher)Matchers.instanceOf(EAPOL.class));
        EAPOL eapol = (EAPOL)radiusPacket.getPayload();
        Assert.assertThat((Object)eapol, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)eapol.getEapolType(), (Matcher)Matchers.is((Object)0));
        Assert.assertThat((Object)eapol.getPayload(), (Matcher)Matchers.instanceOf(EAP.class));
        EAP eap = (EAP)eapol.getPayload();
        Assert.assertThat((Object)eap, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)eap.getCode(), (Matcher)Matchers.is((Object)code));
    }

    final class TestPacketContext
    extends DefaultPacketContext {
        private TestPacketContext(long time, InboundPacket inPkt, OutboundPacket outPkt, boolean block) {
            super(time, inPkt, outPkt, block);
        }

        public void send() {
        }
    }

    class MockPacketService
    extends PacketServiceAdapter {
        MockPacketService() {
        }

        public void addProcessor(PacketProcessor processor, int priority) {
            AaaTestBase.this.packetProcessor = processor;
        }

        public void emit(OutboundPacket packet) {
            try {
                Ethernet eth = (Ethernet)Ethernet.deserializer().deserialize(packet.data().array(), 0, packet.data().array().length);
                AaaTestBase.this.savePacket((BasePacket)eth);
            }
            catch (Exception e) {
                Assert.fail((String)e.getMessage());
            }
        }
    }
}

