/*
 * Decompiled with CFR 0.152.
 */
package org.onos.acl.web;

import com.sun.jersey.api.client.WebResource;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.easymock.EasyMock;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.onlab.osgi.ServiceDirectory;
import org.onlab.rest.BaseResource;
import org.onos.acl.AclRule;
import org.onos.acl.AclService;
import org.onos.acl.AclStore;
import org.onos.acl.web.ResourceTest;
import org.onos.acl.web.TestServiceDirectory;
import org.onosproject.core.IdGenerator;

public class AclWebResourceTest
extends ResourceTest {
    final AclService mockAclService = (AclService)EasyMock.createMock(AclService.class);
    final AclStore mockAclStore = (AclStore)EasyMock.createMock(AclStore.class);
    final List<AclRule> rules = new ArrayList<AclRule>();

    @Before
    public void setUp() {
        EasyMock.expect((Object)this.mockAclService.getAclRules()).andReturn(this.rules).anyTimes();
        TestServiceDirectory testDirectory = new TestServiceDirectory().add(AclService.class, this.mockAclService).add(AclStore.class, this.mockAclStore);
        BaseResource.setServiceDirectory((ServiceDirectory)testDirectory);
    }

    @After
    public void tearDown() {
        EasyMock.verify((Object[])new Object[]{this.mockAclService});
    }

    @Test
    public void testaddRule() throws IOException {
        WebResource rs = this.resource();
        MockIdGenerator idGenerator = new MockIdGenerator();
        AclRule.bindIdGenerator((IdGenerator)idGenerator);
        EasyMock.replay((Object[])new Object[]{this.mockAclService});
        String json = "{\"ipProto\":\"TCP\",\"dstTpPort\":\"80\"}";
        String response = (String)rs.path("add").post(String.class, (Object)json);
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"Failed! Either srcIp or dstIp must be assigned."));
        json = "{\"ipProto\":\"TCP\",\"srcIp\":\"10.0.0.1\",\"dstTpPort\":\"80\",\"action\":\"DENY\"}";
        response = (String)rs.path("add").post(String.class, (Object)json);
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"Malformed IPv4 prefix string: 10.0.0.1. Address must take form \"x.x.x.x/y\""));
        json = "{\"ipProto\":\"TCP\",\"srcIp\":\"10.0.0.256/32\",\"dstTpPort\":\"80\",\"action\":\"DENY\"}";
        response = (String)rs.path("add").post(String.class, (Object)json);
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"Invalid IP address string: 10.0.0.256"));
        json = "{\"ipProto\":\"TCP\",\"srcIp\":\"10.0.01/32\",\"dstTpPort\":\"80\",\"action\":\"DENY\"}";
        response = (String)rs.path("add").post(String.class, (Object)json);
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"Invalid IP address string: 10.0.01"));
        json = "{\"ipProto\":\"TCP\",\"srcIp\":\"10.0.0.1/a\",\"dstTpPort\":\"80\",\"action\":\"DENY\"}";
        response = (String)rs.path("add").post(String.class, (Object)json);
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"Failed! For input string: \"a\""));
        json = "{\"ipProto\":\"TCP\",\"srcIp\":\"10.0.0.1/33\",\"dstTpPort\":\"80\",\"action\":\"DENY\"}";
        response = (String)rs.path("add").post(String.class, (Object)json);
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"Invalid prefix length 33. The value must be in the interval [0, 32]"));
        json = "{\"ipProto\":\"ARP\",\"srcIp\":\"10.0.0.1/32\",\"dstTpPort\":\"80\",\"action\":\"DENY\"}";
        response = (String)rs.path("add").post(String.class, (Object)json);
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"ipProto must be assigned to TCP, UDP, or ICMP."));
        json = "{\"ipProto\":\"TCP\",\"srcIp\":\"10.0.0.1/32\",\"dstTpPort\":\"a\",\"action\":\"DENY\"}";
        response = (String)rs.path("add").post(String.class, (Object)json);
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"dstTpPort must be assigned to a numerical value."));
        json = "{\"ipProto\":\"TCP\",\"srcIp\":\"10.0.0.1/32\",\"dstTpPort\":\"80\",\"action\":\"PERMIT\"}";
        response = (String)rs.path("add").post(String.class, (Object)json);
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"action must be assigned to ALLOW or DENY."));
    }

    private class MockIdGenerator
    implements IdGenerator {
        private AtomicLong nextId = new AtomicLong(0L);

        private MockIdGenerator() {
        }

        public long getNewId() {
            return this.nextId.getAndIncrement();
        }
    }
}

