/*
 * Decompiled with CFR 0.152.
 */
package org.onos.acl;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;
import org.onlab.packet.Ip4Prefix;
import org.onos.acl.AclRule;
import org.onos.acl.RuleId;
import org.onosproject.core.IdGenerator;

public final class AclRule {
    private final RuleId id;
    private final Ip4Prefix srcIp;
    private final Ip4Prefix dstIp;
    private final byte ipProto;
    private final short dstTpPort;
    private final Action action;
    private static IdGenerator idGenerator;

    private AclRule() {
        this.id = null;
        this.srcIp = null;
        this.dstIp = null;
        this.ipProto = 0;
        this.dstTpPort = 0;
        this.action = null;
    }

    private AclRule(Ip4Prefix srcIp, Ip4Prefix dstIp, byte ipProto, short dstTpPort, Action action) {
        Preconditions.checkState((idGenerator != null ? 1 : 0) != 0, (Object)"Id generator is not bound.");
        this.id = RuleId.valueOf((long)idGenerator.getNewId());
        this.srcIp = srcIp;
        this.dstIp = dstIp;
        this.ipProto = ipProto;
        this.dstTpPort = dstTpPort;
        this.action = action;
    }

    private boolean checkCIDRinCIDR(Ip4Prefix cidrAddr1, Ip4Prefix cidrAddr2) {
        if (cidrAddr2 == null) {
            return true;
        }
        if (cidrAddr1 == null) {
            return false;
        }
        if (cidrAddr1.prefixLength() < cidrAddr2.prefixLength()) {
            return false;
        }
        int offset = 32 - cidrAddr2.prefixLength();
        int cidr1Prefix = cidrAddr1.address().toInt();
        int cidr2Prefix = cidrAddr2.address().toInt();
        cidr1Prefix >>= offset;
        cidr2Prefix >>= offset;
        return (cidr1Prefix <<= offset) == (cidr2Prefix <<= offset);
    }

    public boolean checkMatch(AclRule r) {
        return !(this.dstTpPort != r.dstTpPort && r.dstTpPort != 0 || this.ipProto != r.ipProto && r.ipProto != 0 || !this.checkCIDRinCIDR(this.srcIp(), r.srcIp()) || !this.checkCIDRinCIDR(this.dstIp(), r.dstIp()));
    }

    public static Builder builder() {
        return new Builder(null);
    }

    public static void bindIdGenerator(IdGenerator newIdGenerator) {
        Preconditions.checkState((idGenerator == null ? 1 : 0) != 0, (Object)"Id generator is already bound.");
        idGenerator = (IdGenerator)Preconditions.checkNotNull((Object)newIdGenerator);
    }

    public RuleId id() {
        return this.id;
    }

    public Ip4Prefix srcIp() {
        return this.srcIp;
    }

    public Ip4Prefix dstIp() {
        return this.dstIp;
    }

    public byte ipProto() {
        return this.ipProto;
    }

    public short dstTpPort() {
        return this.dstTpPort;
    }

    public Action action() {
        return this.action;
    }

    public int hashCode() {
        return Objects.hash(this.action, this.id.fingerprint(), this.ipProto, this.srcIp, this.dstIp, this.dstTpPort);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof AclRule) {
            AclRule that = (AclRule)obj;
            return Objects.equals(this.id, that.id) && Objects.equals(this.srcIp, that.srcIp) && Objects.equals(this.dstIp, that.dstIp) && Objects.equals(this.ipProto, that.ipProto) && Objects.equals(this.dstTpPort, that.dstTpPort) && Objects.equals(this.action, that.action);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).omitNullValues().add("id", (Object)this.id).add("srcIp", (Object)this.srcIp).add("dstIp", (Object)this.dstIp).add("ipProto", (int)this.ipProto).add("dstTpPort", (int)this.dstTpPort).add("action", (Object)this.action).toString();
    }
}

