/*
 * Decompiled with CFR 0.152.
 */
package org.onos.acl;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.onos.acl.AclRule;
import org.onos.acl.AclService;
import org.onos.acl.AclStore;
import org.onos.acl.AclWebResource;
import org.onos.acl.RuleId;
import org.onosproject.rest.AbstractWebResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="")
public class AclWebResource
extends AbstractWebResource {
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    @GET
    public Response queryAclRule() {
        List rules = ((AclService)this.get(AclService.class)).getAclRules();
        ObjectMapper mapper = new ObjectMapper();
        ObjectNode root = mapper.createObjectNode();
        ArrayNode arrayNode = mapper.createArrayNode();
        for (AclRule rule : rules) {
            ObjectNode node = mapper.createObjectNode();
            node.put("id", rule.id().toString());
            if (rule.srcIp() != null) {
                node.put("srcIp", rule.srcIp().toString());
            }
            if (rule.dstIp() != null) {
                node.put("dstIp", rule.dstIp().toString());
            }
            if (rule.ipProto() != 0) {
                switch (rule.ipProto()) {
                    case 1: {
                        node.put("ipProto", "ICMP");
                        break;
                    }
                    case 6: {
                        node.put("ipProto", "TCP");
                        break;
                    }
                    case 17: {
                        node.put("ipProto", "UDP");
                        break;
                    }
                }
            }
            if (rule.dstTpPort() != 0) {
                node.put("dstTpPort", rule.dstTpPort());
            }
            node.put("action", rule.action().toString());
            arrayNode.add((JsonNode)node);
        }
        root.set("ACL rules", (JsonNode)arrayNode);
        return Response.ok((Object)root.toString(), (MediaType)MediaType.APPLICATION_JSON_TYPE).build();
    }

    @POST
    @Path(value="add")
    public Response addAclRule(InputStream stream) {
        AclRule newRule;
        try {
            newRule = this.jsonToRule(stream);
        }
        catch (Exception e) {
            return Response.ok((Object)("{\"status\" : \"Failed! " + e.getMessage() + "\"}")).build();
        }
        String status = ((AclService)this.get(AclService.class)).addAclRule(newRule) ? "Success! New ACL rule is added." : "Failed! New ACL rule matches an existing rule.";
        return Response.ok((Object)("{\"status\" : \"" + status + "\"}")).build();
    }

    @GET
    @Path(value="remove/{id}")
    public Response removeAclRule(@PathParam(value="id") String id) {
        String status;
        RuleId ruleId = new RuleId(Long.parseLong(id.substring(2), 16));
        if (((AclStore)this.get(AclStore.class)).getAclRule(ruleId) == null) {
            status = "Failed! There is no ACL rule with this id.";
        } else {
            ((AclService)this.get(AclService.class)).removeAclRule(ruleId);
            status = "Success! ACL rule(id:" + id + ") is removed.";
        }
        return Response.ok((Object)("{\"status\" : \"" + status + "\"}")).build();
    }

    @GET
    @Path(value="clear")
    public Response clearACL() {
        ((AclService)this.get(AclService.class)).clearAcl();
        return Response.ok((Object)"{\"status\" : \"ACL is cleared.\"}").build();
    }

    private AclRule jsonToRule(InputStream stream) throws AclRuleParseException, IOException {
        ObjectMapper mapper = new ObjectMapper();
        JsonNode jsonNode = mapper.readTree(stream);
        JsonParser jp = jsonNode.traverse();
        AclRule.Builder rule = AclRule.builder();
        jp.nextToken();
        if (jp.getCurrentToken() != JsonToken.START_OBJECT) {
            throw new AclRuleParseException(this, "Expected START_OBJECT");
        }
        while (jp.nextToken() != JsonToken.END_OBJECT) {
            if (jp.getCurrentToken() != JsonToken.FIELD_NAME) {
                throw new AclRuleParseException(this, "Expected FIELD_NAME");
            }
            String key = jp.getCurrentName();
            jp.nextToken();
            String value = jp.getText();
            if ("".equals(value)) continue;
            if ("srcIp".equals(key)) {
                rule.srcIp(value);
                continue;
            }
            if ("dstIp".equals(key)) {
                rule.dstIp(value);
                continue;
            }
            if ("ipProto".equals(key)) {
                if ("TCP".equalsIgnoreCase(value)) {
                    rule.ipProto((byte)6);
                    continue;
                }
                if ("UDP".equalsIgnoreCase(value)) {
                    rule.ipProto((byte)17);
                    continue;
                }
                if ("ICMP".equalsIgnoreCase(value)) {
                    rule.ipProto((byte)1);
                    continue;
                }
                throw new AclRuleParseException(this, "ipProto must be assigned to TCP, UDP, or ICMP.");
            }
            if ("dstTpPort".equals(key)) {
                try {
                    rule.dstTpPort(Short.parseShort(value));
                    continue;
                }
                catch (NumberFormatException e) {
                    throw new AclRuleParseException(this, "dstTpPort must be assigned to a numerical value.");
                }
            }
            if (!"action".equals(key)) continue;
            if (!"allow".equalsIgnoreCase(value) && !"deny".equalsIgnoreCase(value)) {
                throw new AclRuleParseException(this, "action must be assigned to ALLOW or DENY.");
            }
            if (!"allow".equalsIgnoreCase(value)) continue;
            rule.action(AclRule.Action.ALLOW);
        }
        return rule.build();
    }
}

