/*
 * Decompiled with CFR 0.152.
 */
package org.onos.acl.impl;

import com.google.common.collect.Collections2;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onlab.util.KryoNamespace;
import org.onos.acl.AclRule;
import org.onos.acl.AclStore;
import org.onos.acl.RuleId;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreService;
import org.onosproject.net.DeviceId;
import org.onosproject.net.flow.FlowRule;
import org.onosproject.store.AbstractStore;
import org.onosproject.store.serializers.KryoNamespaces;
import org.onosproject.store.service.ConsistentMap;
import org.onosproject.store.service.Serializer;
import org.onosproject.store.service.StorageService;
import org.onosproject.store.service.Versioned;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
public class DistributedAclStore
extends AbstractStore
implements AclStore {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final int defaultFlowMaxPriority = 30000;
    private ConsistentMap<RuleId, AclRule> ruleSet;
    private ConsistentMap<DeviceId, Integer> deviceToPriority;
    private ConsistentMap<RuleId, Set<DeviceId>> ruleToDevice;
    private ConsistentMap<RuleId, Set<FlowRule>> ruleToFlow;
    private ConsistentMap<RuleId, List<RuleId>> denyRuleToAllowRule;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected StorageService storageService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected CoreService coreService;

    @Activate
    public void activate() {
        ApplicationId appId = this.coreService.getAppId("org.onosproject.acl");
        KryoNamespace.Builder serializer = KryoNamespace.newBuilder().register(KryoNamespaces.API).register(new Class[]{AclRule.class}).register(new Class[]{AclRule.Action.class}).register(new Class[]{RuleId.class});
        this.ruleSet = this.storageService.consistentMapBuilder().withSerializer(Serializer.using((KryoNamespace)serializer.build())).withName("acl-rule-set").withApplicationId(appId).withPurgeOnUninstall().build();
        this.deviceToPriority = this.storageService.consistentMapBuilder().withSerializer(Serializer.using((KryoNamespace)serializer.build())).withName("device-to-priority").withApplicationId(appId).withPurgeOnUninstall().build();
        this.ruleToFlow = this.storageService.consistentMapBuilder().withSerializer(Serializer.using((KryoNamespace)serializer.build())).withName("rule-to-flow").withApplicationId(appId).withPurgeOnUninstall().build();
        this.denyRuleToAllowRule = this.storageService.consistentMapBuilder().withSerializer(Serializer.using((KryoNamespace)serializer.build())).withName("deny-to-allow").withApplicationId(appId).withPurgeOnUninstall().build();
        this.ruleToDevice = this.storageService.consistentMapBuilder().withSerializer(Serializer.using((KryoNamespace)serializer.build())).withName("rule-to-device").withApplicationId(appId).withPurgeOnUninstall().build();
        this.log.info("Started");
    }

    @Deactivate
    public void deactive() {
        this.log.info("Stopped");
    }

    public List<AclRule> getAclRules() {
        ArrayList<AclRule> aclRules = new ArrayList<AclRule>();
        aclRules.addAll(Collections2.transform((Collection)this.ruleSet.values(), Versioned::value));
        return aclRules;
    }

    public void addAclRule(AclRule rule) {
        this.ruleSet.putIfAbsent((Object)rule.id(), (Object)rule);
    }

    public AclRule getAclRule(RuleId ruleId) {
        Versioned rule = this.ruleSet.get((Object)ruleId);
        if (rule != null) {
            return (AclRule)rule.value();
        }
        return null;
    }

    public void removeAclRule(RuleId ruleId) {
        this.ruleSet.remove((Object)ruleId);
    }

    public void clearAcl() {
        this.ruleSet.clear();
        this.deviceToPriority.clear();
        this.ruleToFlow.clear();
        this.denyRuleToAllowRule.clear();
        this.ruleToDevice.clear();
    }

    public int getPriorityByDevice(DeviceId deviceId) {
        return (Integer)this.deviceToPriority.compute((Object)deviceId, (id, priority) -> priority == null ? 30000 : priority - 1).value();
    }

    public Set<FlowRule> getFlowByRule(RuleId ruleId) {
        Versioned flowRuleSet = this.ruleToFlow.get((Object)ruleId);
        if (flowRuleSet != null) {
            return (Set)flowRuleSet.value();
        }
        return null;
    }

    public void addRuleToFlowMapping(RuleId ruleId, FlowRule flowRule) {
        this.ruleToFlow.computeIf((Object)ruleId, flowRuleSet -> flowRuleSet == null || !flowRuleSet.contains(flowRule), (id, flowRuleSet) -> {
            HashSet<FlowRule> newSet = new HashSet<FlowRule>();
            if (flowRuleSet != null) {
                newSet.addAll((Collection<FlowRule>)flowRuleSet);
            }
            newSet.add(flowRule);
            return newSet;
        });
    }

    public void removeRuleToFlowMapping(RuleId ruleId) {
        this.ruleToFlow.remove((Object)ruleId);
    }

    public List<RuleId> getAllowingRuleByDenyingRule(RuleId denyingRuleId) {
        Versioned allowRuleIdSet = this.denyRuleToAllowRule.get((Object)denyingRuleId);
        if (allowRuleIdSet != null) {
            return (List)allowRuleIdSet.value();
        }
        return null;
    }

    public void addDenyToAllowMapping(RuleId denyingRuleId, RuleId allowingRuleId) {
        this.denyRuleToAllowRule.computeIf((Object)denyingRuleId, ruleIdList -> ruleIdList == null || !ruleIdList.contains(allowingRuleId), (id, ruleIdList) -> {
            ArrayList<RuleId> newList = new ArrayList<RuleId>();
            if (ruleIdList != null) {
                newList.addAll((Collection<RuleId>)ruleIdList);
            }
            newList.add(allowingRuleId);
            return newList;
        });
    }

    public void removeDenyToAllowMapping(RuleId denyingRuleId) {
        this.denyRuleToAllowRule.remove((Object)denyingRuleId);
    }

    public boolean checkIfRuleWorksInDevice(RuleId ruleId, DeviceId deviceId) {
        return this.ruleToDevice.containsKey((Object)ruleId) && ((Set)this.ruleToDevice.get((Object)ruleId).value()).contains(deviceId);
    }

    public void addRuleToDeviceMapping(RuleId ruleId, DeviceId deviceId) {
        this.ruleToDevice.computeIf((Object)ruleId, deviceIdSet -> deviceIdSet == null || !deviceIdSet.contains(deviceId), (id, deviceIdSet) -> {
            HashSet<DeviceId> newSet = new HashSet<DeviceId>();
            if (deviceIdSet != null) {
                newSet.addAll((Collection<DeviceId>)deviceIdSet);
            }
            newSet.add(deviceId);
            return newSet;
        });
    }

    public void removeRuleToDeviceMapping(RuleId ruleId) {
        this.ruleToDevice.remove((Object)ruleId);
    }

    protected void bindStorageService(StorageService storageService) {
        this.storageService = storageService;
    }

    protected void unbindStorageService(StorageService storageService) {
        if (this.storageService == storageService) {
            this.storageService = null;
        }
    }

    protected void bindCoreService(CoreService coreService) {
        this.coreService = coreService;
    }

    protected void unbindCoreService(CoreService coreService) {
        if (this.coreService == coreService) {
            this.coreService = null;
        }
    }
}

