/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.acl.impl;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onlab.packet.Ethernet;
import org.onlab.packet.Ip4Address;
import org.onlab.packet.Ip4Prefix;
import org.onlab.packet.IpAddress;
import org.onlab.packet.IpPrefix;
import org.onlab.packet.TpPort;
import org.onosproject.acl.AclRule;
import org.onosproject.acl.AclService;
import org.onosproject.acl.AclStore;
import org.onosproject.acl.RuleId;
import org.onosproject.acl.impl.AclManager;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreService;
import org.onosproject.core.IdGenerator;
import org.onosproject.event.EventListener;
import org.onosproject.mastership.MastershipService;
import org.onosproject.net.DeviceId;
import org.onosproject.net.Host;
import org.onosproject.net.PortNumber;
import org.onosproject.net.flow.DefaultFlowEntry;
import org.onosproject.net.flow.DefaultFlowRule;
import org.onosproject.net.flow.DefaultTrafficSelector;
import org.onosproject.net.flow.DefaultTrafficTreatment;
import org.onosproject.net.flow.FlowRule;
import org.onosproject.net.flow.FlowRuleService;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.flow.instructions.Instruction;
import org.onosproject.net.flow.instructions.Instructions;
import org.onosproject.net.host.HostListener;
import org.onosproject.net.host.HostService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
public class AclManager
implements AclService {
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected CoreService coreService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected FlowRuleService flowRuleService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected HostService hostService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected MastershipService mastershipService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected AclStore aclStore;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private ApplicationId appId;
    private final HostListener hostListener = new InternalHostListener(this, null);
    private IdGenerator idGenerator;

    private boolean checkIpInCidr(Ip4Address ip, Ip4Prefix cidr) {
        int offset = 32 - cidr.prefixLength();
        int cidrPrefix = cidr.address().toInt();
        int ipIntValue = ip.toInt();
        cidrPrefix >>= offset;
        ipIntValue >>= offset;
        return (cidrPrefix <<= offset) == (ipIntValue <<= offset);
    }

    @Activate
    public void activate() {
        this.appId = this.coreService.registerApplication("org.onos.acl");
        this.hostService.addListener((EventListener)this.hostListener);
        this.idGenerator = this.coreService.getIdGenerator("acl-ids");
        AclRule.bindIdGenerator((IdGenerator)this.idGenerator);
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.hostService.removeListener((EventListener)this.hostListener);
        this.flowRuleService.removeFlowRulesById(this.appId);
        this.aclStore.clearAcl();
        this.log.info("Stopped");
    }

    public List<AclRule> getAclRules() {
        return this.aclStore.getAclRules();
    }

    private boolean matchCheck(AclRule newRule) {
        for (AclRule existingRule : this.aclStore.getAclRules()) {
            if (newRule.checkMatch(existingRule)) {
                return true;
            }
            if (existingRule.action() != AclRule.Action.ALLOW || newRule.action() != AclRule.Action.DENY || !existingRule.checkMatch(newRule)) continue;
            this.aclStore.addDenyToAllowMapping(newRule.id(), existingRule.id());
        }
        return false;
    }

    public boolean addAclRule(AclRule rule) {
        if (this.matchCheck(rule)) {
            return false;
        }
        this.aclStore.addAclRule(rule);
        this.log.info("ACL rule(id:{}) is added.", (Object)rule.id());
        if (rule.action() != AclRule.Action.ALLOW) {
            this.enforceRuleAdding(rule);
        }
        return true;
    }

    private Set<DeviceId> getDeviceIdSet(Ip4Prefix cidrAddr) {
        HashSet<DeviceId> deviceIdSet = new HashSet<DeviceId>();
        Iterable hosts = this.hostService.getHosts();
        if (cidrAddr.prefixLength() != 32) {
            for (Host h : hosts) {
                for (IpAddress a : h.ipAddresses()) {
                    if (!this.checkIpInCidr(a.getIp4Address(), cidrAddr)) continue;
                    deviceIdSet.add(h.location().deviceId());
                }
            }
        } else {
            for (Host h : hosts) {
                for (IpAddress a : h.ipAddresses()) {
                    if (!this.checkIpInCidr(a.getIp4Address(), cidrAddr)) continue;
                    deviceIdSet.add(h.location().deviceId());
                    return deviceIdSet;
                }
            }
        }
        return deviceIdSet;
    }

    private void enforceRuleAdding(AclRule rule) {
        Set dpidSet = rule.srcIp() != null ? this.getDeviceIdSet(rule.srcIp()) : this.getDeviceIdSet(rule.dstIp());
        for (DeviceId deviceId : dpidSet) {
            List allowingRuleList = this.aclStore.getAllowingRuleByDenyingRule(rule.id());
            if (allowingRuleList != null) {
                for (RuleId allowingRuleId : allowingRuleList) {
                    this.generateAclFlow(this.aclStore.getAclRule(allowingRuleId), deviceId);
                }
            }
            this.generateAclFlow(rule, deviceId);
        }
    }

    private void generateAclFlow(AclRule rule, DeviceId deviceId) {
        if (rule == null || this.aclStore.checkIfRuleWorksInDevice(rule.id(), deviceId)) {
            return;
        }
        TrafficSelector.Builder selectorBuilder = DefaultTrafficSelector.builder();
        TrafficTreatment.Builder treatment = DefaultTrafficTreatment.builder();
        DefaultFlowRule.Builder flowEntry = DefaultFlowEntry.builder();
        selectorBuilder.matchEthType(Ethernet.TYPE_IPV4);
        if (rule.srcIp() != null) {
            selectorBuilder.matchIPSrc((IpPrefix)rule.srcIp());
            if (rule.dstIp() != null) {
                selectorBuilder.matchIPDst((IpPrefix)rule.dstIp());
            }
        } else {
            selectorBuilder.matchIPDst((IpPrefix)rule.dstIp());
        }
        if (rule.ipProto() != 0) {
            selectorBuilder.matchIPProtocol(Integer.valueOf(rule.ipProto()).byteValue());
        }
        if (rule.dstTpPort() != 0) {
            switch (rule.ipProto()) {
                case 6: {
                    selectorBuilder.matchTcpDst(TpPort.tpPort((int)rule.dstTpPort()));
                    break;
                }
                case 17: {
                    selectorBuilder.matchUdpDst(TpPort.tpPort((int)rule.dstTpPort()));
                    break;
                }
            }
        }
        if (rule.action() == AclRule.Action.ALLOW) {
            treatment.add((Instruction)Instructions.createOutput((PortNumber)PortNumber.CONTROLLER));
        }
        flowEntry.forDevice(deviceId);
        flowEntry.withPriority(this.aclStore.getPriorityByDevice(deviceId));
        flowEntry.withSelector(selectorBuilder.build());
        flowEntry.withTreatment(treatment.build());
        flowEntry.fromApp(this.appId);
        flowEntry.makePermanent();
        this.flowRuleService.applyFlowRules(new FlowRule[]{flowEntry.build()});
        this.log.debug("ACL flow rule {} is installed in {}.", (Object)flowEntry.build(), (Object)deviceId);
        this.aclStore.addRuleToFlowMapping(rule.id(), flowEntry.build());
        this.aclStore.addRuleToDeviceMapping(rule.id(), deviceId);
    }

    public void removeAclRule(RuleId ruleId) {
        this.aclStore.removeAclRule(ruleId);
        this.log.info("ACL rule(id:{}) is removed.", (Object)ruleId);
        this.enforceRuleRemoving(ruleId);
    }

    private void enforceRuleRemoving(RuleId ruleId) {
        Set flowSet = this.aclStore.getFlowByRule(ruleId);
        if (flowSet != null) {
            for (FlowRule flowRule : flowSet) {
                this.flowRuleService.removeFlowRules(new FlowRule[]{flowRule});
                this.log.debug("ACL flow rule {} is removed from {}.", (Object)flowRule.toString(), (Object)flowRule.deviceId().toString());
            }
        }
        this.aclStore.removeRuleToFlowMapping(ruleId);
        this.aclStore.removeRuleToDeviceMapping(ruleId);
        this.aclStore.removeDenyToAllowMapping(ruleId);
    }

    public void clearAcl() {
        this.aclStore.clearAcl();
        this.flowRuleService.removeFlowRulesById(this.appId);
        this.log.info("ACL is cleared.");
    }

    static /* synthetic */ boolean access$100(AclManager x0, Ip4Address x1, Ip4Prefix x2) {
        return x0.checkIpInCidr(x1, x2);
    }

    static /* synthetic */ void access$200(AclManager x0, AclRule x1, DeviceId x2) {
        x0.generateAclFlow(x1, x2);
    }

    protected void bindCoreService(CoreService coreService) {
        this.coreService = coreService;
    }

    protected void unbindCoreService(CoreService coreService) {
        if (this.coreService == coreService) {
            this.coreService = null;
        }
    }

    protected void bindFlowRuleService(FlowRuleService flowRuleService) {
        this.flowRuleService = flowRuleService;
    }

    protected void unbindFlowRuleService(FlowRuleService flowRuleService) {
        if (this.flowRuleService == flowRuleService) {
            this.flowRuleService = null;
        }
    }

    protected void bindHostService(HostService hostService) {
        this.hostService = hostService;
    }

    protected void unbindHostService(HostService hostService) {
        if (this.hostService == hostService) {
            this.hostService = null;
        }
    }

    protected void bindMastershipService(MastershipService mastershipService) {
        this.mastershipService = mastershipService;
    }

    protected void unbindMastershipService(MastershipService mastershipService) {
        if (this.mastershipService == mastershipService) {
            this.mastershipService = null;
        }
    }

    protected void bindAclStore(AclStore aclStore) {
        this.aclStore = aclStore;
    }

    protected void unbindAclStore(AclStore aclStore) {
        if (this.aclStore == aclStore) {
            this.aclStore = null;
        }
    }
}

