/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.flow.forwarder.impl;

import com.google.common.base.Preconditions;
import java.util.Iterator;
import org.onosproject.core.ApplicationId;
import org.onosproject.flow.forwarder.BgpFlowForwarderService;
import org.onosproject.flowapi.ExtFlowContainer;
import org.onosproject.net.Annotations;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.behaviour.ExtensionSelectorResolver;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.driver.DriverHandler;
import org.onosproject.net.driver.DriverService;
import org.onosproject.net.flow.DefaultTrafficSelector;
import org.onosproject.net.flow.DefaultTrafficTreatment;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.flow.criteria.ExtensionSelector;
import org.onosproject.net.flow.criteria.ExtensionSelectorType;
import org.onosproject.net.flowobjective.DefaultForwardingObjective;
import org.onosproject.net.flowobjective.FlowObjectiveService;
import org.onosproject.net.flowobjective.ForwardingObjective;
import org.onosproject.net.flowobjective.Objective;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BgpFlowForwarderImpl
implements BgpFlowForwarderService {
    protected DriverService driverService;
    protected DeviceService deviceService;
    protected FlowObjectiveService flowObjectiveService;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    protected ApplicationId appId;
    private static final String BGP_FLOW_CONTAINER_NOT_NULL = "Bgp flow container cannot be null";
    private static final String APP_ID_NOT_NULL = "Application-Id cannot be null";
    public static final String FLOW_PEER = "flowPeer";

    public BgpFlowForwarderImpl() {
    }

    public BgpFlowForwarderImpl(ApplicationId appId, FlowObjectiveService flowObjectiveService, DeviceService deviceService, DriverService driverService) {
        this.appId = (ApplicationId)Preconditions.checkNotNull((Object)appId, (Object)APP_ID_NOT_NULL);
        this.flowObjectiveService = flowObjectiveService;
        this.deviceService = deviceService;
        this.driverService = driverService;
    }

    @Override
    public boolean installForwardingRule(ExtFlowContainer container) {
        Preconditions.checkNotNull((Object)container, (Object)BGP_FLOW_CONTAINER_NOT_NULL);
        return this.pushBgpFlowRuleForwarder(container, Objective.Operation.ADD);
    }

    @Override
    public boolean unInstallForwardingRule(ExtFlowContainer container) {
        Preconditions.checkNotNull((Object)container, (Object)BGP_FLOW_CONTAINER_NOT_NULL);
        return this.pushBgpFlowRuleForwarder(container, Objective.Operation.REMOVE);
    }

    public boolean pushBgpFlowRuleForwarder(ExtFlowContainer container, Objective.Operation type) {
        DeviceId deviceId = null;
        Iterable devices = this.deviceService.getAvailableDevices();
        Iterator itr = devices.iterator();
        while (itr.hasNext()) {
            DeviceId tmp = ((Device)itr.next()).id();
            if (!tmp.toString().equals(container.deviceId()) || !this.validatePeer(tmp)) continue;
            deviceId = tmp;
            break;
        }
        if (deviceId == null) {
            this.log.error("Bgp devices are not available..");
            return false;
        }
        TrafficSelector.Builder selector = this.packTrafficSelector(deviceId, container);
        TrafficTreatment.Builder treatment = this.packTrafficTreatment(container);
        this.sendBgpFlowRuleForwarder(selector, treatment, deviceId, type);
        return true;
    }

    boolean validatePeer(DeviceId deviceId) {
        boolean ret = false;
        Device d = this.deviceService.getDevice(deviceId);
        Annotations a = d != null ? d.annotations() : null;
        String ipAddress = a.value(FLOW_PEER);
        if (ipAddress != null) {
            ret = true;
        }
        return ret;
    }

    public TrafficSelector.Builder packTrafficSelector(DeviceId deviceId, ExtFlowContainer container) {
        TrafficSelector.Builder selector = DefaultTrafficSelector.builder();
        DriverHandler handler = this.driverService.createHandler(deviceId, new String[0]);
        ExtensionSelectorResolver resolver = (ExtensionSelectorResolver)handler.behaviour(ExtensionSelectorResolver.class);
        ExtensionSelector bgpExtSelector = resolver.getExtensionSelector(ExtensionSelectorType.ExtensionSelectorTypes.EXT_MATCH_FLOW_TYPE.type());
        try {
            bgpExtSelector.setPropertyValue("container", (Object)container);
        }
        catch (Exception e) {
            this.log.error("Failed to get extension instruction for bgp flow {}", (Object)deviceId);
        }
        selector.extension(bgpExtSelector, deviceId);
        return selector;
    }

    public TrafficTreatment.Builder packTrafficTreatment(ExtFlowContainer container) {
        TrafficTreatment.Builder treatment = DefaultTrafficTreatment.builder();
        return treatment;
    }

    public void sendBgpFlowRuleForwarder(TrafficSelector.Builder selector, TrafficTreatment.Builder treatment, DeviceId deviceId, Objective.Operation type) {
        DefaultForwardingObjective.Builder objective = DefaultForwardingObjective.builder().withTreatment(treatment.build()).withSelector(selector.build()).fromApp(this.appId).makePermanent().withFlag(ForwardingObjective.Flag.VERSATILE);
        if (type.equals((Object)Objective.Operation.ADD)) {
            this.log.debug("ADD");
            this.flowObjectiveService.forward(deviceId, objective.add());
        } else {
            this.log.debug("REMOVE");
            this.flowObjectiveService.forward(deviceId, objective.remove());
        }
    }
}

