/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.flow.manager.impl;

import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreService;
import org.onosproject.flow.forwarder.BgpFlowForwarderService;
import org.onosproject.flow.forwarder.impl.BgpFlowForwarderImpl;
import org.onosproject.flow.manager.BgpFlowService;
import org.onosproject.flowapi.ExtFlowContainer;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.driver.DriverService;
import org.onosproject.net.flowobjective.FlowObjectiveService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
public class BgpFlowManager
implements BgpFlowService {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final String APP_ID = "org.onosproject.app.bgpflow";
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected CoreService coreService;
    protected ApplicationId appId;
    private BgpFlowForwarderService bgpFlowForwarderService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected DriverService driverService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected DeviceService deviceService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected FlowObjectiveService flowObjectiveService;

    @Activate
    public void activate() {
        this.appId = this.coreService.registerApplication(APP_ID);
        this.bgpFlowForwarderService = new BgpFlowForwarderImpl(this.appId, this.flowObjectiveService, this.deviceService, this.driverService);
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.log.info("Stopped");
    }

    @Override
    public boolean onBgpFlowCreated(ExtFlowContainer container) {
        return this.bgpFlowForwarderService.installForwardingRule(container);
    }

    @Override
    public boolean onBgpFlowDeleted(ExtFlowContainer container) {
        return this.bgpFlowForwarderService.unInstallForwardingRule(container);
    }

    protected void bindCoreService(CoreService coreService) {
        this.coreService = coreService;
    }

    protected void unbindCoreService(CoreService coreService) {
        if (this.coreService == coreService) {
            this.coreService = null;
        }
    }

    protected void bindDriverService(DriverService driverService) {
        this.driverService = driverService;
    }

    protected void unbindDriverService(DriverService driverService) {
        if (this.driverService == driverService) {
            this.driverService = null;
        }
    }

    protected void bindDeviceService(DeviceService deviceService) {
        this.deviceService = deviceService;
    }

    protected void unbindDeviceService(DeviceService deviceService) {
        if (this.deviceService == deviceService) {
            this.deviceService = null;
        }
    }

    protected void bindFlowObjectiveService(FlowObjectiveService flowObjectiveService) {
        this.flowObjectiveService = flowObjectiveService;
    }

    protected void unbindFlowObjectiveService(FlowObjectiveService flowObjectiveService) {
        if (this.flowObjectiveService == flowObjectiveService) {
            this.flowObjectiveService = null;
        }
    }
}

