/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.bmv2.demo.app.ecmp;

import com.eclipsesource.json.Json;
import com.eclipsesource.json.JsonObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.felix.scr.annotations.Component;
import org.onlab.graph.Vertex;
import org.onlab.packet.EthType;
import org.onosproject.bmv2.api.context.Bmv2Configuration;
import org.onosproject.bmv2.api.context.Bmv2DefaultConfiguration;
import org.onosproject.bmv2.api.context.Bmv2DeviceContext;
import org.onosproject.bmv2.api.context.Bmv2Interpreter;
import org.onosproject.bmv2.api.runtime.Bmv2ExtensionSelector;
import org.onosproject.bmv2.api.runtime.Bmv2ExtensionTreatment;
import org.onosproject.bmv2.demo.app.common.AbstractUpgradableFabricApp;
import org.onosproject.bmv2.demo.app.ecmp.EcmpInterpreter;
import org.onosproject.net.DeviceId;
import org.onosproject.net.Host;
import org.onosproject.net.Path;
import org.onosproject.net.Port;
import org.onosproject.net.PortNumber;
import org.onosproject.net.flow.DefaultTrafficSelector;
import org.onosproject.net.flow.DefaultTrafficTreatment;
import org.onosproject.net.flow.FlowRule;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.flow.criteria.ExtensionSelector;
import org.onosproject.net.flow.instructions.ExtensionTreatment;
import org.onosproject.net.topology.DefaultTopologyVertex;
import org.onosproject.net.topology.Topology;
import org.onosproject.net.topology.TopologyGraph;
import org.onosproject.net.topology.TopologyVertex;

@Component(immediate=true)
public class EcmpFabricApp
extends AbstractUpgradableFabricApp {
    private static final String APP_NAME = "org.onosproject.bmv2-ecmp-fabric";
    private static final String MODEL_NAME = "ECMP";
    private static final String JSON_CONFIG_PATH = "/ecmp.json";
    private static final Bmv2Configuration ECMP_CONFIGURATION = EcmpFabricApp.loadConfiguration();
    private static final EcmpInterpreter ECMP_INTERPRETER = new EcmpInterpreter();
    protected static final Bmv2DeviceContext ECMP_CONTEXT = new Bmv2DeviceContext(ECMP_CONFIGURATION, (Bmv2Interpreter)ECMP_INTERPRETER);
    private static final Map<DeviceId, Map<Set<PortNumber>, Short>> DEVICE_GROUP_ID_MAP = Maps.newHashMap();

    public EcmpFabricApp() {
        super(APP_NAME, MODEL_NAME, ECMP_CONTEXT);
    }

    public boolean initDevice(DeviceId deviceId) {
        return true;
    }

    public List<FlowRule> generateLeafRules(DeviceId leaf, Host srcHost, Collection<Host> dstHosts, Collection<DeviceId> availableSpines, Topology topo) throws AbstractUpgradableFabricApp.FlowRuleGeneratorException {
        FlowRule rule;
        TrafficTreatment treatment;
        Set hostPorts = this.deviceService.getPorts(leaf).stream().filter(port -> !this.isFabricPort((Port)port, topo)).map(Port::number).collect(Collectors.toSet());
        TopologyGraph graph = this.topologyService.getGraph(topo);
        Set<PortNumber> fabricPorts = graph.getEdgesFrom((Vertex)new DefaultTopologyVertex(leaf)).stream().filter(e -> availableSpines.contains(((TopologyVertex)e.dst()).deviceId())).map(e -> e.link().src().port()).collect(Collectors.toSet());
        if (hostPorts.size() != 1 || fabricPorts.size() == 0) {
            this.log.error("Leaf switch has invalid port configuration: hostPorts={}, fabricPorts={}", (Object)hostPorts.size(), (Object)fabricPorts.size());
            throw new AbstractUpgradableFabricApp.FlowRuleGeneratorException((AbstractUpgradableFabricApp)this);
        }
        PortNumber hostPort = (PortNumber)hostPorts.iterator().next();
        ArrayList rules = Lists.newArrayList();
        if (fabricPorts.size() > 1) {
            Pair<ExtensionTreatment, List<FlowRule>> result = this.provisionEcmpTreatment(leaf, fabricPorts);
            rules.addAll((Collection)result.getRight());
            ExtensionTreatment extTreatment = (ExtensionTreatment)result.getLeft();
            treatment = DefaultTrafficTreatment.builder().extension(extTreatment, leaf).build();
        } else {
            PortNumber outPort = (PortNumber)fabricPorts.iterator().next();
            treatment = DefaultTrafficTreatment.builder().setOutput(outPort).build();
        }
        for (Host dstHost : dstHosts) {
            rule = this.flowRuleBuilder(leaf, "table0").withSelector(DefaultTrafficSelector.builder().matchInPort(hostPort).matchEthType(EthType.EtherType.IPV4.ethType().toShort()).matchEthSrc(srcHost.mac()).matchEthDst(dstHost.mac()).build()).withTreatment(treatment).build();
            rules.add(rule);
        }
        for (PortNumber port2 : fabricPorts) {
            rule = this.flowRuleBuilder(leaf, "table0").withSelector(DefaultTrafficSelector.builder().matchInPort(port2).matchEthType(EthType.EtherType.IPV4.ethType().toShort()).matchEthDst(srcHost.mac()).build()).withTreatment(DefaultTrafficTreatment.builder().setOutput(hostPort).build()).build();
            rules.add(rule);
        }
        return rules;
    }

    public List<FlowRule> generateSpineRules(DeviceId deviceId, Collection<Host> dstHosts, Topology topo) throws AbstractUpgradableFabricApp.FlowRuleGeneratorException {
        ArrayList rules = Lists.newArrayList();
        for (Host dstHost : dstHosts) {
            TrafficTreatment treatment;
            Set paths = this.topologyService.getPaths(topo, deviceId, dstHost.location().deviceId());
            if (paths.size() == 0) {
                this.log.warn("Can't find any path between spine {} and host {}", (Object)deviceId, (Object)dstHost);
                throw new AbstractUpgradableFabricApp.FlowRuleGeneratorException((AbstractUpgradableFabricApp)this);
            }
            if (paths.size() == 1) {
                PortNumber port = ((Path)paths.iterator().next()).src().port();
                treatment = DefaultTrafficTreatment.builder().setOutput(port).build();
            } else {
                Set<PortNumber> portNumbers = paths.stream().map(p -> p.src().port()).collect(Collectors.toSet());
                Pair<ExtensionTreatment, List<FlowRule>> result = this.provisionEcmpTreatment(deviceId, portNumbers);
                rules.addAll((Collection)result.getRight());
                treatment = DefaultTrafficTreatment.builder().extension((ExtensionTreatment)result.getLeft(), deviceId).build();
            }
            FlowRule rule = this.flowRuleBuilder(deviceId, "table0").withSelector(DefaultTrafficSelector.builder().matchEthType(EthType.EtherType.IPV4.ethType().toShort()).matchEthDst(dstHost.mac()).build()).withTreatment(treatment).build();
            rules.add(rule);
        }
        return rules;
    }

    private Pair<ExtensionTreatment, List<FlowRule>> provisionEcmpTreatment(DeviceId deviceId, Set<PortNumber> fabricPorts) throws AbstractUpgradableFabricApp.FlowRuleGeneratorException {
        int groupId = this.groupIdOf(deviceId, fabricPorts);
        int groupSize = fabricPorts.size();
        Iterator<PortNumber> portIterator = fabricPorts.iterator();
        ArrayList rules = Lists.newArrayList();
        for (int i = 0; i < groupSize; i = (int)((short)(i + 1))) {
            Bmv2ExtensionSelector extSelector = this.buildEcmpSelector(groupId, i);
            FlowRule rule = this.flowRuleBuilder(deviceId, "ecmp_group_table").withSelector(DefaultTrafficSelector.builder().extension((ExtensionSelector)extSelector, deviceId).build()).withTreatment(DefaultTrafficTreatment.builder().setOutput(portIterator.next()).build()).build();
            rules.add(rule);
        }
        Bmv2ExtensionTreatment extTreatment = this.buildEcmpTreatment(groupId, groupSize);
        return Pair.of((Object)extTreatment, (Object)rules);
    }

    private Bmv2ExtensionTreatment buildEcmpTreatment(int groupId, int groupSize) {
        return Bmv2ExtensionTreatment.builder().forConfiguration(ECMP_CONTEXT.configuration()).setActionName("ecmp_group").addParameter("groupId", groupId).addParameter("groupSize", groupSize).build();
    }

    private Bmv2ExtensionSelector buildEcmpSelector(int groupId, int selector) {
        return Bmv2ExtensionSelector.builder().forConfiguration(ECMP_CONTEXT.configuration()).matchExact("ecmp_metadata", "groupId", groupId).matchExact("ecmp_metadata", "selector", selector).build();
    }

    public int groupIdOf(DeviceId deviceId, Set<PortNumber> ports) {
        DEVICE_GROUP_ID_MAP.putIfAbsent(deviceId, Maps.newHashMap());
        return DEVICE_GROUP_ID_MAP.get(deviceId).computeIfAbsent(ports, pp -> (short)(DEVICE_GROUP_ID_MAP.get(deviceId).size() + 1)).shortValue();
    }

    private static Bmv2Configuration loadConfiguration() {
        try {
            JsonObject json = Json.parse((Reader)new BufferedReader(new InputStreamReader(EcmpFabricApp.class.getResourceAsStream(JSON_CONFIG_PATH)))).asObject();
            return Bmv2DefaultConfiguration.parse((JsonObject)json);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to load configuration", e);
        }
    }
}

