/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.bmv2.demo.app.ecmp;

import com.google.common.collect.ImmutableBiMap;
import org.onlab.util.ImmutableByteSequence;
import org.onosproject.bmv2.api.context.Bmv2Configuration;
import org.onosproject.bmv2.api.context.Bmv2Interpreter;
import org.onosproject.bmv2.api.context.Bmv2InterpreterException;
import org.onosproject.bmv2.api.runtime.Bmv2Action;
import org.onosproject.bmv2.api.utils.Bmv2TranslatorUtils;
import org.onosproject.net.PortNumber;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.flow.criteria.Criterion;
import org.onosproject.net.flow.instructions.Instruction;
import org.onosproject.net.flow.instructions.Instructions;

public class EcmpInterpreter
implements Bmv2Interpreter {
    protected static final String ECMP_METADATA = "ecmp_metadata";
    protected static final String SELECTOR = "selector";
    protected static final String GROUP_ID = "groupId";
    protected static final String GROUP_SIZE = "groupSize";
    protected static final String ECMP_GROUP = "ecmp_group";
    protected static final String ECMP_GROUP_TABLE = "ecmp_group_table";
    protected static final String TABLE0 = "table0";
    protected static final String SEND_TO_CPU = "send_to_cpu";
    protected static final String DROP = "_drop";
    protected static final String SET_EGRESS_PORT = "set_egress_port";
    protected static final String PORT = "port";
    private static final ImmutableBiMap<Criterion.Type, String> CRITERION_TYPE_MAP = ImmutableBiMap.of((Object)Criterion.Type.IN_PORT, (Object)"standard_metadata.ingress_port", (Object)Criterion.Type.ETH_DST, (Object)"ethernet.dstAddr", (Object)Criterion.Type.ETH_SRC, (Object)"ethernet.srcAddr", (Object)Criterion.Type.ETH_TYPE, (Object)"ethernet.etherType");
    private static final ImmutableBiMap<Integer, String> TABLE_ID_MAP = ImmutableBiMap.of((Object)0, (Object)"table0", (Object)1, (Object)"ecmp_group_table");

    public ImmutableBiMap<Integer, String> tableIdMap() {
        return TABLE_ID_MAP;
    }

    public ImmutableBiMap<Criterion.Type, String> criterionTypeMap() {
        return CRITERION_TYPE_MAP;
    }

    public Bmv2Action mapTreatment(TrafficTreatment treatment, Bmv2Configuration configuration) throws Bmv2InterpreterException {
        if (treatment.allInstructions().size() == 0) {
            return EcmpInterpreter.actionWithName(DROP);
        }
        if (treatment.allInstructions().size() > 1) {
            throw new Bmv2InterpreterException("Treatment has multiple instructions");
        }
        Instruction instruction = (Instruction)treatment.allInstructions().get(0);
        switch (instruction.type()) {
            case OUTPUT: {
                Instructions.OutputInstruction outInstruction = (Instructions.OutputInstruction)instruction;
                PortNumber port = outInstruction.port();
                if (!port.isLogical()) {
                    return EcmpInterpreter.buildEgressAction(port, configuration);
                }
                if (port.equals((Object)PortNumber.CONTROLLER)) {
                    return EcmpInterpreter.actionWithName(SEND_TO_CPU);
                }
                throw new Bmv2InterpreterException("Egress on logical port not supported: " + port);
            }
            case NOACTION: {
                return EcmpInterpreter.actionWithName(DROP);
            }
        }
        throw new Bmv2InterpreterException("Instruction type not supported: " + instruction.type().name());
    }

    private static Bmv2Action buildEgressAction(PortNumber port, Bmv2Configuration configuration) throws Bmv2InterpreterException {
        int portBitWidth = configuration.action(SET_EGRESS_PORT).runtimeData(PORT).bitWidth();
        try {
            ImmutableByteSequence portBs = Bmv2TranslatorUtils.fitByteSequence((ImmutableByteSequence)ImmutableByteSequence.copyFrom((long)port.toLong()), (int)portBitWidth);
            return Bmv2Action.builder().withName(SET_EGRESS_PORT).addParameter(portBs).build();
        }
        catch (Bmv2TranslatorUtils.ByteSequenceFitException e) {
            throw new Bmv2InterpreterException(e.getMessage());
        }
    }

    private static Bmv2Action actionWithName(String name) {
        return Bmv2Action.builder().withName(name).build();
    }
}

