/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.calendar;

import java.net.URI;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.DELETE;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Response;
import org.onlab.rest.BaseResource;
import org.onosproject.calendar.BandwidthCalendarResource;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreService;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DeviceId;
import org.onosproject.net.ElementId;
import org.onosproject.net.PortNumber;
import org.onosproject.net.flow.DefaultTrafficSelector;
import org.onosproject.net.flow.DefaultTrafficTreatment;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.intent.Intent;
import org.onosproject.net.intent.IntentId;
import org.onosproject.net.intent.IntentListener;
import org.onosproject.net.intent.IntentService;
import org.onosproject.net.intent.PointToPointIntent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="intent")
public class BandwidthCalendarResource
extends BaseResource {
    private static final Logger log = LoggerFactory.getLogger(BandwidthCalendarResource.class);
    private static final long TIMEOUT = 5L;

    @Path(value="/{src}/{dst}/{srcPort}/{dstPort}/{bandwidth}")
    @POST
    public Response createIntent(@PathParam(value="src") String src, @PathParam(value="dst") String dst, @PathParam(value="srcPort") String srcPort, @PathParam(value="dstPort") String dstPort, @PathParam(value="bandwidth") String bandwidth) {
        log.info("Receiving Create Intent request...");
        log.info("Path Constraints: Src = {} SrcPort = {} Dest = {} DestPort = {} BW = {}", new Object[]{src, srcPort, dst, dstPort, bandwidth});
        IntentService service = (IntentService)this.get(IntentService.class);
        ConnectPoint srcPoint = new ConnectPoint((ElementId)this.deviceId(src), PortNumber.portNumber((String)srcPort));
        ConnectPoint dstPoint = new ConnectPoint((ElementId)this.deviceId(dst), PortNumber.portNumber((String)dstPort));
        TrafficSelector selector = this.buildTrafficSelector();
        TrafficTreatment treatment = DefaultTrafficTreatment.builder().build();
        PointToPointIntent intentP2P = new PointToPointIntent(this.appId(), selector, treatment, srcPoint, dstPoint);
        CountDownLatch latch = new CountDownLatch(1);
        InternalIntentListener listener = new InternalIntentListener(this, (Intent)intentP2P, service, latch, null);
        service.addListener((IntentListener)listener);
        service.submit((Intent)intentP2P);
        try {
            if (latch.await(5L, TimeUnit.SECONDS)) {
                log.info("Submitted Calendar App intent: src = {}; dst = {}; srcPort = {}; dstPort = {}; intentID = {}", new Object[]{src, dst, srcPort, dstPort, intentP2P.id()});
                String reply = intentP2P.id() + " " + listener.getState() + "\n";
                return Response.ok((Object)reply).build();
            }
        }
        catch (InterruptedException e) {
            log.warn("Interrupted while waiting for intent {} status", (Object)intentP2P.id());
        }
        return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
    }

    @Path(value="/cancellation/{intentId}")
    @DELETE
    public Response withdrawIntent(@PathParam(value="intentId") String intentId) {
        log.info("Receiving Teardown request for {}", (Object)intentId);
        IntentService service = (IntentService)this.get(IntentService.class);
        Intent intent = service.getIntent(IntentId.valueOf((long)Long.parseLong(intentId)));
        if (intent != null) {
            service.withdraw(intent);
            String reply = "ok\n";
            return Response.ok((Object)reply).build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }

    @Path(value="/modification/{intentId}/{bandwidth}")
    @POST
    public Response modifyBandwidth(@PathParam(value="intentId") String intentId, @PathParam(value="bandwidth") String bandwidth) {
        log.info("Receiving Modify request...");
        log.info("Modify bw for intentId = {} with new bandwidth = {}", (Object)intentId, (Object)bandwidth);
        String reply = "ok\n";
        return Response.ok((Object)reply).build();
    }

    private TrafficSelector buildTrafficSelector() {
        TrafficSelector.Builder selectorBuilder = DefaultTrafficSelector.builder();
        Short ethType = 2048;
        selectorBuilder.matchEthType(ethType.shortValue());
        return selectorBuilder.build();
    }

    private DeviceId deviceId(String dpid) {
        return DeviceId.deviceId((URI)URI.create("of:" + dpid));
    }

    protected ApplicationId appId() {
        return ((CoreService)this.get(CoreService.class)).registerApplication("org.onosproject.calendar");
    }
}

