/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.calendar;

import java.net.URI;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.LinkedList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.DELETE;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Response;
import org.onlab.rest.BaseResource;
import org.onlab.util.Tools;
import org.onosproject.calendar.BandwidthCalendarResource;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreService;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DeviceId;
import org.onosproject.net.ElementId;
import org.onosproject.net.HostId;
import org.onosproject.net.PortNumber;
import org.onosproject.net.flow.DefaultTrafficSelector;
import org.onosproject.net.flow.DefaultTrafficTreatment;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.intent.ConnectivityIntent;
import org.onosproject.net.intent.Constraint;
import org.onosproject.net.intent.HostToHostIntent;
import org.onosproject.net.intent.Intent;
import org.onosproject.net.intent.IntentListener;
import org.onosproject.net.intent.IntentService;
import org.onosproject.net.intent.IntentState;
import org.onosproject.net.intent.Key;
import org.onosproject.net.intent.TwoWayP2PIntent;
import org.onosproject.net.intent.constraint.BandwidthConstraint;
import org.onosproject.net.intent.constraint.LatencyConstraint;
import org.onosproject.net.resource.Bandwidth;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
@Path(value="intent")
public class BandwidthCalendarResource
extends BaseResource {
    private static final Logger log = LoggerFactory.getLogger(BandwidthCalendarResource.class);
    private static final long TIMEOUT = 10L;
    private static final String INVALID_PARAMETER = "INVALID_PARAMETER\n";
    private static final String OPERATION_INSTALLED = "INSTALLED\n";
    private static final String OPERATION_FAILED = "FAILED\n";
    private static final String OPERATION_WITHDRAWN = "WITHDRAWN\n";

    @Path(value="/{src}/{dst}/{srcPort}/{dstPort}/{bandwidth}/{latency}")
    @POST
    public Response setupPath(@PathParam(value="src") String src, @PathParam(value="dst") String dst, @PathParam(value="srcPort") String srcPort, @PathParam(value="dstPort") String dstPort, @PathParam(value="bandwidth") String bandwidth, @PathParam(value="latency") String latency) {
        log.info("Path Constraints: Src = {} SrcPort = {} Dest = {} DestPort = {} BW = {} latency = {}", new Object[]{src, srcPort, dst, dstPort, bandwidth, latency});
        if (src == null || dst == null || srcPort == null || dstPort == null) {
            return Response.ok((Object)"INVALID_PARAMETER\n").build();
        }
        Long bandwidthL = 0L;
        Long latencyL = 0L;
        try {
            bandwidthL = Long.parseLong(bandwidth, 10);
            latencyL = Long.parseLong(latency, 10);
        }
        catch (Exception e) {
            return Response.ok((Object)"INVALID_PARAMETER\n").build();
        }
        Intent intent = this.createIntent(null, src, dst, srcPort, dstPort, bandwidthL, latencyL);
        try {
            if (this.submitIntent(intent)) {
                return Response.ok((Object)(intent.key() + "\n")).build();
            }
            return Response.ok((Object)"FAILED\n").build();
        }
        catch (Exception e) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @Path(value="/{intentKey}/{src}/{dst}/{srcPort}/{dstPort}/{bandwidth}")
    @PUT
    public Response modifyBandwidth(@PathParam(value="intentKey") String intentKey, @PathParam(value="src") String src, @PathParam(value="dst") String dst, @PathParam(value="srcPort") String srcPort, @PathParam(value="dstPort") String dstPort, @PathParam(value="bandwidth") String bandwidth) {
        log.info("Modify bw for intentKey = {}; src = {}; dst = {};srcPort = {}; dstPort = {}; with new bandwidth = {}", new Object[]{intentKey, src, dst, srcPort, dstPort, bandwidth});
        if (src == null || dst == null || srcPort == null || dstPort == null) {
            return Response.ok((Object)"INVALID_PARAMETER\n").build();
        }
        Long bandwidthL = 0L;
        try {
            bandwidthL = Long.parseLong(bandwidth, 10);
        }
        catch (Exception e) {
            return Response.ok((Object)"INVALID_PARAMETER\n").build();
        }
        IntentService service = (IntentService)this.get(IntentService.class);
        Intent originalIntent = service.getIntent(Key.of((long)Tools.fromHex((String)intentKey.replace("0x", "")), (ApplicationId)this.appId()));
        if (originalIntent == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        Long latencyL = 0L;
        if (originalIntent instanceof ConnectivityIntent) {
            ConnectivityIntent connectivityIntent = (ConnectivityIntent)originalIntent;
            for (Constraint constraint : connectivityIntent.constraints()) {
                if (!(constraint instanceof LatencyConstraint)) continue;
                latencyL = ((LatencyConstraint)constraint).latency().get(ChronoUnit.MICROS);
            }
        }
        Intent newIntent = this.createIntent(originalIntent.key(), src, dst, srcPort, dstPort, bandwidthL, latencyL);
        try {
            if (this.submitIntent(newIntent)) {
                return Response.ok((Object)"INSTALLED\n").build();
            }
            return Response.ok((Object)"FAILED\n").build();
        }
        catch (Exception e) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    private Intent createIntent(Key key, String src, String dst, String srcPort, String dstPort, Long bandwidth, Long latency) {
        TrafficSelector selector = BandwidthCalendarResource.buildTrafficSelector();
        TrafficTreatment treatment = DefaultTrafficTreatment.builder().build();
        BandwidthConstraint constraintBandwidth = new BandwidthConstraint(Bandwidth.mbps((double)bandwidth.longValue()));
        LatencyConstraint constraintLatency = new LatencyConstraint(Duration.of(latency, ChronoUnit.MICROS));
        LinkedList<Object> constraints = new LinkedList<Object>();
        constraints.add(constraintBandwidth);
        constraints.add(constraintLatency);
        if (srcPort.equals("-1")) {
            HostId srcPoint = HostId.hostId((String)src);
            HostId dstPoint = HostId.hostId((String)dst);
            return new HostToHostIntent(this.appId(), key, srcPoint, dstPoint, selector, treatment, constraints);
        }
        ConnectPoint srcPoint = new ConnectPoint((ElementId)BandwidthCalendarResource.deviceId((String)src), PortNumber.portNumber((String)srcPort));
        ConnectPoint dstPoint = new ConnectPoint((ElementId)BandwidthCalendarResource.deviceId((String)dst), PortNumber.portNumber((String)dstPort));
        return new TwoWayP2PIntent(this.appId(), key, srcPoint, dstPoint, selector, treatment, constraints);
    }

    private boolean submitIntent(Intent intent) throws InterruptedException {
        IntentService service = (IntentService)this.get(IntentService.class);
        CountDownLatch latch = new CountDownLatch(1);
        InternalIntentListener listener = new InternalIntentListener(this, intent, service, latch, null);
        service.addListener((IntentListener)listener);
        service.submit(intent);
        log.info("Submitted Calendar App intent and waiting: {}", (Object)intent);
        return latch.await(10L, TimeUnit.SECONDS) && listener.getState() == IntentState.INSTALLED;
    }

    @Path(value="/{intentKey}")
    @DELETE
    public Response removePath(@PathParam(value="intentKey") String intentKey) {
        log.info("Receiving tear down request for {}", (Object)intentKey);
        if (intentKey == null) {
            return Response.ok((Object)"INVALID_PARAMETER\n").build();
        }
        IntentService service = (IntentService)this.get(IntentService.class);
        Intent intent = service.getIntent(Key.of((long)Tools.fromHex((String)intentKey.replace("0x", "")), (ApplicationId)this.appId()));
        if (intent == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        try {
            if (this.withdrawIntent(intent)) {
                return Response.ok((Object)"WITHDRAWN\n").build();
            }
            return Response.ok((Object)"FAILED\n").build();
        }
        catch (Exception e) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    private boolean withdrawIntent(Intent intent) throws InterruptedException {
        IntentService service = (IntentService)this.get(IntentService.class);
        CountDownLatch latch = new CountDownLatch(1);
        InternalIntentListener listener = new InternalIntentListener(this, intent, service, latch, null);
        service.addListener((IntentListener)listener);
        service.withdraw(intent);
        log.info("Withdrawing intent and waiting: {}", (Object)intent);
        return latch.await(10L, TimeUnit.SECONDS) && listener.getState() == IntentState.WITHDRAWN;
    }

    private static TrafficSelector buildTrafficSelector() {
        TrafficSelector.Builder selectorBuilder = DefaultTrafficSelector.builder();
        Short ethType = 2048;
        selectorBuilder.matchEthType(ethType.shortValue());
        return selectorBuilder.build();
    }

    private static DeviceId deviceId(String dpid) {
        return DeviceId.deviceId((URI)URI.create("of:" + dpid));
    }

    protected ApplicationId appId() {
        return ((CoreService)this.get(CoreService.class)).registerApplication("org.onosproject.calendar");
    }
}

