/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cip;

import com.google.common.base.Strings;
import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import java.util.Dictionary;
import java.util.Objects;
import java.util.Properties;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Modified;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.onlab.util.Tools;
import org.onosproject.cfg.ComponentConfigService;
import org.onosproject.cluster.ClusterService;
import org.onosproject.cluster.Leadership;
import org.onosproject.cluster.LeadershipEvent;
import org.onosproject.cluster.LeadershipEventListener;
import org.onosproject.cluster.LeadershipService;
import org.onosproject.cluster.NodeId;
import org.onosproject.event.EventListener;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
public class ClusterIpManager {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final String CLUSTER_IP = "cluster/ip";
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ClusterService clusterService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected LeadershipService leadershipService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ComponentConfigService cfgService;
    private final LeadershipEventListener listener = new InternalLeadershipListener();
    private NodeId localId;
    private boolean wasLeader = false;
    @Property(name="aliasIp", value={""}, label="Alias IP address")
    private String aliasIp = "";
    public static final String DEFAULT_MASK = "255.255.0.0";
    @Property(name="aliasMask", value={"255.255.0.0"}, label="Alias IP mask")
    private String aliasMask = "255.255.0.0";
    public static final String ETH_0 = "eth0:0";
    @Property(name="aliasAdapter", value={"eth0:0"}, label="Alias IP adapter")
    private String aliasAdapter = "eth0:0";

    @Activate
    protected void activate(ComponentContext context) {
        this.cfgService.registerProperties(this.getClass());
        this.localId = this.clusterService.getLocalNode().id();
        this.processLeadershipChange(this.leadershipService.getLeader(CLUSTER_IP));
        this.leadershipService.addListener((EventListener)this.listener);
        this.leadershipService.runForLeadership(CLUSTER_IP);
        this.log.info("Started");
    }

    @Deactivate
    protected void deactivate(ComponentContext context) {
        this.cfgService.unregisterProperties(this.getClass(), false);
        this.removeIpAlias(this.aliasIp, this.aliasMask, this.aliasAdapter);
        this.leadershipService.removeListener((EventListener)this.listener);
        this.leadershipService.withdraw(CLUSTER_IP);
        this.log.info("Stopped");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Modified
    protected void modified(ComponentContext context) {
        this.log.info("Received configuration change...");
        Dictionary properties = context != null ? context.getProperties() : new Properties();
        String newIp = Tools.get((Dictionary)properties, (String)"aliasIp");
        String newMask = Tools.get((Dictionary)properties, (String)"aliasMask");
        String newAdapter = Tools.get((Dictionary)properties, (String)"aliasAdapter");
        if (!(Objects.equals(newIp, this.aliasIp) && Objects.equals(newMask, this.aliasMask) && Objects.equals(newAdapter, this.aliasAdapter))) {
            ClusterIpManager clusterIpManager = this;
            synchronized (clusterIpManager) {
                this.log.info("Reconfiguring with aliasIp={}, aliasMask={}, aliasAdapter={}, wasLeader={}", new Object[]{newIp, newMask, newAdapter, this.wasLeader});
                if (this.wasLeader) {
                    this.removeIpAlias(this.aliasIp, this.aliasMask, this.aliasAdapter);
                    this.addIpAlias(newIp, newMask, newAdapter);
                }
                this.aliasIp = newIp;
                this.aliasMask = newMask;
                this.aliasAdapter = newAdapter;
            }
        }
    }

    private synchronized void processLeadershipChange(NodeId newLeader) {
        if (newLeader == null) {
            return;
        }
        boolean isLeader = Objects.equals(newLeader, this.localId);
        this.log.info("Processing leadership change; wasLeader={}, isLeader={}", (Object)this.wasLeader, (Object)isLeader);
        if (!this.wasLeader && isLeader) {
            this.addIpAlias(this.aliasIp, this.aliasMask, this.aliasAdapter);
            this.wasLeader = true;
        } else if (this.wasLeader && !isLeader) {
            this.removeIpAlias(this.aliasIp, this.aliasMask, this.aliasAdapter);
            this.wasLeader = false;
        }
    }

    private synchronized void addIpAlias(String ip, String mask, String adapter) {
        if (!(Strings.isNullOrEmpty((String)ip) || Strings.isNullOrEmpty((String)mask) || Strings.isNullOrEmpty((String)adapter))) {
            this.log.info("Adding IP alias {}/{} to {}", new Object[]{ip, mask, adapter});
            this.execute("sudo ifconfig " + adapter + " " + ip + " netmask " + mask + " up", false);
            this.execute("sudo /usr/sbin/arping -c 1 -I " + adapter + " " + ip, true);
        }
    }

    private synchronized void removeIpAlias(String ip, String mask, String adapter) {
        if (!(Strings.isNullOrEmpty((String)ip) || Strings.isNullOrEmpty((String)mask) || Strings.isNullOrEmpty((String)adapter))) {
            this.log.info("Removing IP alias from {}", (Object)adapter, (Object)false);
            this.execute("sudo ifconfig " + adapter + " down", true);
        }
    }

    private void execute(String command, boolean ignoreCode) {
        try {
            this.log.info("Executing [{}]", (Object)command);
            Process process = Runtime.getRuntime().exec(command);
            byte[] output = ByteStreams.toByteArray((InputStream)process.getInputStream());
            byte[] error = ByteStreams.toByteArray((InputStream)process.getErrorStream());
            int code = process.waitFor();
            if (code != 0 && !ignoreCode) {
                this.log.info("Command failed: status={}, output={}, error={}", new Object[]{code, new String(output), new String(error)});
            }
        }
        catch (IOException e) {
            this.log.error("Unable to execute command {}", (Object)command, (Object)e);
        }
        catch (InterruptedException e) {
            this.log.error("Interrupted executing command {}", (Object)command, (Object)e);
        }
    }

    protected void bindClusterService(ClusterService clusterService) {
        this.clusterService = clusterService;
    }

    protected void unbindClusterService(ClusterService clusterService) {
        if (this.clusterService == clusterService) {
            this.clusterService = null;
        }
    }

    protected void bindLeadershipService(LeadershipService leadershipService) {
        this.leadershipService = leadershipService;
    }

    protected void unbindLeadershipService(LeadershipService leadershipService) {
        if (this.leadershipService == leadershipService) {
            this.leadershipService = null;
        }
    }

    protected void bindCfgService(ComponentConfigService componentConfigService) {
        this.cfgService = componentConfigService;
    }

    protected void unbindCfgService(ComponentConfigService componentConfigService) {
        if (this.cfgService == componentConfigService) {
            this.cfgService = null;
        }
    }

    private class InternalLeadershipListener
    implements LeadershipEventListener {
        private InternalLeadershipListener() {
        }

        public void event(LeadershipEvent event) {
            if (((Leadership)event.subject()).topic().equals(ClusterIpManager.CLUSTER_IP)) {
                ClusterIpManager.this.processLeadershipChange(((Leadership)event.subject()).leader());
            }
        }
    }
}

