/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cordmcast;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.net.MediaType;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.filter.ClientFilter;
import com.sun.jersey.api.client.filter.HTTPBasicAuthFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Modified;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.onlab.packet.Ethernet;
import org.onlab.packet.IpAddress;
import org.onlab.packet.VlanId;
import org.onlab.util.Tools;
import org.onosproject.cfg.ComponentConfigService;
import org.onosproject.codec.CodecContext;
import org.onosproject.codec.CodecService;
import org.onosproject.codec.JsonCodec;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreService;
import org.onosproject.event.EventListener;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DeviceId;
import org.onosproject.net.config.ConfigFactory;
import org.onosproject.net.config.NetworkConfigEvent;
import org.onosproject.net.config.NetworkConfigListener;
import org.onosproject.net.config.NetworkConfigRegistry;
import org.onosproject.net.config.basics.SubjectFactories;
import org.onosproject.net.flow.DefaultTrafficSelector;
import org.onosproject.net.flow.DefaultTrafficTreatment;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flowobjective.DefaultForwardingObjective;
import org.onosproject.net.flowobjective.DefaultNextObjective;
import org.onosproject.net.flowobjective.FlowObjectiveService;
import org.onosproject.net.flowobjective.ForwardingObjective;
import org.onosproject.net.flowobjective.NextObjective;
import org.onosproject.net.flowobjective.Objective;
import org.onosproject.net.flowobjective.ObjectiveContext;
import org.onosproject.net.flowobjective.ObjectiveError;
import org.onosproject.net.mcast.McastEvent;
import org.onosproject.net.mcast.McastListener;
import org.onosproject.net.mcast.McastRoute;
import org.onosproject.net.mcast.McastRouteInfo;
import org.onosproject.net.mcast.MulticastRouteService;
import org.onosproject.olt.AccessDeviceConfig;
import org.onosproject.olt.AccessDeviceData;
import org.onosproject.rest.AbstractWebResource;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
public class CordMcast {
    private static final int DEFAULT_REST_TIMEOUT_MS = 2000;
    private static final int DEFAULT_PRIORITY = 500;
    private static final short DEFAULT_MCAST_VLAN = 4000;
    private static final String DEFAULT_SYNC_HOST = "10.90.0.8:8181";
    private static final String DEFAULT_USER = "karaf";
    private static final String DEFAULT_PASSWORD = "karaf";
    private static final boolean DEFAULT_VLAN_ENABLED = true;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected MulticastRouteService mcastService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected FlowObjectiveService flowObjectiveService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected CoreService coreService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected CodecService codecService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ComponentConfigService componentConfigService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected NetworkConfigRegistry networkConfig;
    protected McastListener listener = new InternalMulticastListener();
    private InternalNetworkConfigListener configListener = new InternalNetworkConfigListener();
    private Map<IpAddress, Integer> groups = Maps.newConcurrentMap();
    private ApplicationId appId;
    @Property(name="mcastVlan", intValue={4000}, label="VLAN for multicast traffic")
    private int mcastVlan = 4000;
    @Property(name="vlanEnabled", boolValue={true}, label="Use vlan for multicast traffic?")
    private boolean vlanEnabled = true;
    @Property(name="priority", intValue={500}, label="Priority for multicast rules")
    private int priority = 500;
    @Property(name="syncHost", value={"10.90.0.8:8181"}, label="host:port to synchronize routes to")
    private String syncHost = "10.90.0.8:8181";
    @Property(name="username", value={"karaf"}, label="Username for REST password authentication")
    private String user = "karaf";
    @Property(name="password", value={"karaf"}, label="Password for REST authentication")
    private String password = "karaf";
    private String fabricOnosUrl;
    private Map<DeviceId, AccessDeviceData> oltData = new ConcurrentHashMap<DeviceId, AccessDeviceData>();
    private static final Class<AccessDeviceConfig> CONFIG_CLASS = AccessDeviceConfig.class;
    private ConfigFactory<DeviceId, AccessDeviceConfig> configFactory = new ConfigFactory<DeviceId, AccessDeviceConfig>(SubjectFactories.DEVICE_SUBJECT_FACTORY, CONFIG_CLASS, "accessDevice"){

        public AccessDeviceConfig createConfig() {
            return new AccessDeviceConfig();
        }
    };

    @Activate
    public void activate(ComponentContext context) {
        this.componentConfigService.registerProperties(this.getClass());
        this.modified(context);
        this.appId = this.coreService.registerApplication("org.onosproject.cordmcast");
        this.clearRemoteRoutes();
        this.networkConfig.registerConfigFactory(this.configFactory);
        this.networkConfig.addListener((EventListener)this.configListener);
        this.networkConfig.getSubjects(DeviceId.class, AccessDeviceConfig.class).forEach(subject -> {
            AccessDeviceConfig config = (AccessDeviceConfig)this.networkConfig.getConfig(subject, AccessDeviceConfig.class);
            if (config != null) {
                AccessDeviceData data = config.getOlt();
                this.oltData.put(data.deviceId(), data);
            }
        });
        this.mcastService.addListener((EventListener)this.listener);
        this.mcastService.getRoutes().stream().map(r -> new ImmutablePair(r, (Object)this.mcastService.fetchSinks(r))).filter(pair -> pair.getRight() != null && !((Set)pair.getRight()).isEmpty()).forEach(pair -> ((Set)pair.getRight()).forEach(sink -> this.provisionGroup((McastRoute)pair.getLeft(), (ConnectPoint)sink)));
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.componentConfigService.unregisterProperties(this.getClass(), false);
        this.mcastService.removeListener((EventListener)this.listener);
        this.networkConfig.unregisterConfigFactory(this.configFactory);
        this.networkConfig.removeListener((EventListener)this.configListener);
        this.log.info("Stopped");
    }

    @Modified
    public void modified(ComponentContext context) {
        Dictionary properties = context != null ? context.getProperties() : new Properties();
        try {
            String s = Tools.get((Dictionary)properties, (String)"username");
            this.user = Strings.isNullOrEmpty((String)s) ? "karaf" : s.trim();
            s = Tools.get((Dictionary)properties, (String)"password");
            this.password = Strings.isNullOrEmpty((String)s) ? "karaf" : s.trim();
            s = Tools.get((Dictionary)properties, (String)"mcastVlan");
            this.mcastVlan = Strings.isNullOrEmpty((String)s) ? 4000 : (int)Short.parseShort(s.trim());
            s = Tools.get((Dictionary)properties, (String)"vlanEnabled");
            this.vlanEnabled = Strings.isNullOrEmpty((String)s) ? true : Boolean.parseBoolean(s.trim());
            s = Tools.get((Dictionary)properties, (String)"priority");
            this.priority = Strings.isNullOrEmpty((String)s) ? 500 : Integer.parseInt(s.trim());
            s = Tools.get((Dictionary)properties, (String)"syncHost");
            this.syncHost = Strings.isNullOrEmpty((String)s) ? DEFAULT_SYNC_HOST : s.trim();
        }
        catch (Exception e) {
            this.user = "karaf";
            this.password = "karaf";
            this.syncHost = DEFAULT_SYNC_HOST;
            this.mcastVlan = 4000;
            this.vlanEnabled = false;
            this.priority = 500;
        }
        this.fabricOnosUrl = CordMcast.createRemoteUrl(this.syncHost);
    }

    private static String createRemoteUrl(String remoteHost) {
        return "http://" + remoteHost + "/onos/v1/mcast";
    }

    private void unprovisionGroup(McastRouteInfo info) {
        if (info.sinks().isEmpty()) {
            this.removeRemoteRoute(info.route());
        }
        if (!info.sink().isPresent()) {
            this.log.warn("No sink given after sink removed event: {}", (Object)info);
            return;
        }
        ConnectPoint loc = (ConnectPoint)info.sink().get();
        NextObjective next = DefaultNextObjective.builder().fromApp(this.appId).addTreatment(DefaultTrafficTreatment.builder().setOutput(loc.port()).build()).withType(NextObjective.Type.BROADCAST).withId(this.groups.get(info.route().group()).intValue()).removeFromExisting(new ObjectiveContext(){

            public void onSuccess(Objective objective) {
                CordMcast.this.log.info("Next Objective {} installed", (Object)objective.id());
            }

            public void onError(Objective objective, ObjectiveError error) {
                CordMcast.this.log.info("Next Objective {} failed, because {}", (Object)objective.id(), (Object)error);
            }
        });
        this.flowObjectiveService.next(loc.deviceId(), next);
    }

    private void provisionGroup(McastRoute route, ConnectPoint sink) {
        Preconditions.checkNotNull((Object)route, (Object)"Route cannot be null");
        Preconditions.checkNotNull((Object)sink, (Object)"Sink cannot be null");
        AccessDeviceData oltInfo = this.oltData.get(sink.deviceId());
        if (oltInfo == null) {
            this.log.warn("Unknown OLT device : {}", (Object)sink.deviceId());
            return;
        }
        AtomicBoolean sync = new AtomicBoolean(false);
        Integer nextId = this.groups.computeIfAbsent(route.group(), g -> {
            Integer id = this.flowObjectiveService.allocateNextId();
            NextObjective next = DefaultNextObjective.builder().fromApp(this.appId).addTreatment(DefaultTrafficTreatment.builder().setOutput(sink.port()).build()).withType(NextObjective.Type.BROADCAST).withId(id.intValue()).add(new ObjectiveContext(){

                public void onSuccess(Objective objective) {
                    CordMcast.this.log.info("Next Objective {} installed", (Object)objective.id());
                }

                public void onError(Objective objective, ObjectiveError error) {
                    CordMcast.this.log.info("Next Objective {} failed, because {}", (Object)objective.id(), (Object)error);
                }
            });
            this.flowObjectiveService.next(sink.deviceId(), next);
            TrafficSelector.Builder mcast = DefaultTrafficSelector.builder().matchInPort(oltInfo.uplink()).matchEthType(Ethernet.TYPE_IPV4).matchIPDst(g.toIpPrefix());
            if (this.vlanEnabled) {
                mcast.matchVlanId(VlanId.vlanId((short)((short)this.mcastVlan)));
            }
            ForwardingObjective fwd = DefaultForwardingObjective.builder().fromApp(this.appId).nextStep(id.intValue()).makePermanent().withFlag(ForwardingObjective.Flag.VERSATILE).withPriority(this.priority).withSelector(mcast.build()).add(new ObjectiveContext(){

                public void onSuccess(Objective objective) {
                    CordMcast.this.log.info("Forwarding objective installed {}", (Object)objective);
                }

                public void onError(Objective objective, ObjectiveError error) {
                    CordMcast.this.log.info("Forwarding objective failed {}", (Object)objective);
                }
            });
            this.flowObjectiveService.forward(sink.deviceId(), fwd);
            sync.set(true);
            return id;
        });
        if (!sync.get()) {
            NextObjective next = DefaultNextObjective.builder().fromApp(this.appId).addTreatment(DefaultTrafficTreatment.builder().setOutput(sink.port()).build()).withType(NextObjective.Type.BROADCAST).withId(nextId.intValue()).addToExisting(new ObjectiveContext(){

                public void onSuccess(Objective objective) {
                    CordMcast.this.log.info("Next Objective {} installed", (Object)objective.id());
                }

                public void onError(Objective objective, ObjectiveError error) {
                    CordMcast.this.log.info("Next Objective {} failed, because {}", (Object)objective.id(), (Object)error);
                }
            });
            this.flowObjectiveService.next(sink.deviceId(), next);
        }
        this.addRemoteRoute(route);
    }

    private void addRemoteRoute(McastRoute route) {
        Preconditions.checkNotNull((Object)route);
        if (this.syncHost == null) {
            this.log.warn("No host configured for synchronization; route will be dropped");
            return;
        }
        this.log.debug("Sending route {} to other ONOS {}", (Object)route, (Object)this.fabricOnosUrl);
        WebResource.Builder builder = this.getClientBuilder(this.fabricOnosUrl);
        ObjectNode json = this.codecService.getCodec(McastRoute.class).encode((Object)route, (CodecContext)new AbstractWebResource());
        try {
            builder.post((Object)json.toString());
        }
        catch (ClientHandlerException e) {
            this.log.warn("Unable to send route to remote controller: {}", (Object)e.getMessage());
        }
    }

    private void removeRemoteRoute(McastRoute route) {
        if (this.syncHost == null) {
            this.log.warn("No host configured for synchronization; route will be dropped");
            return;
        }
        this.log.debug("Removing route {} from other ONOS {}", (Object)route, (Object)this.fabricOnosUrl);
        WebResource.Builder builder = this.getClientBuilder(this.fabricOnosUrl);
        ObjectNode json = this.codecService.getCodec(McastRoute.class).encode((Object)route, (CodecContext)new AbstractWebResource());
        try {
            builder.delete((Object)json.toString());
        }
        catch (ClientHandlerException e) {
            this.log.warn("Unable to delete route from remote controller: {}", (Object)e.getMessage());
        }
    }

    private void clearRemoteRoutes() {
        if (this.syncHost == null) {
            this.log.warn("No host configured for synchronization");
            return;
        }
        this.log.debug("Clearing remote multicast routes from {}", (Object)this.fabricOnosUrl);
        WebResource.Builder builder = this.getClientBuilder(this.fabricOnosUrl);
        ArrayList mcastRoutes = Lists.newArrayList();
        try {
            String response = (String)((WebResource.Builder)builder.accept(new javax.ws.rs.core.MediaType[]{javax.ws.rs.core.MediaType.APPLICATION_JSON_TYPE})).get(String.class);
            JsonCodec routeCodec = this.codecService.getCodec(McastRoute.class);
            ObjectMapper mapper = new ObjectMapper();
            ObjectNode node = (ObjectNode)mapper.readTree(response);
            ArrayNode list = (ArrayNode)node.path("routes");
            list.forEach(n -> mcastRoutes.add(routeCodec.decode((ObjectNode)n, (CodecContext)new AbstractWebResource())));
        }
        catch (ClientHandlerException e) {
            this.log.warn("Unable to clear routes from remote controller: {}", (Object)e.getMessage());
        }
        catch (IOException e) {
            this.log.warn("Error clearing remote routes", (Throwable)e);
        }
        mcastRoutes.forEach(this::removeRemoteRoute);
    }

    private WebResource.Builder getClientBuilder(String uri) {
        Client client = Client.create();
        client.setConnectTimeout(Integer.valueOf(2000));
        client.setReadTimeout(Integer.valueOf(2000));
        client.addFilter((ClientFilter)new HTTPBasicAuthFilter(this.user, this.password));
        WebResource resource = client.resource(uri);
        return (WebResource.Builder)resource.accept(new String[]{MediaType.JSON_UTF_8.toString()}).type(MediaType.JSON_UTF_8.toString());
    }

    protected void bindMcastService(MulticastRouteService multicastRouteService) {
        this.mcastService = multicastRouteService;
    }

    protected void unbindMcastService(MulticastRouteService multicastRouteService) {
        if (this.mcastService == multicastRouteService) {
            this.mcastService = null;
        }
    }

    protected void bindFlowObjectiveService(FlowObjectiveService flowObjectiveService) {
        this.flowObjectiveService = flowObjectiveService;
    }

    protected void unbindFlowObjectiveService(FlowObjectiveService flowObjectiveService) {
        if (this.flowObjectiveService == flowObjectiveService) {
            this.flowObjectiveService = null;
        }
    }

    protected void bindCoreService(CoreService coreService) {
        this.coreService = coreService;
    }

    protected void unbindCoreService(CoreService coreService) {
        if (this.coreService == coreService) {
            this.coreService = null;
        }
    }

    protected void bindCodecService(CodecService codecService) {
        this.codecService = codecService;
    }

    protected void unbindCodecService(CodecService codecService) {
        if (this.codecService == codecService) {
            this.codecService = null;
        }
    }

    protected void bindComponentConfigService(ComponentConfigService componentConfigService) {
        this.componentConfigService = componentConfigService;
    }

    protected void unbindComponentConfigService(ComponentConfigService componentConfigService) {
        if (this.componentConfigService == componentConfigService) {
            this.componentConfigService = null;
        }
    }

    protected void bindNetworkConfig(NetworkConfigRegistry networkConfigRegistry) {
        this.networkConfig = networkConfigRegistry;
    }

    protected void unbindNetworkConfig(NetworkConfigRegistry networkConfigRegistry) {
        if (this.networkConfig == networkConfigRegistry) {
            this.networkConfig = null;
        }
    }

    private class InternalNetworkConfigListener
    implements NetworkConfigListener {
        private InternalNetworkConfigListener() {
        }

        public void event(NetworkConfigEvent event) {
            switch ((NetworkConfigEvent.Type)event.type()) {
                case CONFIG_ADDED: 
                case CONFIG_UPDATED: {
                    AccessDeviceConfig config = (AccessDeviceConfig)CordMcast.this.networkConfig.getConfig((Object)((DeviceId)event.subject()), CONFIG_CLASS);
                    if (config == null) break;
                    CordMcast.this.oltData.put(config.getOlt().deviceId(), config.getOlt());
                    break;
                }
                case CONFIG_REGISTERED: 
                case CONFIG_UNREGISTERED: {
                    break;
                }
                case CONFIG_REMOVED: {
                    CordMcast.this.oltData.remove(event.subject());
                    break;
                }
            }
        }

        public boolean isRelevant(NetworkConfigEvent event) {
            return event.configClass().equals(CONFIG_CLASS);
        }
    }

    private class InternalMulticastListener
    implements McastListener {
        private InternalMulticastListener() {
        }

        public void event(McastEvent event) {
            McastRouteInfo info = (McastRouteInfo)event.subject();
            switch ((McastEvent.Type)event.type()) {
                case ROUTE_ADDED: {
                    break;
                }
                case ROUTE_REMOVED: {
                    break;
                }
                case SOURCE_ADDED: {
                    break;
                }
                case SINK_ADDED: {
                    if (!info.sink().isPresent()) {
                        CordMcast.this.log.warn("No sink given after sink added event: {}", (Object)info);
                        return;
                    }
                    CordMcast.this.provisionGroup(info.route(), (ConnectPoint)info.sink().get());
                    break;
                }
                case SINK_REMOVED: {
                    CordMcast.this.unprovisionGroup((McastRouteInfo)event.subject());
                    break;
                }
                default: {
                    CordMcast.this.log.warn("Unknown mcast event {}", (Object)event.type());
                }
            }
        }
    }
}

