/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cordfabric;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onlab.packet.VlanId;
import org.onosproject.cordfabric.CordFabricManager;
import org.onosproject.cordfabric.FabricService;
import org.onosproject.cordfabric.FabricVlan;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreService;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DeviceId;
import org.onosproject.net.PortNumber;
import org.onosproject.net.device.DeviceListener;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.flow.DefaultTrafficSelector;
import org.onosproject.net.flow.DefaultTrafficTreatment;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.flowobjective.DefaultForwardingObjective;
import org.onosproject.net.flowobjective.FlowObjectiveService;
import org.onosproject.net.flowobjective.ForwardingObjective;
import org.onosproject.net.flowobjective.ObjectiveContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
@Component(immediate=true)
public class CordFabricManager
implements FabricService {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private ApplicationId appId;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected CoreService coreService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected FlowObjectiveService flowObjectiveService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected DeviceService deviceService;
    private InternalDeviceListener deviceListener = new InternalDeviceListener(this, null);
    private static final int PRIORITY = 50000;
    private short radiusPort = (short)1812;
    private short ofPort = (short)6633;
    private DeviceId fabricDeviceId = DeviceId.deviceId((String)"of:5e3e486e73000187");
    private final Multimap<VlanId, ConnectPoint> vlans = HashMultimap.create();

    @Activate
    public void activate() {
        this.appId = this.coreService.registerApplication("org.onosproject.cordfabric");
        this.deviceService.addListener((DeviceListener)this.deviceListener);
        if (this.deviceService.isAvailable(this.fabricDeviceId)) {
            this.setupDefaultFlows();
        }
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.deviceService.removeListener((DeviceListener)this.deviceListener);
        this.log.info("Stopped");
    }

    private void setupDefaultFlows() {
        TrafficSelector ofInBandMatchUp = DefaultTrafficSelector.builder().matchEthType((short)2048).matchIPProtocol((byte)6).matchTcpDst(this.ofPort).matchInPort(PortNumber.portNumber((long)6L)).build();
        TrafficSelector ofInBandMatchDown = DefaultTrafficSelector.builder().matchEthType((short)2048).matchIPProtocol((byte)6).matchTcpSrc(this.ofPort).matchInPort(PortNumber.portNumber((long)1L)).build();
        TrafficTreatment up = DefaultTrafficTreatment.builder().setOutput(PortNumber.portNumber((long)1L)).build();
        TrafficTreatment down = DefaultTrafficTreatment.builder().setOutput(PortNumber.portNumber((long)6L)).build();
        TrafficSelector toRadius = DefaultTrafficSelector.builder().matchEthType((short)2048).matchIPProtocol((byte)17).matchUdpDst(this.radiusPort).build();
        TrafficTreatment puntToController = DefaultTrafficTreatment.builder().punt().build();
        ForwardingObjective radiusToController = DefaultForwardingObjective.builder().fromApp(this.appId).makePermanent().withFlag(ForwardingObjective.Flag.VERSATILE).withPriority(50000).withSelector(toRadius).withTreatment(puntToController).add();
        ForwardingObjective upCtrl = DefaultForwardingObjective.builder().fromApp(this.appId).makePermanent().withFlag(ForwardingObjective.Flag.VERSATILE).withPriority(50000).withSelector(ofInBandMatchUp).withTreatment(up).add();
        ForwardingObjective downCtrl = DefaultForwardingObjective.builder().fromApp(this.appId).makePermanent().withFlag(ForwardingObjective.Flag.VERSATILE).withPriority(50000).withSelector(ofInBandMatchDown).withTreatment(down).add();
        this.flowObjectiveService.forward(this.fabricDeviceId, upCtrl);
        this.flowObjectiveService.forward(this.fabricDeviceId, downCtrl);
        this.flowObjectiveService.forward(this.fabricDeviceId, radiusToController);
    }

    public void addVlan(FabricVlan vlan) {
        Preconditions.checkNotNull((Object)vlan);
        Preconditions.checkArgument((vlan.ports().size() > 1 ? 1 : 0) != 0);
        CordFabricManager.verifyPorts((List)vlan.ports());
        this.removeVlan(vlan.vlan());
        vlan.ports().forEach(cp -> {
            if (this.vlans.put((Object)vlan.vlan(), cp)) {
                this.addForwarding(vlan.vlan(), cp.deviceId(), cp.port(), vlan.ports().stream().filter(p -> p != cp).map(ConnectPoint::port).collect(Collectors.toList()));
            }
        });
    }

    public void removeVlan(VlanId vlanId) {
        this.vlans.removeAll((Object)vlanId).forEach(cp -> this.removeForwarding(vlanId, cp.deviceId(), cp.port()));
    }

    public List<FabricVlan> getVlans() {
        ArrayList<FabricVlan> fVlans = new ArrayList<FabricVlan>();
        this.vlans.keySet().forEach(vlan -> fVlans.add(new FabricVlan(vlan, this.vlans.get(vlan))));
        return fVlans;
    }

    private static void verifyPorts(List<ConnectPoint> ports) {
        DeviceId deviceId = ports.get(0).deviceId();
        for (ConnectPoint connectPoint : ports) {
            if (connectPoint.deviceId().equals((Object)deviceId)) continue;
            throw new IllegalArgumentException("Ports must all be on the same device");
        }
    }

    private void addForwarding(VlanId vlanId, DeviceId deviceId, PortNumber inPort, List<PortNumber> outPorts) {
        TrafficSelector selector = DefaultTrafficSelector.builder().matchVlanId(vlanId).matchInPort(inPort).build();
        TrafficTreatment.Builder treatmentBuilder = DefaultTrafficTreatment.builder();
        outPorts.forEach(p -> treatmentBuilder.setOutput(p));
        ForwardingObjective objective = DefaultForwardingObjective.builder().fromApp(this.appId).makePermanent().withFlag(ForwardingObjective.Flag.VERSATILE).withPriority(50000).withSelector(selector).withTreatment(treatmentBuilder.build()).add((ObjectiveContext)new ObjectiveHandler(null));
        this.flowObjectiveService.forward(deviceId, objective);
    }

    private void removeForwarding(VlanId vlanId, DeviceId deviceId, PortNumber inPort) {
        TrafficSelector selector = DefaultTrafficSelector.builder().matchVlanId(vlanId).matchInPort(inPort).build();
        ForwardingObjective objective = DefaultForwardingObjective.builder().fromApp(this.appId).makePermanent().withFlag(ForwardingObjective.Flag.VERSATILE).withPriority(50000).withSelector(selector).withTreatment(DefaultTrafficTreatment.builder().build()).remove((ObjectiveContext)new ObjectiveHandler(null));
        this.flowObjectiveService.forward(deviceId, objective);
    }

    static /* synthetic */ DeviceId access$200(CordFabricManager x0) {
        return x0.fabricDeviceId;
    }

    static /* synthetic */ void access$300(CordFabricManager x0) {
        x0.setupDefaultFlows();
    }

    protected void bindCoreService(CoreService coreService) {
        this.coreService = coreService;
    }

    protected void unbindCoreService(CoreService coreService) {
        if (this.coreService == coreService) {
            this.coreService = null;
        }
    }

    protected void bindFlowObjectiveService(FlowObjectiveService flowObjectiveService) {
        this.flowObjectiveService = flowObjectiveService;
    }

    protected void unbindFlowObjectiveService(FlowObjectiveService flowObjectiveService) {
        if (this.flowObjectiveService == flowObjectiveService) {
            this.flowObjectiveService = null;
        }
    }

    protected void bindDeviceService(DeviceService deviceService) {
        this.deviceService = deviceService;
    }

    protected void unbindDeviceService(DeviceService deviceService) {
        if (this.deviceService == deviceService) {
            this.deviceService = null;
        }
    }
}

