/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cordfabric;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import org.onlab.packet.VlanId;
import org.onosproject.codec.CodecContext;
import org.onosproject.codec.JsonCodec;
import org.onosproject.cordfabric.FabricVlan;
import org.onosproject.net.ConnectPoint;

public final class FabricVlanCodec
extends JsonCodec<FabricVlan> {
    private static final String VLAN = "vlan";
    private static final String PORTS = "ports";

    public ObjectNode encode(FabricVlan vlan, CodecContext context) {
        Preconditions.checkNotNull((Object)vlan, (Object)"Vlan cannot be null");
        ObjectNode result = context.mapper().createObjectNode().put(VLAN, vlan.vlan().toShort());
        ArrayNode jsonPorts = result.putArray(PORTS);
        vlan.ports().forEach(cp -> jsonPorts.add((JsonNode)context.codec(ConnectPoint.class).encode(cp, context)));
        return result;
    }

    public FabricVlan decode(ObjectNode json, CodecContext context) {
        short vlan = json.path(VLAN).shortValue();
        ArrayList<Object> ports = new ArrayList<Object>();
        ArrayNode portArray = (ArrayNode)json.path(PORTS);
        for (JsonNode o : portArray) {
            ports.add(context.codec(ConnectPoint.class).decode((ObjectNode)o, context));
        }
        return new FabricVlan(VlanId.vlanId((short)vlan), ports);
    }
}

