/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cordfabric;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.onlab.packet.VlanId;
import org.onosproject.codec.CodecContext;
import org.onosproject.cordfabric.FabricService;
import org.onosproject.cordfabric.FabricVlanCodec;
import org.onosproject.rest.AbstractWebResource;

/*
 * Exception performing whole class analysis ignored.
 */
@Path(value="vlans")
public class FabricWebResource
extends AbstractWebResource {
    private static final FabricVlanCodec VLAN_CODEC = new FabricVlanCodec();

    @GET
    @Produces(value={"application/json"})
    public Response getVlans() {
        FabricService fabricService = (FabricService)this.get(FabricService.class);
        List vlans = fabricService.getVlans();
        ObjectNode result = new ObjectMapper().createObjectNode();
        result.set("vlans", (JsonNode)new FabricVlanCodec().encode((Iterable)vlans, (CodecContext)this));
        return FabricWebResource.ok((Object)result.toString()).build();
    }

    @POST
    @Path(value="add")
    @Consumes(value={"application/json"})
    public Response addVlan(InputStream input) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        ObjectNode vlanJson = (ObjectNode)mapper.readTree(input);
        FabricService fabricService = (FabricService)this.get(FabricService.class);
        fabricService.addVlan(VLAN_CODEC.decode(vlanJson, (CodecContext)this));
        return Response.ok().build();
    }

    @DELETE
    @Path(value="{vlan}")
    public Response deleteVlan(@PathParam(value="vlan") String vlan) throws IOException {
        VlanId vlanId = VlanId.vlanId((short)Short.parseShort(vlan));
        FabricService fabricService = (FabricService)this.get(FabricService.class);
        fabricService.removeVlan(vlanId);
        return Response.ok().build();
    }
}

