/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cordfabric.cli;

import java.util.ArrayList;
import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.onlab.packet.VlanId;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.cordfabric.FabricService;
import org.onosproject.cordfabric.FabricVlan;
import org.onosproject.net.ConnectPoint;

@Command(scope="onos", name="add-fabric-vlan", description="Adds a VLAN to the fabric")
public class FabricAddCommand
extends AbstractShellCommand {
    @Argument(index=0, name="vlanid", description="VLAN ID", required=true, multiValued=false)
    private String vlanIdString = null;
    @Argument(index=1, name="ports", description="List of ports in the VLAN", required=true, multiValued=true)
    private String[] portStrings = null;

    protected void execute() {
        FabricService service = (FabricService)AbstractShellCommand.get(FabricService.class);
        VlanId vlan = VlanId.vlanId((short)Short.parseShort(this.vlanIdString));
        if (this.portStrings.length < 2) {
            throw new IllegalArgumentException("Must have at least 2 ports");
        }
        ArrayList<ConnectPoint> ports = new ArrayList<ConnectPoint>(this.portStrings.length);
        for (String portString : this.portStrings) {
            ports.add(ConnectPoint.deviceConnectPoint((String)portString));
        }
        service.addVlan(new FabricVlan(vlan, ports));
    }
}

