/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cordfabric.cli;

import java.util.List;
import org.apache.karaf.shell.commands.Command;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.cordfabric.FabricService;

@Command(scope="onos", name="fabric", description="Shows the fabric vlans")
public class FabricShowCommand
extends AbstractShellCommand {
    private static final String VLAN_HEADER_LINE_FORMAT = "VLAN %s";
    private static final String PORT_LINE_FORMAT = "\t%s";

    protected void execute() {
        FabricService service = (FabricService)AbstractShellCommand.get(FabricService.class);
        List vlans = service.getVlans();
        vlans.forEach(fabricVlan -> {
            this.print(VLAN_HEADER_LINE_FORMAT, new Object[]{fabricVlan.vlan()});
            fabricVlan.ports().forEach(cp -> this.print(PORT_LINE_FORMAT, new Object[]{cp}));
        });
    }
}

