/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cpman.cli;

import java.util.Optional;
import java.util.Set;
import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.cluster.ClusterService;
import org.onosproject.cluster.NodeId;
import org.onosproject.cpman.ControlLoad;
import org.onosproject.cpman.ControlMetricType;
import org.onosproject.cpman.ControlPlaneMonitorService;
import org.onosproject.cpman.ControlResource;
import org.onosproject.net.DeviceId;

/*
 * Exception performing whole class analysis ignored.
 */
@Command(scope="onos", name="cpman-stats-list", description="Lists control metrics statistics")
public class ControlMetricsStatsListCommand
extends AbstractShellCommand {
    private static final String FMT = "metricType=%s, latestValue=%d, averageValue=%d, latestTime=%s";
    private static final String INVALID_TYPE = "Invalid control resource type.";
    @Argument(index=0, name="type", description="Resource type (cpu|memory|disk|network|control_message)", required=true, multiValued=false)
    String type = null;
    @Argument(index=1, name="name", description="Resource name (or Device Id)", required=false, multiValued=false)
    String name = null;

    protected void execute() {
        ControlPlaneMonitorService service = (ControlPlaneMonitorService)ControlMetricsStatsListCommand.get(ControlPlaneMonitorService.class);
        ClusterService clusterService = (ClusterService)ControlMetricsStatsListCommand.get(ClusterService.class);
        NodeId nodeId = clusterService.getLocalNode().id();
        switch (this.type) {
            case "cpu": {
                this.printMetricsStats(service, nodeId, ControlResource.CPU_METRICS);
                break;
            }
            case "memory": {
                this.printMetricsStats(service, nodeId, ControlResource.MEMORY_METRICS);
                break;
            }
            case "disk": {
                this.printMetricsStats(service, nodeId, ControlResource.DISK_METRICS, this.name);
                break;
            }
            case "network": {
                this.printMetricsStats(service, nodeId, ControlResource.NETWORK_METRICS, this.name);
                break;
            }
            case "control_message": {
                if (this.name == null) break;
                this.printMetricsStats(service, nodeId, ControlResource.CONTROL_MESSAGE_METRICS, DeviceId.deviceId((String)this.name));
                break;
            }
            default: {
                this.print("Invalid control resource type.", new Object[0]);
            }
        }
    }

    private void printMetricsStats(ControlPlaneMonitorService service, NodeId nodeId, Set<ControlMetricType> typeSet) {
        this.printMetricsStats(service, nodeId, typeSet, null, null);
    }

    private void printMetricsStats(ControlPlaneMonitorService service, NodeId nodeId, Set<ControlMetricType> typeSet, String name) {
        this.printMetricsStats(service, nodeId, typeSet, name, null);
    }

    private void printMetricsStats(ControlPlaneMonitorService service, NodeId nodeId, Set<ControlMetricType> typeSet, DeviceId did) {
        this.printMetricsStats(service, nodeId, typeSet, null, did);
    }

    private void printMetricsStats(ControlPlaneMonitorService service, NodeId nodeId, Set<ControlMetricType> typeSet, String name, DeviceId did) {
        if (name == null && did == null) {
            typeSet.forEach(s -> this.print(s, service.getLoad(nodeId, s, Optional.ofNullable(null))));
        } else if (name == null && did != null) {
            typeSet.forEach(s -> this.print(s, service.getLoad(nodeId, s, Optional.of(did))));
        } else if (name != null && did == null) {
            typeSet.forEach(s -> this.print(s, service.getLoad(nodeId, s, name)));
        }
    }

    private void print(ControlMetricType type, ControlLoad cl) {
        if (cl != null) {
            this.print("metricType=%s, latestValue=%d, averageValue=%d, latestTime=%s", new Object[]{type.toString(), cl.latest(), cl.average(), cl.time()});
        }
    }
}

