/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cpman.impl;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.onlab.metrics.MetricsService;
import org.onosproject.cpman.ControlMetricType;
import org.onosproject.cpman.impl.ControlMetricsFactory;
import org.onosproject.cpman.impl.MetricsAggregator;
import org.onosproject.net.DeviceId;
import org.onosproject.net.device.DeviceService;

/*
 * Exception performing whole class analysis ignored.
 */
public final class ControlMetricsFactory {
    private MetricsService metricsService;
    private boolean enableMonitor = false;
    private Boolean isInitialized = false;
    private MetricsAggregator cpuLoad;
    private MetricsAggregator totalCpuTime;
    private MetricsAggregator sysCpuTime;
    private MetricsAggregator userCpuTime;
    private MetricsAggregator cpuIdleTime;
    private MetricsAggregator memoryUsed;
    private MetricsAggregator memoryFree;
    private MetricsAggregator memoryUsedRatio;
    private MetricsAggregator memoryFreeRatio;
    private Map<String, MetricsAggregator> diskReadBytes;
    private Map<String, MetricsAggregator> diskWriteBytes;
    private Map<String, MetricsAggregator> nwIncomingBytes;
    private Map<String, MetricsAggregator> nwOutgoingBytes;
    private Map<String, MetricsAggregator> nwIncomingPackets;
    private Map<String, MetricsAggregator> nwOutgoingPackets;
    private Map<DeviceId, MetricsAggregator> inboundPacket;
    private Map<DeviceId, MetricsAggregator> outboundPacket;
    private Map<DeviceId, MetricsAggregator> flowmodPacket;
    private Map<DeviceId, MetricsAggregator> flowrmvPacket;
    private Map<DeviceId, MetricsAggregator> requestPacket;
    private Map<DeviceId, MetricsAggregator> replyPacket;
    private Set<DeviceId> deviceIds = Sets.newConcurrentHashSet();
    private Set<String> diskPartitions = Sets.newConcurrentHashSet();
    private Set<String> nwInterfaces = Sets.newConcurrentHashSet();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialization(MetricsService metricsService, DeviceService deviceService) {
        Boolean bl = this.isInitialized;
        synchronized (bl) {
            if (!this.isInitialized.booleanValue()) {
                this.metricsService = metricsService;
                this.registerMetrics();
                deviceService.getDevices().forEach(d -> this.deviceIds.add(d.id()));
                this.addAllControlMessageMetrics(this.deviceIds);
                this.isInitialized = true;
            }
        }
    }

    public void addControlMessageMetricsByDeviceId(DeviceId deviceId) {
        MetricsAggregator inbound = new MetricsAggregator(this.metricsService, ControlMetricType.INBOUND_PACKET, Optional.of(deviceId));
        MetricsAggregator outbound = new MetricsAggregator(this.metricsService, ControlMetricType.OUTBOUND_PACKET, Optional.of(deviceId));
        MetricsAggregator flowmod = new MetricsAggregator(this.metricsService, ControlMetricType.FLOW_MOD_PACKET, Optional.of(deviceId));
        MetricsAggregator flowrmv = new MetricsAggregator(this.metricsService, ControlMetricType.FLOW_REMOVED_PACKET, Optional.of(deviceId));
        MetricsAggregator request = new MetricsAggregator(this.metricsService, ControlMetricType.REQUEST_PACKET, Optional.of(deviceId));
        MetricsAggregator reply = new MetricsAggregator(this.metricsService, ControlMetricType.REPLY_PACKET, Optional.of(deviceId));
        this.inboundPacket.putIfAbsent(deviceId, inbound);
        this.outboundPacket.putIfAbsent(deviceId, outbound);
        this.flowmodPacket.putIfAbsent(deviceId, flowmod);
        this.flowrmvPacket.putIfAbsent(deviceId, flowrmv);
        this.requestPacket.putIfAbsent(deviceId, request);
        this.replyPacket.putIfAbsent(deviceId, reply);
        this.deviceIds.add(deviceId);
    }

    public void addDiskMetricsByPartition(String partitionName) {
        MetricsAggregator readBytes = new MetricsAggregator(this.metricsService, ControlMetricType.DISK_READ_BYTES, partitionName);
        MetricsAggregator writeBytes = new MetricsAggregator(this.metricsService, ControlMetricType.DISK_WRITE_BYTES, partitionName);
        this.diskReadBytes.putIfAbsent(partitionName, readBytes);
        this.diskWriteBytes.putIfAbsent(partitionName, writeBytes);
        this.diskPartitions.add(partitionName);
    }

    public void addNetworkMetricsByInterface(String interfaceName) {
        MetricsAggregator incomingBytes = new MetricsAggregator(this.metricsService, ControlMetricType.NW_INCOMING_BYTES, interfaceName);
        MetricsAggregator outgoingBytes = new MetricsAggregator(this.metricsService, ControlMetricType.NW_OUTGOING_BYTES, interfaceName);
        MetricsAggregator incomingPackets = new MetricsAggregator(this.metricsService, ControlMetricType.NW_INCOMING_PACKETS, interfaceName);
        MetricsAggregator outgoingPackets = new MetricsAggregator(this.metricsService, ControlMetricType.NW_OUTGOING_PACKETS, interfaceName);
        this.nwIncomingBytes.putIfAbsent(interfaceName, incomingBytes);
        this.nwOutgoingBytes.putIfAbsent(interfaceName, outgoingBytes);
        this.nwIncomingPackets.putIfAbsent(interfaceName, incomingPackets);
        this.nwOutgoingPackets.putIfAbsent(interfaceName, outgoingPackets);
        this.nwInterfaces.add(interfaceName);
    }

    public void removeControlMessageMetricsByDeviceId(DeviceId deviceId) {
        this.inboundPacket.remove(deviceId);
        this.outboundPacket.remove(deviceId);
        this.flowmodPacket.remove(deviceId);
        this.flowrmvPacket.remove(deviceId);
        this.requestPacket.remove(deviceId);
        this.replyPacket.remove(deviceId);
        this.deviceIds.remove(deviceId);
    }

    public void removeDiskMetricsByResourceName(String partitionName) {
        this.diskReadBytes.remove(partitionName);
        this.diskWriteBytes.remove(partitionName);
        this.diskPartitions.remove(partitionName);
    }

    public void removeNetworkInterfacesByResourceName(String interfaceName) {
        this.nwIncomingBytes.remove(interfaceName);
        this.nwOutgoingBytes.remove(interfaceName);
        this.nwIncomingPackets.remove(interfaceName);
        this.nwOutgoingPackets.remove(interfaceName);
        this.nwInterfaces.remove(interfaceName);
    }

    public Set<DeviceId> getDeviceIds() {
        return ImmutableSet.copyOf((Collection)this.deviceIds);
    }

    public Set<String> getDiskPartitions() {
        return ImmutableSet.copyOf((Collection)this.diskPartitions);
    }

    public Set<String> getNetworkInterfaces() {
        return ImmutableSet.copyOf((Collection)this.nwInterfaces);
    }

    public void addAllControlMessageMetrics(Set<DeviceId> deviceIds) {
        deviceIds.forEach(v -> this.addControlMessageMetricsByDeviceId(v));
    }

    public boolean isMonitor() {
        return this.enableMonitor;
    }

    protected void startMonitor() {
        this.enableMonitor = true;
    }

    protected void stopMonitor() {
        this.enableMonitor = false;
    }

    protected void registerMetrics() {
        this.cpuLoad = new MetricsAggregator(this.metricsService, ControlMetricType.CPU_LOAD);
        this.totalCpuTime = new MetricsAggregator(this.metricsService, ControlMetricType.TOTAL_CPU_TIME);
        this.sysCpuTime = new MetricsAggregator(this.metricsService, ControlMetricType.SYS_CPU_TIME);
        this.userCpuTime = new MetricsAggregator(this.metricsService, ControlMetricType.USER_CPU_TIME);
        this.cpuIdleTime = new MetricsAggregator(this.metricsService, ControlMetricType.CPU_IDLE_TIME);
        this.memoryFree = new MetricsAggregator(this.metricsService, ControlMetricType.MEMORY_FREE);
        this.memoryUsed = new MetricsAggregator(this.metricsService, ControlMetricType.MEMORY_USED);
        this.memoryFreeRatio = new MetricsAggregator(this.metricsService, ControlMetricType.MEMORY_FREE_RATIO);
        this.memoryUsedRatio = new MetricsAggregator(this.metricsService, ControlMetricType.MEMORY_USED_RATIO);
        this.diskReadBytes = new ConcurrentHashMap();
        this.diskWriteBytes = new ConcurrentHashMap();
        this.nwIncomingBytes = new ConcurrentHashMap();
        this.nwOutgoingBytes = new ConcurrentHashMap();
        this.nwIncomingPackets = new ConcurrentHashMap();
        this.nwOutgoingPackets = new ConcurrentHashMap();
        this.inboundPacket = new ConcurrentHashMap();
        this.outboundPacket = new ConcurrentHashMap();
        this.flowmodPacket = new ConcurrentHashMap();
        this.flowrmvPacket = new ConcurrentHashMap();
        this.requestPacket = new ConcurrentHashMap();
        this.replyPacket = new ConcurrentHashMap();
    }

    protected void unregisterMetrics() {
        this.diskReadBytes.clear();
        this.diskWriteBytes.clear();
        this.nwIncomingBytes.clear();
        this.nwOutgoingBytes.clear();
        this.nwIncomingPackets.clear();
        this.nwOutgoingPackets.clear();
        this.inboundPacket.clear();
        this.outboundPacket.clear();
        this.flowmodPacket.clear();
        this.flowrmvPacket.clear();
        this.requestPacket.clear();
        this.replyPacket.clear();
    }

    public MetricsAggregator cpuLoadMetric() {
        return this.cpuLoad;
    }

    public MetricsAggregator totalCpuTimeMetric() {
        return this.totalCpuTime;
    }

    public MetricsAggregator sysCpuTimeMetric() {
        return this.sysCpuTime;
    }

    public MetricsAggregator userCpuTime() {
        return this.userCpuTime;
    }

    public MetricsAggregator cpuIdleTime() {
        return this.cpuIdleTime;
    }

    public MetricsAggregator memoryFreeRatio() {
        return this.memoryFreeRatio;
    }

    public MetricsAggregator memoryUsedRatio() {
        return this.memoryUsedRatio;
    }

    public MetricsAggregator diskReadBytes(String resourceName) {
        return (MetricsAggregator)this.diskReadBytes.get(resourceName);
    }

    public MetricsAggregator diskWriteBytes(String resourceName) {
        return (MetricsAggregator)this.diskWriteBytes.get(resourceName);
    }

    public MetricsAggregator nwIncomingBytes(String interfaceName) {
        return (MetricsAggregator)this.nwIncomingBytes.get(interfaceName);
    }

    public MetricsAggregator nwOutgoingBytes(String interfaceName) {
        return (MetricsAggregator)this.nwOutgoingBytes.get(interfaceName);
    }

    public MetricsAggregator nwIncomingPackets(String interfaceName) {
        return (MetricsAggregator)this.nwIncomingPackets.get(interfaceName);
    }

    public MetricsAggregator nwOutgoingPackets(String interfaceName) {
        return (MetricsAggregator)this.nwOutgoingPackets.get(interfaceName);
    }

    public Map<DeviceId, MetricsAggregator> inboundPacket() {
        return ImmutableMap.copyOf((Map)this.inboundPacket);
    }

    public Map<DeviceId, MetricsAggregator> outboundPacket() {
        return ImmutableMap.copyOf((Map)this.outboundPacket);
    }

    public Map<DeviceId, MetricsAggregator> flowmodPacket() {
        return ImmutableMap.copyOf((Map)this.flowmodPacket);
    }

    public Map<DeviceId, MetricsAggregator> flowrmvPacket() {
        return ImmutableMap.copyOf((Map)this.flowrmvPacket);
    }

    public Map<DeviceId, MetricsAggregator> requestPacket() {
        return ImmutableMap.copyOf((Map)this.requestPacket);
    }

    public Map<DeviceId, MetricsAggregator> replyPacket() {
        return ImmutableMap.copyOf((Map)this.replyPacket);
    }

    public MetricsAggregator inboundPacket(DeviceId deviceId) {
        return (MetricsAggregator)this.inboundPacket.get(deviceId);
    }

    public MetricsAggregator outboundPacket(DeviceId deviceId) {
        return (MetricsAggregator)this.outboundPacket.get(deviceId);
    }

    public MetricsAggregator flowmodPacket(DeviceId deviceId) {
        return (MetricsAggregator)this.flowmodPacket.get(deviceId);
    }

    public MetricsAggregator flowrmvPacket(DeviceId deviceId) {
        return (MetricsAggregator)this.flowrmvPacket.get(deviceId);
    }

    public MetricsAggregator requestPacket(DeviceId deviceId) {
        return (MetricsAggregator)this.requestPacket.get(deviceId);
    }

    public MetricsAggregator replyPacket(DeviceId deviceId) {
        return (MetricsAggregator)this.replyPacket.get(deviceId);
    }

    public static ControlMetricsFactory getInstance() {
        return SingletonHelper.access$000();
    }
}

