/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cpman.impl;

import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreService;
import org.onosproject.cpman.ControlMessage;
import org.onosproject.cpman.ControlMetric;
import org.onosproject.cpman.ControlPlaneMonitorService;
import org.onosproject.cpman.MetricValue;
import org.onosproject.cpman.impl.ControlMessageMetricMapper;
import org.onosproject.cpman.impl.ControlPlaneManager;
import org.onosproject.cpman.message.ControlMessageListener;
import org.onosproject.cpman.message.ControlMessageService;
import org.onosproject.event.EventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
public class ControlPlaneManager {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected CoreService coreService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ControlMessageService messageService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ControlPlaneMonitorService monitorService;
    private final ControlMessageListener messageListener = new InternalControlMessageListener(this, null);
    private ApplicationId appId;

    @Activate
    protected void activate() {
        this.appId = this.coreService.registerApplication("org.onosproject.cpman");
        this.messageService.addListener((EventListener)this.messageListener);
        this.log.info("Started");
    }

    @Deactivate
    protected void deactivate() {
        this.messageService.removeListener((EventListener)this.messageListener);
        this.log.info("Stopped");
    }

    private ControlMetric getControlMetric(ControlMessage message) {
        MetricValue mv = new MetricValue.Builder().load(message.load()).rate(message.rate()).count(message.count()).add();
        return new ControlMetric(ControlMessageMetricMapper.lookupControlMetricType((ControlMessage.Type)message.type()), mv);
    }

    static /* synthetic */ ControlMetric access$100(ControlPlaneManager x0, ControlMessage x1) {
        return x0.getControlMetric(x1);
    }

    protected void bindCoreService(CoreService coreService) {
        this.coreService = coreService;
    }

    protected void unbindCoreService(CoreService coreService) {
        if (this.coreService == coreService) {
            this.coreService = null;
        }
    }

    protected void bindMessageService(ControlMessageService controlMessageService) {
        this.messageService = controlMessageService;
    }

    protected void unbindMessageService(ControlMessageService controlMessageService) {
        if (this.messageService == controlMessageService) {
            this.messageService = null;
        }
    }

    protected void bindMonitorService(ControlPlaneMonitorService controlPlaneMonitorService) {
        this.monitorService = controlPlaneMonitorService;
    }

    protected void unbindMonitorService(ControlPlaneMonitorService controlPlaneMonitorService) {
        if (this.monitorService == controlPlaneMonitorService) {
            this.monitorService = null;
        }
    }
}

