/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cpman.impl;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onosproject.cluster.ClusterService;
import org.onosproject.cluster.ControllerNode;
import org.onosproject.cluster.NodeId;
import org.onosproject.cpman.ControlLoad;
import org.onosproject.cpman.ControlMetric;
import org.onosproject.cpman.ControlMetricType;
import org.onosproject.cpman.ControlPlaneMonitorService;
import org.onosproject.cpman.ControlResource;
import org.onosproject.cpman.MetricsDatabase;
import org.onosproject.cpman.impl.DefaultControlLoad;
import org.onosproject.cpman.impl.DefaultMetricsDatabase;
import org.onosproject.net.DeviceId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
public class ControlPlaneMonitor
implements ControlPlaneMonitorService {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private MetricsDatabase cpuMetrics;
    private MetricsDatabase memoryMetrics;
    private Map<DeviceId, MetricsDatabase> controlMessageMap;
    private Map<String, MetricsDatabase> diskMetricsMap;
    private Map<String, MetricsDatabase> networkMetricsMap;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ClusterService clusterService;
    private static final Set RESOURCE_TYPE_SET = ImmutableSet.of((Object)ControlResource.Type.CONTROL_MESSAGE, (Object)ControlResource.Type.DISK, (Object)ControlResource.Type.NETWORK);
    private Map<ControlMetricType, Double> cpuBuf;
    private Map<ControlMetricType, Double> memoryBuf;
    private Map<String, Map<ControlMetricType, Double>> diskBuf;
    private Map<String, Map<ControlMetricType, Double>> networkBuf;
    private Map<DeviceId, Map<ControlMetricType, Double>> ctrlMsgBuf;
    private Map<ControlResource.Type, Set<String>> availableResourceMap;
    private Set<DeviceId> availableDeviceIdSet;

    @Activate
    public void activate() {
        this.cpuMetrics = this.genMDbBuilder(ControlResource.Type.CPU, ControlResource.CPU_METRICS);
        this.memoryMetrics = this.genMDbBuilder(ControlResource.Type.MEMORY, ControlResource.MEMORY_METRICS);
        this.controlMessageMap = Maps.newConcurrentMap();
        this.diskMetricsMap = Maps.newConcurrentMap();
        this.networkMetricsMap = Maps.newConcurrentMap();
        this.cpuBuf = Maps.newConcurrentMap();
        this.memoryBuf = Maps.newConcurrentMap();
        this.diskBuf = Maps.newConcurrentMap();
        this.networkBuf = Maps.newConcurrentMap();
        this.ctrlMsgBuf = Maps.newConcurrentMap();
        this.availableResourceMap = Maps.newConcurrentMap();
        this.availableDeviceIdSet = Sets.newConcurrentHashSet();
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.cpuBuf.clear();
        this.memoryBuf.clear();
        this.diskBuf.clear();
        this.networkBuf.clear();
        this.ctrlMsgBuf.clear();
        this.log.info("Stopped");
    }

    public void updateMetric(ControlMetric cm, int updateIntervalInMinutes, Optional<DeviceId> deviceId) {
        if (deviceId.isPresent()) {
            this.ctrlMsgBuf.putIfAbsent(deviceId.get(), Maps.newConcurrentMap());
            if (ControlResource.CONTROL_MESSAGE_METRICS.contains(cm.metricType())) {
                if (!this.availableDeviceIdSet.contains(deviceId.get())) {
                    this.availableDeviceIdSet.add(deviceId.get());
                }
                ((Map)this.ctrlMsgBuf.get(deviceId.get())).putIfAbsent(cm.metricType(), Double.valueOf(cm.metricValue().getLoad()));
                if (((Map)this.ctrlMsgBuf.get(deviceId.get())).keySet().containsAll(ControlResource.CONTROL_MESSAGE_METRICS)) {
                    this.updateControlMessages((Map)this.ctrlMsgBuf.get(deviceId.get()), deviceId.get());
                    ((Map)this.ctrlMsgBuf.get(deviceId.get())).clear();
                }
            }
        } else {
            if (ControlResource.CPU_METRICS.contains(cm.metricType())) {
                this.cpuBuf.putIfAbsent(cm.metricType(), Double.valueOf(cm.metricValue().getLoad()));
                if (this.cpuBuf.keySet().containsAll(ControlResource.CPU_METRICS)) {
                    this.cpuMetrics.updateMetrics(this.convertMap(this.cpuBuf));
                    this.cpuBuf.clear();
                }
            }
            if (ControlResource.MEMORY_METRICS.contains(cm.metricType())) {
                this.memoryBuf.putIfAbsent(cm.metricType(), Double.valueOf(cm.metricValue().getLoad()));
                if (this.memoryBuf.keySet().containsAll(ControlResource.MEMORY_METRICS)) {
                    this.memoryMetrics.updateMetrics(this.convertMap(this.memoryBuf));
                    this.memoryBuf.clear();
                }
            }
        }
    }

    public void updateMetric(ControlMetric cm, int updateIntervalInMinutes, String resourceName) {
        if (ControlResource.DISK_METRICS.contains(cm.metricType())) {
            this.diskBuf.putIfAbsent(resourceName, Maps.newConcurrentMap());
            this.availableResourceMap.putIfAbsent(ControlResource.Type.DISK, Sets.newHashSet());
            this.availableResourceMap.computeIfPresent(ControlResource.Type.DISK, (k, v) -> {
                v.add(resourceName);
                return v;
            });
            ((Map)this.diskBuf.get(resourceName)).putIfAbsent(cm.metricType(), Double.valueOf(cm.metricValue().getLoad()));
            if (((Map)this.diskBuf.get(resourceName)).keySet().containsAll(ControlResource.DISK_METRICS)) {
                this.updateDiskMetrics((Map)this.diskBuf.get(resourceName), resourceName);
                this.diskBuf.clear();
            }
        }
        if (ControlResource.NETWORK_METRICS.contains(cm.metricType())) {
            this.networkBuf.putIfAbsent(resourceName, Maps.newConcurrentMap());
            this.availableResourceMap.putIfAbsent(ControlResource.Type.NETWORK, Sets.newHashSet());
            this.availableResourceMap.computeIfPresent(ControlResource.Type.NETWORK, (k, v) -> {
                v.add(resourceName);
                return v;
            });
            ((Map)this.networkBuf.get(resourceName)).putIfAbsent(cm.metricType(), Double.valueOf(cm.metricValue().getLoad()));
            if (((Map)this.networkBuf.get(resourceName)).keySet().containsAll(ControlResource.NETWORK_METRICS)) {
                this.updateNetworkMetrics((Map)this.networkBuf.get(resourceName), resourceName);
                this.networkBuf.clear();
            }
        }
    }

    public ControlLoad getLoad(NodeId nodeId, ControlMetricType type, Optional<DeviceId> deviceId) {
        ControllerNode node = this.clusterService.getNode(nodeId);
        if (this.clusterService.getLocalNode().equals(node)) {
            if (deviceId.isPresent()) {
                if (ControlResource.CONTROL_MESSAGE_METRICS.contains(type) && this.availableDeviceIdSet.contains(deviceId.get())) {
                    return new DefaultControlLoad((MetricsDatabase)this.controlMessageMap.get(deviceId.get()), type);
                }
            } else {
                if (ControlResource.CPU_METRICS.contains(type)) {
                    return new DefaultControlLoad(this.cpuMetrics, type);
                }
                if (ControlResource.MEMORY_METRICS.contains(type)) {
                    return new DefaultControlLoad(this.memoryMetrics, type);
                }
            }
        } else {
            return null;
        }
        return null;
    }

    public ControlLoad getLoad(NodeId nodeId, ControlMetricType type, String resourceName) {
        if (this.clusterService.getLocalNode().id().equals((Object)nodeId)) {
            if (ControlResource.DISK_METRICS.contains(type) && this.availableResources(ControlResource.Type.DISK).contains(resourceName)) {
                return new DefaultControlLoad((MetricsDatabase)this.diskMetricsMap.get(resourceName), type);
            }
            if (ControlResource.NETWORK_METRICS.contains(type) && this.availableResources(ControlResource.Type.NETWORK).contains(resourceName)) {
                return new DefaultControlLoad((MetricsDatabase)this.networkMetricsMap.get(resourceName), type);
            }
        } else {
            return null;
        }
        return null;
    }

    public Set<String> availableResources(ControlResource.Type resourceType) {
        if (RESOURCE_TYPE_SET.contains(resourceType)) {
            if (ControlResource.Type.CONTROL_MESSAGE.equals((Object)resourceType)) {
                return this.availableDeviceIdSet.stream().map(id -> id.toString()).collect(Collectors.toSet());
            }
            return (Set)this.availableResourceMap.get(resourceType);
        }
        return null;
    }

    private MetricsDatabase genMDbBuilder(ControlResource.Type resourceType, Set<ControlMetricType> metricTypes) {
        DefaultMetricsDatabase.Builder builder = new DefaultMetricsDatabase.Builder();
        builder.withMetricName(resourceType.toString());
        metricTypes.forEach(arg_0 -> ControlPlaneMonitor.lambda$genMDbBuilder$7((MetricsDatabase.Builder)builder, arg_0));
        return builder.build();
    }

    private void updateNetworkMetrics(Map<ControlMetricType, Double> metricMap, String resName) {
        this.networkMetricsMap.putIfAbsent(resName, this.genMDbBuilder(ControlResource.Type.NETWORK, ControlResource.NETWORK_METRICS));
        ((MetricsDatabase)this.networkMetricsMap.get(resName)).updateMetrics(this.convertMap(metricMap));
    }

    private void updateDiskMetrics(Map<ControlMetricType, Double> metricMap, String resName) {
        this.diskMetricsMap.putIfAbsent(resName, this.genMDbBuilder(ControlResource.Type.DISK, ControlResource.DISK_METRICS));
        ((MetricsDatabase)this.diskMetricsMap.get(resName)).updateMetrics(this.convertMap(metricMap));
    }

    private void updateControlMessages(Map<ControlMetricType, Double> metricMap, DeviceId devId) {
        this.controlMessageMap.putIfAbsent(devId, this.genMDbBuilder(ControlResource.Type.CONTROL_MESSAGE, ControlResource.CONTROL_MESSAGE_METRICS));
        ((MetricsDatabase)this.controlMessageMap.get(devId)).updateMetrics(this.convertMap(metricMap));
    }

    private Map convertMap(Map<ControlMetricType, Double> map) {
        ConcurrentMap newMap = Maps.newConcurrentMap();
        map.forEach((k, v) -> newMap.putIfAbsent(k.toString(), v));
        return newMap;
    }

    private static /* synthetic */ void lambda$genMDbBuilder$7(MetricsDatabase.Builder builder, ControlMetricType type) {
        builder.addMetricType(type.toString());
    }

    protected void bindClusterService(ClusterService clusterService) {
        this.clusterService = clusterService;
    }

    protected void unbindClusterService(ClusterService clusterService) {
        if (this.clusterService == clusterService) {
            this.clusterService = null;
        }
    }
}

