/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cpman.impl;

import java.util.Optional;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.onosproject.cpman.ControlMetric;
import org.onosproject.cpman.ControlPlaneMonitorService;
import org.onosproject.cpman.MetricValue;
import org.onosproject.cpman.impl.ControlMetricsObserver;
import org.onosproject.cpman.impl.MetricsAggregator;
import org.onosproject.net.DeviceId;

public class DefaultControlMetricsObserver
implements ControlMetricsObserver {
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ControlPlaneMonitorService controlPlaneMonitorService;

    public void feedMetrics(MetricsAggregator ma, Optional<DeviceId> deviceId) {
        MetricValue mv = new MetricValue.Builder().rate(ma.getRate()).count(ma.getCount()).load(ma.getLoad()).add();
        ControlMetric cm = new ControlMetric(ma.getMetricsType(), mv);
        this.controlPlaneMonitorService.updateMetric(cm, 1, deviceId);
    }

    public void feedMetrics(MetricsAggregator ma, String resourceName) {
        MetricValue mv = new MetricValue.Builder().rate(ma.getRate()).count(ma.getCount()).load(ma.getLoad()).add();
        ControlMetric cm = new ControlMetric(ma.getMetricsType(), mv);
        this.controlPlaneMonitorService.updateMetric(cm, 1, resourceName);
    }
}

