/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cpman.impl;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.ArrayUtils;
import org.onosproject.cpman.MetricsDatabase;
import org.rrd4j.ConsolFun;
import org.rrd4j.core.FetchRequest;
import org.rrd4j.core.RrdDb;
import org.rrd4j.core.Sample;

public final class DefaultMetricsDatabase
implements MetricsDatabase {
    private String metricName;
    private RrdDb rrdDb;
    private Sample sample;
    private static final long SECONDS_OF_DAY = 86400L;
    private static final long SECONDS_OF_MINUTE = 60L;
    private static final ConsolFun CONSOL_FUNCTION = ConsolFun.LAST;
    private static final String NON_EXIST_METRIC = "Non-existing metric type.";
    private static final String INSUFFICIENT_DURATION = "Given duration less than one minute.";
    private static final String EXCEEDED_DURATION = "Given duration exceeds a day time.";

    private DefaultMetricsDatabase(String metricName, RrdDb rrdDb) {
        this.metricName = metricName;
        this.rrdDb = rrdDb;
    }

    public String metricName() {
        return this.metricName;
    }

    public void updateMetric(String metricType, double value) {
        this.updateMetric(metricType, value, System.currentTimeMillis() / 1000L);
    }

    public void updateMetric(String metricType, double value, long time) {
        try {
            Preconditions.checkArgument((boolean)this.rrdDb.containsDs(metricType), (Object)NON_EXIST_METRIC);
            this.sample = this.rrdDb.createSample(time);
            this.sample.setValue(metricType, value);
            this.sample.update();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void updateMetrics(Map<String, Double> metrics) {
        this.updateMetrics(metrics, System.currentTimeMillis() / 1000L);
    }

    public void updateMetrics(Map<String, Double> metrics, long time) {
        try {
            this.sample = this.rrdDb.createSample(time);
            metrics.forEach((k, v) -> {
                try {
                    Preconditions.checkArgument((boolean)this.rrdDb.containsDs(k), (Object)NON_EXIST_METRIC);
                    this.sample.setValue(k, v.doubleValue());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            });
            this.sample.update();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public double recentMetric(String metricType) {
        try {
            Preconditions.checkArgument((boolean)this.rrdDb.containsDs(metricType), (Object)NON_EXIST_METRIC);
            return this.rrdDb.getDatasource(metricType).getLastValue();
        }
        catch (IOException e) {
            e.printStackTrace();
            return 0.0;
        }
    }

    public double[] recentMetrics(String metricType, int duration, TimeUnit unit) {
        try {
            Preconditions.checkArgument((boolean)this.rrdDb.containsDs(metricType), (Object)NON_EXIST_METRIC);
            long endTime = this.rrdDb.getLastUpdateTime();
            long startTime = endTime - TimeUnit.SECONDS.convert(duration, unit);
            if (this.checkTimeRange(startTime, endTime)) {
                FetchRequest fr = this.rrdDb.createFetchRequest(CONSOL_FUNCTION, startTime, endTime);
                return this.arrangeDataPoints(fr.fetchData().getValues(metricType));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return new double[0];
    }

    public double minMetric(String metricType) {
        try {
            Preconditions.checkArgument((boolean)this.rrdDb.containsDs(metricType), (Object)NON_EXIST_METRIC);
            long endTime = this.rrdDb.getLastUpdateTime() - 1L;
            long startTime = endTime - 86400L + 1L;
            return this.minMetric(metricType, startTime, endTime);
        }
        catch (IOException e) {
            e.printStackTrace();
            return 0.0;
        }
    }

    public double maxMetric(String metricType) {
        try {
            Preconditions.checkArgument((boolean)this.rrdDb.containsDs(metricType), (Object)NON_EXIST_METRIC);
            long endTime = this.rrdDb.getLastUpdateTime();
            long startTime = endTime - 86400L;
            return this.maxMetric(metricType, startTime, endTime);
        }
        catch (IOException e) {
            e.printStackTrace();
            return 0.0;
        }
    }

    public double[] metrics(String metricType) {
        try {
            Preconditions.checkArgument((boolean)this.rrdDb.containsDs(metricType), (Object)NON_EXIST_METRIC);
            long endTime = this.rrdDb.getLastUpdateTime();
            long startTime = endTime - 86400L;
            return this.metrics(metricType, startTime, endTime);
        }
        catch (IOException e) {
            e.printStackTrace();
            return new double[0];
        }
    }

    public double[] metrics(String metricType, long startTime, long endTime) {
        try {
            Preconditions.checkArgument((boolean)this.rrdDb.containsDs(metricType), (Object)NON_EXIST_METRIC);
            if (this.checkTimeRange(startTime, endTime)) {
                FetchRequest fr = this.rrdDb.createFetchRequest(CONSOL_FUNCTION, startTime, endTime);
                return this.arrangeDataPoints(fr.fetchData().getValues(metricType));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return new double[0];
    }

    public long lastUpdate(String metricType) {
        try {
            Preconditions.checkArgument((boolean)this.rrdDb.containsDs(metricType), (Object)NON_EXIST_METRIC);
            this.rrdDb.getLastUpdateTime();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return 0L;
    }

    private boolean checkTimeRange(long startTime, long endTime) {
        Preconditions.checkArgument((endTime - startTime >= 60L ? 1 : 0) != 0, (Object)INSUFFICIENT_DURATION);
        Preconditions.checkArgument((endTime - startTime <= 86400L ? 1 : 0) != 0, (Object)EXCEEDED_DURATION);
        return true;
    }

    private double[] arrangeDataPoints(double[] data) {
        return Arrays.copyOfRange(data, 1, data.length - 1);
    }

    private double maxMetric(String metricType, long startTime, long endTime) {
        double[] all = this.metrics(metricType, startTime, endTime);
        List<Double> list = Arrays.asList(ArrayUtils.toObject((double[])all));
        return (Double)((Comparable)Collections.max(list));
    }

    private double minMetric(String metricType, long startTime, long endTime) {
        double[] all = this.metrics(metricType, startTime, endTime);
        List<Double> list = Arrays.asList(ArrayUtils.toObject((double[])all));
        return (Double)((Comparable)Collections.min(list));
    }
}

