/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cpman.impl;

import com.codahale.metrics.Meter;
import com.google.common.base.Preconditions;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.onlab.metrics.MetricsComponent;
import org.onlab.metrics.MetricsFeature;
import org.onlab.metrics.MetricsService;
import org.onosproject.cpman.ControlMetricType;
import org.onosproject.net.DeviceId;

public class MetricsAggregator {
    private Meter rateMeter;
    private Meter countMeter;
    private MetricsService metricsService;
    private MetricsComponent metricsComponent;
    private MetricsFeature metricsFeature;
    private ControlMetricType metricsType;
    private static final int EXECUTE_PERIOD_IN_SECOND = 60;
    private static final String RATE_NAME = "rate";
    private static final String COUNT_NAME = "count";

    MetricsAggregator(MetricsService metricsService, ControlMetricType type, Optional<DeviceId> deviceId) {
        this.init(metricsService, type, deviceId, null);
    }

    MetricsAggregator(MetricsService metricsService, ControlMetricType type, String resourceName) {
        this.init(metricsService, type, Optional.ofNullable(null), resourceName);
    }

    MetricsAggregator(MetricsService metricsService, ControlMetricType type) {
        this.init(metricsService, type, Optional.ofNullable(null), null);
    }

    private void init(MetricsService metricsService, ControlMetricType type, Optional<DeviceId> deviceId, String resourceName) {
        String primitiveName = type.toString();
        String objName = "all";
        if (deviceId.isPresent()) {
            objName = deviceId.toString();
        }
        if (StringUtils.isNotEmpty((CharSequence)resourceName)) {
            objName = resourceName;
        }
        Preconditions.checkNotNull((Object)primitiveName, (Object)"Component name cannot be null");
        Preconditions.checkNotNull((Object)objName, (Object)"Feature name cannot be null");
        this.metricsType = type;
        this.metricsService = metricsService;
        this.metricsComponent = metricsService.registerComponent(primitiveName);
        this.metricsFeature = this.metricsComponent.registerFeature(objName);
        this.rateMeter = metricsService.createMeter(this.metricsComponent, this.metricsFeature, RATE_NAME);
        this.countMeter = metricsService.createMeter(this.metricsComponent, this.metricsFeature, COUNT_NAME);
    }

    public ControlMetricType getMetricsType() {
        return this.metricsType;
    }

    public void increment(long n) {
        this.rateMeter.mark(n);
        this.countMeter.mark(1L);
    }

    public long getLoad() {
        return (long)this.rateMeter.getOneMinuteRate() / (long)this.countMeter.getOneMinuteRate();
    }

    public long getRate() {
        return (long)this.rateMeter.getOneMinuteRate();
    }

    public long getCount() {
        return (long)this.countMeter.getOneMinuteRate() * 60L;
    }
}

