/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cpman.rest;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.onlab.util.Tools;
import org.onosproject.cpman.ControlMetric;
import org.onosproject.cpman.ControlMetricType;
import org.onosproject.cpman.ControlPlaneMonitorService;
import org.onosproject.cpman.MetricValue;
import org.onosproject.cpman.SystemInfo;
import org.onosproject.cpman.impl.DefaultSystemInfo;
import org.onosproject.cpman.impl.SystemInfoFactory;
import org.onosproject.rest.AbstractWebResource;

/*
 * Exception performing whole class analysis ignored.
 */
@Path(value="collector")
public class ControlMetricsCollectorWebResource
extends AbstractWebResource {
    final ControlPlaneMonitorService service = (ControlPlaneMonitorService)this.get(ControlPlaneMonitorService.class);
    public static final int UPDATE_INTERVAL_IN_MINUTE = 1;
    public static final String INVALID_SYSTEM_SPECS = "Invalid system specifications";
    public static final String INVALID_RESOURCE_NAME = "Invalid resource name";
    public static final String INVALID_REQUEST = "Invalid request";

    @POST
    @Path(value="cpu_metrics")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response cpuMetrics(InputStream stream) {
        ObjectNode root = this.mapper().createObjectNode();
        try {
            ObjectNode jsonTree = (ObjectNode)this.mapper().readTree(stream);
            long cpuLoad = (Long)Tools.nullIsIllegal((Object)jsonTree.get("cpuLoad").asLong(), (String)"Invalid request");
            long totalCpuTime = (Long)Tools.nullIsIllegal((Object)jsonTree.get("totalCpuTime").asLong(), (String)"Invalid request");
            long sysCpuTime = (Long)Tools.nullIsIllegal((Object)jsonTree.get("sysCpuTime").asLong(), (String)"Invalid request");
            long userCpuTime = (Long)Tools.nullIsIllegal((Object)jsonTree.get("userCpuTime").asLong(), (String)"Invalid request");
            long cpuIdleTime = (Long)Tools.nullIsIllegal((Object)jsonTree.get("cpuIdleTime").asLong(), (String)"Invalid request");
            ControlMetric cm = new ControlMetric(ControlMetricType.CPU_LOAD, new MetricValue.Builder().load(cpuLoad).add());
            this.service.updateMetric(cm, 1, Optional.ofNullable(null));
            cm = new ControlMetric(ControlMetricType.TOTAL_CPU_TIME, new MetricValue.Builder().load(totalCpuTime).add());
            this.service.updateMetric(cm, 1, Optional.ofNullable(null));
            cm = new ControlMetric(ControlMetricType.SYS_CPU_TIME, new MetricValue.Builder().load(sysCpuTime).add());
            this.service.updateMetric(cm, 1, Optional.ofNullable(null));
            cm = new ControlMetric(ControlMetricType.USER_CPU_TIME, new MetricValue.Builder().load(userCpuTime).add());
            this.service.updateMetric(cm, 1, Optional.ofNullable(null));
            cm = new ControlMetric(ControlMetricType.CPU_IDLE_TIME, new MetricValue.Builder().load(cpuIdleTime).add());
            this.service.updateMetric(cm, 1, Optional.ofNullable(null));
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        return ControlMetricsCollectorWebResource.ok((Object)root).build();
    }

    @POST
    @Path(value="memory_metrics")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response memoryMetrics(InputStream stream) {
        ObjectNode root = this.mapper().createObjectNode();
        try {
            ObjectNode jsonTree = (ObjectNode)this.mapper().readTree(stream);
            long memUsedRatio = (Long)Tools.nullIsIllegal((Object)jsonTree.get("memoryUsedRatio").asLong(), (String)"Invalid request");
            long memFreeRatio = (Long)Tools.nullIsIllegal((Object)jsonTree.get("memoryFreeRatio").asLong(), (String)"Invalid request");
            long memUsed = (Long)Tools.nullIsIllegal((Object)jsonTree.get("memoryUsed").asLong(), (String)"Invalid request");
            long memFree = (Long)Tools.nullIsIllegal((Object)jsonTree.get("memoryFree").asLong(), (String)"Invalid request");
            ControlMetric cm = new ControlMetric(ControlMetricType.MEMORY_USED_RATIO, new MetricValue.Builder().load(memUsedRatio).add());
            this.service.updateMetric(cm, 1, Optional.ofNullable(null));
            cm = new ControlMetric(ControlMetricType.MEMORY_FREE_RATIO, new MetricValue.Builder().load(memFreeRatio).add());
            this.service.updateMetric(cm, 1, Optional.ofNullable(null));
            cm = new ControlMetric(ControlMetricType.MEMORY_USED, new MetricValue.Builder().load(memUsed).add());
            this.service.updateMetric(cm, 1, Optional.ofNullable(null));
            cm = new ControlMetric(ControlMetricType.MEMORY_FREE, new MetricValue.Builder().load(memFree).add());
            this.service.updateMetric(cm, 1, Optional.ofNullable(null));
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        return ControlMetricsCollectorWebResource.ok((Object)root).build();
    }

    @POST
    @Path(value="disk_metrics")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response diskMetrics(InputStream stream) {
        ObjectNode root = this.mapper().createObjectNode();
        try {
            ObjectNode jsonTree = (ObjectNode)this.mapper().readTree(stream);
            ArrayNode diskRes = (ArrayNode)jsonTree.get("disks");
            for (JsonNode node : diskRes) {
                JsonNode resourceName = node.get("resourceName");
                Tools.nullIsIllegal((Object)resourceName, (String)"Invalid resource name");
                long readBytes = (Long)Tools.nullIsIllegal((Object)node.get("readBytes").asLong(), (String)"Invalid request");
                long writeBytes = (Long)Tools.nullIsIllegal((Object)node.get("writeBytes").asLong(), (String)"Invalid request");
                ControlMetric cm = new ControlMetric(ControlMetricType.DISK_READ_BYTES, new MetricValue.Builder().load(readBytes).add());
                this.service.updateMetric(cm, 1, resourceName.asText());
                cm = new ControlMetric(ControlMetricType.DISK_WRITE_BYTES, new MetricValue.Builder().load(writeBytes).add());
                this.service.updateMetric(cm, 1, resourceName.asText());
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        return ControlMetricsCollectorWebResource.ok((Object)root).build();
    }

    @POST
    @Path(value="network_metrics")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response networkMetrics(InputStream stream) {
        ObjectNode root = this.mapper().createObjectNode();
        try {
            ObjectNode jsonTree = (ObjectNode)this.mapper().readTree(stream);
            ArrayNode networkRes = (ArrayNode)jsonTree.get("networks");
            for (JsonNode node : networkRes) {
                JsonNode resourceName = node.get("resourceName");
                Tools.nullIsIllegal((Object)resourceName, (String)"Invalid resource name");
                long inBytes = (Long)Tools.nullIsIllegal((Object)node.get("incomingBytes").asLong(), (String)"Invalid request");
                long outBytes = (Long)Tools.nullIsIllegal((Object)node.get("outgoingBytes").asLong(), (String)"Invalid request");
                long inPackets = (Long)Tools.nullIsIllegal((Object)node.get("incomingPackets").asLong(), (String)"Invalid request");
                long outPackets = (Long)Tools.nullIsIllegal((Object)node.get("outgoingPackets").asLong(), (String)"Invalid request");
                ControlMetric cm = new ControlMetric(ControlMetricType.NW_INCOMING_BYTES, new MetricValue.Builder().load(inBytes).add());
                this.service.updateMetric(cm, 1, resourceName.asText());
                cm = new ControlMetric(ControlMetricType.NW_OUTGOING_BYTES, new MetricValue.Builder().load(outBytes).add());
                this.service.updateMetric(cm, 1, resourceName.asText());
                cm = new ControlMetric(ControlMetricType.NW_INCOMING_PACKETS, new MetricValue.Builder().load(inPackets).add());
                this.service.updateMetric(cm, 1, resourceName.asText());
                cm = new ControlMetric(ControlMetricType.NW_OUTGOING_PACKETS, new MetricValue.Builder().load(outPackets).add());
                this.service.updateMetric(cm, 1, resourceName.asText());
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        return ControlMetricsCollectorWebResource.ok((Object)root).build();
    }

    @POST
    @Path(value="system_info")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response systemInfo(InputStream stream) {
        ObjectNode root = this.mapper().createObjectNode();
        try {
            ObjectNode jsonTree = (ObjectNode)this.mapper().readTree(stream);
            JsonNode numOfCores = jsonTree.get("numOfCores");
            JsonNode numOfCpus = jsonTree.get("numOfCpus");
            JsonNode cpuSpeed = jsonTree.get("cpuSpeed");
            JsonNode totalMemory = jsonTree.get("totalMemory");
            if (numOfCores == null || numOfCpus == null || cpuSpeed == null || totalMemory == null) {
                throw new IllegalArgumentException("Invalid system specifications");
            }
            SystemInfo systemInfo = new DefaultSystemInfo.Builder().numOfCores(numOfCores.asInt()).numOfCpus(numOfCpus.asInt()).cpuSpeed(cpuSpeed.asInt()).totalMemory(totalMemory.asInt()).build();
            SystemInfoFactory.getInstance().setSystemInfo(systemInfo);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        return ControlMetricsCollectorWebResource.ok((Object)root).build();
    }
}

