/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cpman.impl;

import com.google.common.collect.ImmutableSet;
import java.util.Optional;
import org.easymock.EasyMock;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.onlab.packet.IpAddress;
import org.onosproject.cluster.ClusterService;
import org.onosproject.cluster.ControllerNode;
import org.onosproject.cluster.NodeId;
import org.onosproject.cpman.ControlMetric;
import org.onosproject.cpman.ControlMetricType;
import org.onosproject.cpman.ControlResource;
import org.onosproject.cpman.MetricValue;
import org.onosproject.cpman.impl.ControlPlaneMonitor;
import org.onosproject.net.DeviceId;

public class ControlPlaneMonitorTest {
    private ControlPlaneMonitor monitor;
    private static final Integer UPDATE_INTERVAL = 1;
    private ClusterService mockClusterService;
    private ControllerNode mockControllerNode;
    private NodeId nodeId;

    @Before
    public void setup() {
        this.monitor = new ControlPlaneMonitor();
        this.monitor.activate();
        this.nodeId = new NodeId("1");
        this.mockControllerNode = new MockControllerNode(this.nodeId);
        this.monitor.clusterService = this.mockClusterService = (ClusterService)EasyMock.createMock(ClusterService.class);
        EasyMock.expect((Object)this.mockClusterService.getNode((NodeId)EasyMock.anyObject())).andReturn((Object)this.mockControllerNode).anyTimes();
        EasyMock.expect((Object)this.mockClusterService.getLocalNode()).andReturn((Object)this.mockControllerNode).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.mockClusterService});
    }

    private void testUpdateMetricWithoutId(ControlMetricType cmt, MetricValue mv) {
        ControlMetric cm = new ControlMetric(cmt, mv);
        this.monitor.updateMetric(cm, UPDATE_INTERVAL.intValue(), Optional.ofNullable(null));
    }

    private void testLoadMetricWithoutId(ControlMetricType cmt, MetricValue mv) {
        Assert.assertThat((Object)this.monitor.getLoad(this.nodeId, cmt, Optional.ofNullable(null)).latest(), (Matcher)Matchers.is((Object)mv.getLoad()));
    }

    private void testUpdateMetricWithResource(ControlMetricType cmt, MetricValue mv, String resourceName) {
        ControlMetric cm = new ControlMetric(cmt, mv);
        this.monitor.updateMetric(cm, UPDATE_INTERVAL.intValue(), resourceName);
    }

    private void testLoadMetricWithResource(ControlMetricType cmt, MetricValue mv, String resourceName) {
        Assert.assertThat((Object)this.monitor.getLoad(this.nodeId, cmt, resourceName).latest(), (Matcher)Matchers.is((Object)mv.getLoad()));
    }

    private void testUpdateMetricWithId(ControlMetricType cmt, MetricValue mv, DeviceId did) {
        ControlMetric cm = new ControlMetric(cmt, mv);
        this.monitor.updateMetric(cm, UPDATE_INTERVAL.intValue(), Optional.of(did));
    }

    private void testLoadMetricWithId(ControlMetricType cmt, MetricValue mv, DeviceId did) {
        Assert.assertThat((Object)this.monitor.getLoad(this.nodeId, cmt, Optional.of(did)).latest(), (Matcher)Matchers.is((Object)mv.getLoad()));
    }

    @Test
    public void testCpuMetric() {
        MetricValue mv = new MetricValue.Builder().load(30L).add();
        ControlResource.CPU_METRICS.forEach(cmt -> this.testUpdateMetricWithoutId((ControlMetricType)cmt, mv));
        ControlResource.CPU_METRICS.forEach(cmt -> this.testLoadMetricWithoutId((ControlMetricType)cmt, mv));
    }

    @Test
    public void testMemoryMetric() {
        MetricValue mv = new MetricValue.Builder().load(40L).add();
        ControlResource.MEMORY_METRICS.forEach(cmt -> this.testUpdateMetricWithoutId((ControlMetricType)cmt, mv));
        ControlResource.MEMORY_METRICS.forEach(cmt -> this.testLoadMetricWithoutId((ControlMetricType)cmt, mv));
    }

    @Test
    public void testDiskMetric() {
        MetricValue mv = new MetricValue.Builder().load(50L).add();
        ImmutableSet set = ImmutableSet.of((Object)"disk1", (Object)"disk2");
        set.forEach(disk -> ControlResource.DISK_METRICS.forEach(cmt -> this.testUpdateMetricWithResource((ControlMetricType)cmt, mv, (String)disk)));
        set.forEach(disk -> ControlResource.DISK_METRICS.forEach(cmt -> this.testLoadMetricWithResource((ControlMetricType)cmt, mv, (String)disk)));
    }

    @Test
    public void testNetworkMetric() {
        MetricValue mv = new MetricValue.Builder().load(10L).add();
        ImmutableSet set = ImmutableSet.of((Object)"eth0", (Object)"eth1");
        set.forEach(network -> ControlResource.NETWORK_METRICS.forEach(cmt -> this.testUpdateMetricWithResource((ControlMetricType)cmt, mv, (String)network)));
        set.forEach(network -> ControlResource.NETWORK_METRICS.forEach(cmt -> this.testLoadMetricWithResource((ControlMetricType)cmt, mv, (String)network)));
    }

    @Test
    public void testControlMessage() {
        MetricValue mv = new MetricValue.Builder().load(10L).add();
        ImmutableSet set = ImmutableSet.of((Object)DeviceId.deviceId((String)"of:0000000000000001"), (Object)DeviceId.deviceId((String)"of:0000000000000002"));
        set.forEach(devId -> ControlResource.CONTROL_MESSAGE_METRICS.forEach(cmt -> this.testUpdateMetricWithId((ControlMetricType)cmt, mv, (DeviceId)devId)));
        set.forEach(devId -> ControlResource.CONTROL_MESSAGE_METRICS.forEach(cmt -> this.testLoadMetricWithId((ControlMetricType)cmt, mv, (DeviceId)devId)));
    }

    @Test
    public void testAvailableResources() {
        MetricValue mv = new MetricValue.Builder().load(50L).add();
        ImmutableSet diskSet = ImmutableSet.of((Object)"disk1", (Object)"disk2");
        diskSet.forEach(disk -> ControlResource.DISK_METRICS.forEach(cmt -> this.testUpdateMetricWithResource((ControlMetricType)cmt, mv, (String)disk)));
        ImmutableSet networkSet = ImmutableSet.of((Object)"eth0", (Object)"eth1");
        networkSet.forEach(network -> ControlResource.NETWORK_METRICS.forEach(cmt -> this.testUpdateMetricWithResource((ControlMetricType)cmt, mv, (String)network)));
        Assert.assertThat((Object)this.monitor.availableResources(ControlResource.Type.DISK), (Matcher)Matchers.is((Object)diskSet));
        Assert.assertThat((Object)this.monitor.availableResources(ControlResource.Type.NETWORK), (Matcher)Matchers.is((Object)networkSet));
    }

    private static class MockControllerNode
    implements ControllerNode {
        final NodeId id;

        public MockControllerNode(NodeId id) {
            this.id = id;
        }

        public NodeId id() {
            return this.id;
        }

        public IpAddress ip() {
            return null;
        }

        public int tcpPort() {
            return 0;
        }
    }
}

