/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cpman.impl;

import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.onosproject.cpman.MetricsDatabase;
import org.onosproject.cpman.impl.DefaultMetricsDatabase;

public class MetricsDatabaseTest {
    private MetricsDatabase mdb;
    private static final String CPU_METRIC = "cpu";
    private static final String CPU_LOAD = "load";
    private static final String MEMORY_METRIC = "memory";
    private static final String MEMORY_FREE_PERC = "freePerc";
    private static final String MEMORY_USED_PERC = "usedPerc";

    @Before
    public void setUp() {
        this.mdb = new DefaultMetricsDatabase.Builder().withMetricName(CPU_METRIC).addMetricType(CPU_LOAD).build();
    }

    @Test
    public void testMetricUpdate() {
        long currentTime = System.currentTimeMillis() / 1000L;
        this.mdb.updateMetric(CPU_LOAD, 30.0, currentTime);
        Assert.assertThat((Object)30.0, (Matcher)Matchers.is((Object)this.mdb.recentMetric(CPU_LOAD)));
        this.mdb.updateMetric(CPU_LOAD, 40.0, currentTime + 60L);
        Assert.assertThat((Object)40.0, (Matcher)Matchers.is((Object)this.mdb.recentMetric(CPU_LOAD)));
        this.mdb.updateMetric(CPU_LOAD, 50.0, currentTime + 120L);
        Assert.assertThat((Object)50.0, (Matcher)Matchers.is((Object)this.mdb.recentMetric(CPU_LOAD)));
    }

    @Test
    public void testMetricRangeFetch() {
        Assert.assertThat((Object)this.mdb.metrics(CPU_LOAD).length, (Matcher)Matchers.is((Object)1440));
        Assert.assertThat((Object)this.mdb.recentMetrics(CPU_LOAD, 1, TimeUnit.MINUTES).length, (Matcher)Matchers.is((Object)1));
        Assert.assertThat((Object)this.mdb.recentMetrics(CPU_LOAD, 1, TimeUnit.HOURS).length, (Matcher)Matchers.is((Object)60));
        Assert.assertThat((Object)this.mdb.recentMetrics(CPU_LOAD, 1, TimeUnit.DAYS).length, (Matcher)Matchers.is((Object)1440));
        long endTime = System.currentTimeMillis() / 1000L;
        long startTime = endTime - 300L;
        Assert.assertThat((Object)this.mdb.metrics(CPU_LOAD, startTime, endTime).length, (Matcher)Matchers.is((Object)5));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testExceededTimeRange() {
        Assert.assertThat((Object)this.mdb.recentMetrics(CPU_LOAD, 25, TimeUnit.HOURS).length, (Matcher)Matchers.is((Object)1440));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInsufficientTimeRange() {
        Assert.assertThat((Object)this.mdb.recentMetrics(CPU_LOAD, 50, TimeUnit.SECONDS).length, (Matcher)Matchers.is((Object)1));
    }

    @Test
    public void testMultipleMetrics() {
        MetricsDatabase multiMdb = new DefaultMetricsDatabase.Builder().withMetricName(MEMORY_METRIC).addMetricType(MEMORY_FREE_PERC).addMetricType(MEMORY_USED_PERC).build();
        HashMap<String, Double> metrics = new HashMap<String, Double>();
        metrics.putIfAbsent(MEMORY_FREE_PERC, 30.0);
        metrics.putIfAbsent(MEMORY_USED_PERC, 70.0);
        multiMdb.updateMetrics(metrics);
        Assert.assertThat((Object)30.0, (Matcher)Matchers.is((Object)multiMdb.recentMetric(MEMORY_FREE_PERC)));
        Assert.assertThat((Object)70.0, (Matcher)Matchers.is((Object)multiMdb.recentMetric(MEMORY_USED_PERC)));
    }
}

