/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cpman.impl.message;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.onosproject.cpman.ControlMessage;
import org.onosproject.cpman.DefaultControlMessage;
import org.onosproject.cpman.impl.message.ControlMessageManager;
import org.onosproject.cpman.impl.message.DefaultControlMessageStore;
import org.onosproject.cpman.message.ControlMessageEvent;
import org.onosproject.cpman.message.ControlMessageListener;
import org.onosproject.cpman.message.ControlMessageProvider;
import org.onosproject.cpman.message.ControlMessageProviderRegistry;
import org.onosproject.cpman.message.ControlMessageProviderService;
import org.onosproject.cpman.message.ControlMessageService;
import org.onosproject.event.DefaultEventSinkRegistry;
import org.onosproject.event.Event;
import org.onosproject.event.EventDeliveryService;
import org.onosproject.event.EventListener;
import org.onosproject.event.EventSink;
import org.onosproject.net.DeviceId;
import org.onosproject.net.NetTestTools;
import org.onosproject.net.provider.AbstractProvider;
import org.onosproject.net.provider.Provider;
import org.onosproject.net.provider.ProviderId;

public class ControlMessageManagerTest {
    private static final ProviderId PID = new ProviderId("of", "foo");
    private static final DeviceId DID = DeviceId.deviceId((String)"of:foo");
    private ControlMessageManager manager;
    private ControlMessageService service;
    private ControlMessageProviderRegistry registry;
    private ControlMessageProviderService providerService;
    protected TestProvider provider;
    protected TestListener listener = new TestListener();

    @Before
    public void setUp() {
        this.manager = new ControlMessageManager();
        this.service = this.manager;
        this.registry = this.manager;
        this.manager.store = new DefaultControlMessageStore();
        NetTestTools.injectEventDispatcher((Object)this.manager, (EventDeliveryService)new TestEventDispatcher());
        this.manager.activate();
        this.service.addListener((EventListener)this.listener);
        this.provider = new TestProvider();
        this.providerService = (ControlMessageProviderService)this.registry.register((Provider)this.provider);
        Assert.assertTrue((String)"provider should be registered", (boolean)this.registry.getProviders().contains(this.provider.id()));
    }

    @After
    public void tearDown() {
        this.registry.unregister((Provider)this.provider);
        Assert.assertFalse((String)"provider should not be registered", (boolean)this.registry.getProviders().contains(this.provider.id()));
        this.service.removeListener((EventListener)this.listener);
        this.manager.deactivate();
    }

    @Test
    public void updateStatsInfo() {
        HashSet cms = Sets.newHashSet();
        ControlMessage.Type in = ControlMessage.Type.INBOUND_PACKET;
        ControlMessage.Type out = ControlMessage.Type.OUTBOUND_PACKET;
        ControlMessage.Type mod = ControlMessage.Type.FLOW_MOD_PACKET;
        ControlMessage.Type rmv = ControlMessage.Type.FLOW_REMOVED_PACKET;
        ControlMessage.Type req = ControlMessage.Type.REQUEST_PACKET;
        ControlMessage.Type rep = ControlMessage.Type.REPLY_PACKET;
        cms.add(new DefaultControlMessage(in, DID, 0L, 0L, 0L, 0L));
        cms.add(new DefaultControlMessage(out, DID, 0L, 0L, 0L, 0L));
        cms.add(new DefaultControlMessage(mod, DID, 0L, 0L, 0L, 0L));
        cms.add(new DefaultControlMessage(rmv, DID, 0L, 0L, 0L, 0L));
        cms.add(new DefaultControlMessage(req, DID, 0L, 0L, 0L, 0L));
        cms.add(new DefaultControlMessage(rep, DID, 0L, 0L, 0L, 0L));
        this.providerService.updateStatsInfo(DID, (Set)cms);
        this.validateEvents(new Enum[]{ControlMessageEvent.Type.STATS_UPDATE});
        cms.clear();
    }

    protected void validateEvents(Enum ... types) {
        int i = 0;
        Assert.assertEquals((String)"wrong events received", (long)types.length, (long)this.listener.events.size());
        for (Event event : this.listener.events) {
            Assert.assertEquals((String)"incorrect event type", (Object)types[i], (Object)event.type());
            ++i;
        }
        this.listener.events.clear();
    }

    private class TestEventDispatcher
    extends DefaultEventSinkRegistry
    implements EventDeliveryService {
        private TestEventDispatcher() {
        }

        public synchronized void post(Event event) {
            EventSink sink = this.getSink(event.getClass());
            Preconditions.checkState((sink != null ? 1 : 0) != 0, (String)"No sink for event %s", (Object[])new Object[]{event});
            sink.process(event);
        }

        public void setDispatchTimeLimit(long millis) {
        }

        public long getDispatchTimeLimit() {
            return 0L;
        }
    }

    private static class TestListener
    implements ControlMessageListener {
        final List<ControlMessageEvent> events = new ArrayList<ControlMessageEvent>();

        private TestListener() {
        }

        public void event(ControlMessageEvent event) {
            this.events.add(event);
        }
    }

    private class TestProvider
    extends AbstractProvider
    implements ControlMessageProvider {
        public TestProvider() {
            super(PID);
        }
    }
}

