/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cpman.rest;

import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.spi.container.servlet.ServletContainer;
import com.sun.jersey.test.framework.AppDescriptor;
import com.sun.jersey.test.framework.JerseyTest;
import com.sun.jersey.test.framework.WebAppDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.net.ServerSocket;
import java.util.Optional;
import javax.ws.rs.core.MediaType;
import org.easymock.EasyMock;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.onlab.osgi.ServiceDirectory;
import org.onlab.osgi.TestServiceDirectory;
import org.onlab.rest.BaseResource;
import org.onosproject.cpman.ControlMetric;
import org.onosproject.cpman.ControlPlaneMonitorService;
import org.onosproject.cpman.SystemInfo;
import org.onosproject.cpman.impl.SystemInfoFactory;
import org.onosproject.cpman.rest.CPManWebApplication;

public class ControlMetricsCollectorResourceTest
extends JerseyTest {
    final ControlPlaneMonitorService mockControlPlaneMonitorService = (ControlPlaneMonitorService)EasyMock.createMock(ControlPlaneMonitorService.class);
    private static final String PREFIX = "collector";

    public ControlMetricsCollectorResourceTest() {
        super((AppDescriptor)new WebAppDescriptor.Builder("javax.ws.rs.Application", CPManWebApplication.class.getCanonicalName()).servletClass(ServletContainer.class).build());
    }

    @Before
    public void setUpTest() {
        TestServiceDirectory testDirectory = new TestServiceDirectory().add(ControlPlaneMonitorService.class, (Object)this.mockControlPlaneMonitorService);
        BaseResource.setServiceDirectory((ServiceDirectory)testDirectory);
    }

    @Test
    public void testCpuMetricsPost() {
        this.mockControlPlaneMonitorService.updateMetric((ControlMetric)EasyMock.anyObject(), EasyMock.anyInt(), (Optional)EasyMock.anyObject());
        EasyMock.expectLastCall().times(5);
        EasyMock.replay((Object[])new Object[]{this.mockControlPlaneMonitorService});
        this.basePostTest("cpu-metrics-post.json", "collector/cpu_metrics");
    }

    @Test
    public void testMemoryMetricsPost() {
        this.mockControlPlaneMonitorService.updateMetric((ControlMetric)EasyMock.anyObject(), EasyMock.anyInt(), (Optional)EasyMock.anyObject());
        EasyMock.expectLastCall().times(4);
        EasyMock.replay((Object[])new Object[]{this.mockControlPlaneMonitorService});
        this.basePostTest("memory-metrics-post.json", "collector/memory_metrics");
    }

    @Test
    public void testDiskMetrics() {
        this.mockControlPlaneMonitorService.updateMetric((ControlMetric)EasyMock.anyObject(), EasyMock.anyInt(), EasyMock.anyString());
        EasyMock.expectLastCall().times(4);
        EasyMock.replay((Object[])new Object[]{this.mockControlPlaneMonitorService});
        this.basePostTest("disk-metrics-post.json", "collector/disk_metrics");
    }

    @Test
    public void testNetworkMetrics() {
        this.mockControlPlaneMonitorService.updateMetric((ControlMetric)EasyMock.anyObject(), EasyMock.anyInt(), EasyMock.anyString());
        EasyMock.expectLastCall().times(8);
        EasyMock.replay((Object[])new Object[]{this.mockControlPlaneMonitorService});
        this.basePostTest("network-metrics-post.json", "collector/network_metrics");
    }

    @Test
    public void testSystemInfoPost() {
        this.basePostTest("system-info-post.json", "collector/system_info");
        SystemInfo si = SystemInfoFactory.getInstance().getSystemInfo();
        Assert.assertThat((Object)si.cpuSpeed(), (Matcher)Matchers.is((Object)2048));
        Assert.assertThat((Object)si.coreCount(), (Matcher)Matchers.is((Object)6));
        Assert.assertThat((Object)si.cpuCount(), (Matcher)Matchers.is((Object)2));
        Assert.assertThat((Object)si.totalMemory(), (Matcher)Matchers.is((Object)4096));
    }

    private ClientResponse baseTest(String jsonFile, String path) {
        WebResource rs = this.resource();
        InputStream jsonStream = ControlMetricsCollectorResourceTest.class.getResourceAsStream(jsonFile);
        Assert.assertThat((Object)jsonStream, (Matcher)Matchers.notNullValue());
        return (ClientResponse)rs.path(path).type(MediaType.APPLICATION_JSON_TYPE).post(ClientResponse.class, (Object)jsonStream);
    }

    private void basePostTest(String jsonFile, String path) {
        ClientResponse response = this.baseTest(jsonFile, path);
        Assert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)200));
    }

    public int getPort(int defaultPort) {
        try {
            ServerSocket socket = new ServerSocket(0);
            socket.setReuseAddress(true);
            int port = socket.getLocalPort();
            socket.close();
            return port;
        }
        catch (IOException ioe) {
            return defaultPort;
        }
    }

    public AppDescriptor configure() {
        return new WebAppDescriptor.Builder(new String[]{"org.onosproject.cpman.rest"}).build();
    }
}

