/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.dhcp.impl;

import com.google.common.collect.ImmutableSet;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.onlab.packet.DHCP;
import org.onlab.packet.DHCPOption;
import org.onlab.packet.DHCPPacketType;
import org.onlab.packet.Ethernet;
import org.onlab.packet.IPacket;
import org.onlab.packet.IPv4;
import org.onlab.packet.Ip4Address;
import org.onlab.packet.IpAddress;
import org.onlab.packet.MacAddress;
import org.onlab.packet.UDP;
import org.onosproject.core.CoreServiceAdapter;
import org.onosproject.dhcp.DhcpStore;
import org.onosproject.dhcp.IpAssignment;
import org.onosproject.dhcp.impl.DhcpManager;
import org.onosproject.net.Host;
import org.onosproject.net.HostId;
import org.onosproject.net.NetTestTools;
import org.onosproject.net.config.NetworkConfigRegistryAdapter;
import org.onosproject.net.host.HostDescription;
import org.onosproject.net.host.HostProvider;
import org.onosproject.net.host.HostProviderRegistry;
import org.onosproject.net.host.HostProviderService;
import org.onosproject.net.packet.DefaultInboundPacket;
import org.onosproject.net.packet.DefaultPacketContext;
import org.onosproject.net.packet.InboundPacket;
import org.onosproject.net.packet.OutboundPacket;
import org.onosproject.net.packet.PacketContext;
import org.onosproject.net.packet.PacketProcessor;
import org.onosproject.net.packet.PacketServiceAdapter;
import org.onosproject.net.provider.AbstractProvider;
import org.onosproject.net.provider.AbstractProviderService;
import org.onosproject.net.provider.Provider;
import org.onosproject.net.provider.ProviderId;

public class DhcpManagerTest {
    private DhcpManager dhcpXManager;
    protected PacketProcessor packetProcessor;
    protected HostProviderService hostProviderService;
    private static final HostId CLIENT1_HOST = HostId.hostId((MacAddress)MacAddress.valueOf((String)"1a:1a:1a:1a:1a:1a"));
    private static final String EXPECTED_IP = "10.2.0.2";
    private static final Ip4Address BROADCAST = Ip4Address.valueOf((String)"255.255.255.255");
    private static final int TRANSACTION_ID = 1000;
    private static final ProviderId PID = new ProviderId("of", "foo");

    @Before
    public void setUp() {
        this.dhcpXManager = new DhcpManager();
        this.dhcpXManager.cfgService = new TestNetworkConfigRegistry();
        this.dhcpXManager.packetService = new TestPacketService();
        this.dhcpXManager.coreService = new TestCoreService();
        this.dhcpXManager.dhcpStore = new TestDhcpStore();
        this.dhcpXManager.hostProviderService = this.hostProviderService = new TestHostProviderService(new TestHostProvider());
        this.dhcpXManager.hostProviderRegistry = new TestHostRegistry();
        this.dhcpXManager.activate();
    }

    @After
    public void tearDown() {
        this.dhcpXManager.deactivate();
    }

    @Test
    public void testDiscover() {
        Ethernet reply = this.constructDhcpPacket(DHCPPacketType.DHCPDISCOVER);
        this.sendPacket(reply);
    }

    @Test
    public void testRequest() {
        Ethernet reply = this.constructDhcpPacket(DHCPPacketType.DHCPREQUEST);
        this.sendPacket(reply);
    }

    private void sendPacket(Ethernet reply) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(reply.serialize());
        DefaultInboundPacket inPacket = new DefaultInboundPacket(NetTestTools.connectPoint((String)"1", (int)1), reply, byteBuffer);
        TestPacketContext context = new TestPacketContext(127L, (InboundPacket)inPacket, null, false);
        this.packetProcessor.process((PacketContext)context);
    }

    private Ethernet constructDhcpPacket(DHCPPacketType packetType) {
        Ethernet ethReply = new Ethernet();
        ethReply.setSourceMACAddress(CLIENT1_HOST.mac());
        ethReply.setDestinationMACAddress(MacAddress.BROADCAST);
        ethReply.setEtherType(Ethernet.TYPE_IPV4);
        ethReply.setVlanID((short)2);
        IPv4 ipv4Reply = new IPv4();
        ipv4Reply.setSourceAddress(0);
        ipv4Reply.setDestinationAddress(BROADCAST.toInt());
        ipv4Reply.setTtl((byte)127);
        UDP udpReply = new UDP();
        udpReply.setSourcePort(68);
        udpReply.setDestinationPort(67);
        DHCP dhcpReply = new DHCP();
        dhcpReply.setOpCode((byte)1);
        dhcpReply.setYourIPAddress(0);
        dhcpReply.setServerIPAddress(0);
        dhcpReply.setTransactionId(1000);
        dhcpReply.setClientHardwareAddress(CLIENT1_HOST.mac().toBytes());
        dhcpReply.setHardwareType((byte)1);
        dhcpReply.setHardwareAddressLength((byte)6);
        DHCPOption option = new DHCPOption();
        ArrayList<DHCPOption> optionList = new ArrayList<DHCPOption>();
        option.setCode(DHCP.DHCPOptionCode.OptionCode_MessageType.getValue());
        option.setLength((byte)1);
        byte[] optionData = new byte[]{(byte)packetType.getValue()};
        option.setData(optionData);
        optionList.add(option);
        option = new DHCPOption();
        option.setCode(DHCP.DHCPOptionCode.OptionCode_RequestedIP.getValue());
        option.setLength((byte)4);
        optionData = Ip4Address.valueOf((String)EXPECTED_IP).toOctets();
        option.setData(optionData);
        optionList.add(option);
        option = new DHCPOption();
        option.setCode(DHCP.DHCPOptionCode.OptionCode_END.getValue());
        option.setLength((byte)1);
        optionList.add(option);
        dhcpReply.setOptions(optionList);
        udpReply.setPayload((IPacket)dhcpReply);
        ipv4Reply.setPayload((IPacket)udpReply);
        ethReply.setPayload((IPacket)ipv4Reply);
        return ethReply;
    }

    private void validatePacket(Ethernet packet) {
        DHCP dhcpPacket = (DHCP)packet.getPayload().getPayload().getPayload();
        Assert.assertEquals((Object)MacAddress.valueOf((byte[])dhcpPacket.getClientHardwareAddress()), (Object)CLIENT1_HOST.mac());
        Assert.assertEquals((Object)Ip4Address.valueOf((int)dhcpPacket.getYourIPAddress()), (Object)Ip4Address.valueOf((String)EXPECTED_IP));
        Assert.assertEquals((long)dhcpPacket.getTransactionId(), (long)1000L);
    }

    private class TestHostRegistry
    implements HostProviderRegistry {
        private TestHostRegistry() {
        }

        public HostProviderService register(HostProvider provider) {
            return DhcpManagerTest.this.hostProviderService;
        }

        public void unregister(HostProvider provider) {
        }

        public Set<ProviderId> getProviders() {
            return null;
        }
    }

    private static class TestHostProvider
    extends AbstractProvider
    implements HostProvider {
        protected TestHostProvider() {
            super(PID);
        }

        public ProviderId id() {
            return PID;
        }

        public void triggerProbe(Host host) {
        }
    }

    private class TestHostProviderService
    extends AbstractProviderService<HostProvider>
    implements HostProviderService {
        protected TestHostProviderService(HostProvider provider) {
            super((Provider)provider);
        }

        public void hostDetected(HostId hostId, HostDescription hostDescription, boolean replaceIps) {
        }

        public void hostVanished(HostId hostId) {
        }

        public void removeIpFromHost(HostId hostId, IpAddress ipAddress) {
        }
    }

    private class TestNetworkConfigRegistry
    extends NetworkConfigRegistryAdapter {
        private TestNetworkConfigRegistry() {
        }
    }

    private class TestCoreService
    extends CoreServiceAdapter {
        private TestCoreService() {
        }
    }

    private class TestPacketService
    extends PacketServiceAdapter {
        private TestPacketService() {
        }

        public void addProcessor(PacketProcessor processor, int priority) {
            DhcpManagerTest.this.packetProcessor = processor;
        }

        public void emit(OutboundPacket packet) {
            try {
                Ethernet eth = (Ethernet)Ethernet.deserializer().deserialize(packet.data().array(), 0, packet.data().array().length);
                DhcpManagerTest.this.validatePacket(eth);
            }
            catch (Exception e) {
                Assert.fail((String)e.getMessage());
            }
        }
    }

    private final class TestPacketContext
    extends DefaultPacketContext {
        private TestPacketContext(long time, InboundPacket inPkt, OutboundPacket outPkt, boolean block) {
            super(time, inPkt, outPkt, block);
        }

        public void send() {
        }
    }

    private final class TestDhcpStore
    implements DhcpStore {
        private TestDhcpStore() {
        }

        public void populateIPPoolfromRange(Ip4Address startIP, Ip4Address endIP) {
        }

        public Ip4Address suggestIP(HostId hostId, Ip4Address requestedIP) {
            return Ip4Address.valueOf((String)DhcpManagerTest.EXPECTED_IP);
        }

        public boolean assignIP(HostId hostId, Ip4Address ipAddr, int leaseTime, boolean fromOpenStack, List<Ip4Address> addressList) {
            return true;
        }

        public void setDefaultTimeoutForPurge(int timeInSeconds) {
        }

        public Ip4Address releaseIP(HostId hostId) {
            return null;
        }

        public Map<HostId, IpAssignment> listAssignedMapping() {
            return this.listAllMapping();
        }

        public Map<HostId, IpAssignment> listAllMapping() {
            HashMap<HostId, IpAssignment> map = new HashMap<HostId, IpAssignment>();
            IpAssignment assignment = IpAssignment.builder().ipAddress(Ip4Address.valueOf((String)DhcpManagerTest.EXPECTED_IP)).assignmentStatus(IpAssignment.AssignmentStatus.Option_Assigned).leasePeriod(300).timestamp(new Date()).build();
            map.put(CLIENT1_HOST, assignment);
            return map;
        }

        public boolean assignStaticIP(MacAddress macID, Ip4Address ipAddr, boolean fromOpenStack, List<Ip4Address> addressList) {
            return true;
        }

        public boolean removeStaticIP(MacAddress macID) {
            return true;
        }

        public Iterable<Ip4Address> getAvailableIPs() {
            ArrayList<Ip4Address> ipList = new ArrayList<Ip4Address>();
            ipList.add(Ip4Address.valueOf((String)DhcpManagerTest.EXPECTED_IP));
            return ImmutableSet.copyOf(ipList);
        }

        public IpAssignment getIpAssignmentFromAllocationMap(HostId hostId) {
            return null;
        }
    }
}

