/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.dhcp.cli;

import java.util.Map;
import org.apache.karaf.shell.commands.Command;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.dhcp.DhcpService;
import org.onosproject.dhcp.IpAssignment;
import org.onosproject.net.HostId;

@Command(scope="onos", name="dhcp-list", description="Lists all the MAC to IP mappings held by the DHCP Server")
public class DhcpListAllMappings
extends AbstractShellCommand {
    private static final String DHCP_MAPPING_FORMAT = "MAC ID: %s -> IP ASSIGNED %s";

    protected void execute() {
        DhcpService dhcpService = (DhcpService)AbstractShellCommand.get(DhcpService.class);
        Map allocationMap = dhcpService.listMapping();
        for (Map.Entry entry : allocationMap.entrySet()) {
            this.print(DHCP_MAPPING_FORMAT, new Object[]{((HostId)entry.getKey()).toString(), ((IpAssignment)entry.getValue()).ipAddress().toString()});
        }
    }
}

