/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.dhcp.cli;

import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.onlab.packet.MacAddress;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.dhcp.DhcpService;

@Command(scope="onos", name="dhcp-remove-static-mapping", description="Removes a static MAC Address to IP Mapping from the DHCP Server")
public class DhcpRemoveStaticMapping
extends AbstractShellCommand {
    @Argument(index=0, name="macAddr", description="MAC Address of the client", required=true, multiValued=false)
    String macAddr = null;
    private static final String DHCP_SUCCESS = "Static Mapping Successfully Removed.";
    private static final String DHCP_FAILURE = "Static Mapping Removal Failed. Either the mapping does not exist or it is not static.";

    protected void execute() {
        DhcpService dhcpService = (DhcpService)AbstractShellCommand.get(DhcpService.class);
        try {
            MacAddress macID = MacAddress.valueOf((String)this.macAddr);
            if (dhcpService.removeStaticMapping(macID)) {
                this.print(DHCP_SUCCESS, new Object[0]);
            } else {
                this.print(DHCP_FAILURE, new Object[0]);
            }
        }
        catch (IllegalArgumentException e) {
            this.print(e.getMessage(), new Object[0]);
        }
    }
}

