/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.dhcp.cli;

import com.google.common.collect.Lists;
import java.util.List;
import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.onlab.packet.Ip4Address;
import org.onlab.packet.MacAddress;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.dhcp.DhcpService;

@Command(scope="onos", name="dhcp-set-static-mapping", description="Registers a static MAC Address to IP Mapping with the DHCP Server")
public class DhcpSetStaticMapping
extends AbstractShellCommand {
    @Argument(index=0, name="macAddr", description="MAC Address of the client", required=true, multiValued=false)
    String macAddr = null;
    @Argument(index=1, name="ipAddr", description="IP Address requested for static mapping", required=true, multiValued=false)
    String ipAddr = null;
    private static final String DHCP_SUCCESS = "Static Mapping Successfully Added.";
    private static final String DHCP_FAILURE = "Static Mapping Failed. The IP maybe unavailable.";

    protected void execute() {
        DhcpService dhcpService = (DhcpService)AbstractShellCommand.get(DhcpService.class);
        try {
            MacAddress macID = MacAddress.valueOf((String)this.macAddr);
            Ip4Address ipAddress = Ip4Address.valueOf((String)this.ipAddr);
            if (dhcpService.setStaticMapping(macID, ipAddress, false, (List)Lists.newArrayList())) {
                this.print(DHCP_SUCCESS, new Object[0]);
            } else {
                this.print(DHCP_FAILURE, new Object[0]);
            }
        }
        catch (IllegalArgumentException e) {
            this.print(e.getMessage(), new Object[0]);
        }
    }
}

