/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.dhcp.impl;

import org.onlab.packet.Ip4Address;
import org.onlab.packet.MacAddress;
import org.onosproject.core.ApplicationId;
import org.onosproject.net.config.Config;
import org.onosproject.net.config.basics.BasicElementConfig;

public class DhcpConfig
extends Config<ApplicationId> {
    public static final String MY_IP = "ip";
    public static final String MY_MAC = "mac";
    public static final String SUBNET_MASK = "subnet";
    public static final String BROADCAST_ADDRESS = "broadcast";
    public static final String ROUTER_ADDRESS = "router";
    public static final String DOMAIN_SERVER = "domain";
    public static final String TTL = "ttl";
    public static final String LEASE_TIME = "lease";
    public static final String RENEW_TIME = "renew";
    public static final String REBIND_TIME = "rebind";
    public static final String TIMER_DELAY = "delay";
    public static final String DEFAULT_TIMEOUT = "timeout";
    public static final String START_IP = "startip";
    public static final String END_IP = "endip";
    public static final int DEFAULT = -1;

    public boolean isValid() {
        return this.hasOnlyFields(new String[]{MY_IP, MY_MAC, SUBNET_MASK, BROADCAST_ADDRESS, ROUTER_ADDRESS, DOMAIN_SERVER, TTL, LEASE_TIME, RENEW_TIME, REBIND_TIME, TIMER_DELAY, DEFAULT_TIMEOUT, START_IP, END_IP}) && this.isIpAddress(MY_IP, Config.FieldPresence.MANDATORY) && this.isMacAddress(MY_MAC, Config.FieldPresence.MANDATORY) && this.isIpAddress(START_IP, Config.FieldPresence.MANDATORY) && this.isIpAddress(END_IP, Config.FieldPresence.MANDATORY) && this.isNumber(LEASE_TIME, Config.FieldPresence.OPTIONAL, new long[]{1L}) && this.isNumber(REBIND_TIME, Config.FieldPresence.OPTIONAL, new long[]{1L}) && this.isNumber(DEFAULT_TIMEOUT, Config.FieldPresence.OPTIONAL, new long[]{1L, 3600L});
    }

    public Ip4Address ip() {
        String ip = this.get(MY_IP, null);
        return ip != null ? Ip4Address.valueOf((String)ip) : null;
    }

    public BasicElementConfig ip(String ip) {
        return (BasicElementConfig)this.setOrClear(MY_IP, ip);
    }

    public MacAddress mac() {
        String mac = this.get(MY_MAC, null);
        return mac != null ? MacAddress.valueOf((String)mac) : null;
    }

    public BasicElementConfig mac(String mac) {
        return (BasicElementConfig)this.setOrClear(MY_MAC, mac);
    }

    public Ip4Address subnetMask() {
        String ip = this.get(SUBNET_MASK, null);
        return ip != null ? Ip4Address.valueOf((String)ip) : null;
    }

    public BasicElementConfig subnetMask(String subnet) {
        return (BasicElementConfig)this.setOrClear(SUBNET_MASK, subnet);
    }

    public Ip4Address broadcastAddress() {
        String ip = this.get(BROADCAST_ADDRESS, null);
        return ip != null ? Ip4Address.valueOf((String)ip) : null;
    }

    public BasicElementConfig broadcastAddress(String broadcast) {
        return (BasicElementConfig)this.setOrClear(BROADCAST_ADDRESS, broadcast);
    }

    public int ttl() {
        return this.get(TTL, -1);
    }

    public BasicElementConfig ttl(int ttl) {
        return (BasicElementConfig)this.setOrClear(TTL, Integer.valueOf(ttl));
    }

    public int leaseTime() {
        return this.get(LEASE_TIME, -1);
    }

    public BasicElementConfig leaseTime(int lease) {
        return (BasicElementConfig)this.setOrClear(LEASE_TIME, Integer.valueOf(lease));
    }

    public int renewTime() {
        return this.get(RENEW_TIME, -1);
    }

    public BasicElementConfig renewTime(int renew) {
        return (BasicElementConfig)this.setOrClear(RENEW_TIME, Integer.valueOf(renew));
    }

    public int rebindTime() {
        return this.get(REBIND_TIME, -1);
    }

    public BasicElementConfig rebindTime(int rebind) {
        return (BasicElementConfig)this.setOrClear(REBIND_TIME, Integer.valueOf(rebind));
    }

    public Ip4Address routerAddress() {
        String ip = this.get(ROUTER_ADDRESS, null);
        return ip != null ? Ip4Address.valueOf((String)ip) : null;
    }

    public BasicElementConfig routerAddress(String router) {
        return (BasicElementConfig)this.setOrClear(ROUTER_ADDRESS, router);
    }

    public Ip4Address domainServer() {
        String ip = this.get(DOMAIN_SERVER, null);
        return ip != null ? Ip4Address.valueOf((String)ip) : null;
    }

    public BasicElementConfig domainServer(String domain) {
        return (BasicElementConfig)this.setOrClear(DOMAIN_SERVER, domain);
    }

    public int timerDelay() {
        return this.get(TIMER_DELAY, -1);
    }

    public BasicElementConfig timerDelay(int delay) {
        return (BasicElementConfig)this.setOrClear(TIMER_DELAY, Integer.valueOf(delay));
    }

    public int defaultTimeout() {
        return this.get(DEFAULT_TIMEOUT, -1);
    }

    public BasicElementConfig defaultTimeout(int defaultTimeout) {
        return (BasicElementConfig)this.setOrClear(DEFAULT_TIMEOUT, Integer.valueOf(defaultTimeout));
    }

    public Ip4Address startIp() {
        String ip = this.get(START_IP, null);
        return ip != null ? Ip4Address.valueOf((String)ip) : null;
    }

    public BasicElementConfig startIp(String startIp) {
        return (BasicElementConfig)this.setOrClear(START_IP, startIp);
    }

    public Ip4Address endIp() {
        String ip = this.get(END_IP, null);
        return ip != null ? Ip4Address.valueOf((String)ip) : null;
    }

    public BasicElementConfig endIp(String endIp) {
        return (BasicElementConfig)this.setOrClear(END_IP, endIp);
    }
}

