/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.dhcp.impl;

import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.jboss.netty.util.Timeout;
import org.jboss.netty.util.TimerTask;
import org.onlab.packet.Ethernet;
import org.onlab.packet.Ip4Address;
import org.onlab.packet.MacAddress;
import org.onlab.packet.TpPort;
import org.onlab.util.Timer;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreService;
import org.onosproject.dhcp.DhcpService;
import org.onosproject.dhcp.DhcpStore;
import org.onosproject.dhcp.IpAssignment;
import org.onosproject.dhcp.impl.DhcpConfig;
import org.onosproject.dhcp.impl.DhcpManager;
import org.onosproject.event.EventListener;
import org.onosproject.net.HostId;
import org.onosproject.net.config.ConfigFactory;
import org.onosproject.net.config.NetworkConfigRegistry;
import org.onosproject.net.flow.DefaultTrafficSelector;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.host.HostProvider;
import org.onosproject.net.host.HostProviderRegistry;
import org.onosproject.net.host.HostProviderService;
import org.onosproject.net.packet.PacketPriority;
import org.onosproject.net.packet.PacketProcessor;
import org.onosproject.net.packet.PacketService;
import org.onosproject.net.provider.Provider;
import org.onosproject.net.provider.ProviderId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
@Component(immediate=true)
@Service
public class DhcpManager
implements DhcpService {
    private static final ProviderId PID = new ProviderId("of", "org.onosproject.dhcp", true);
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final InternalConfigListener cfgListener = new InternalConfigListener(this, null);
    private final Set<ConfigFactory> factories = ImmutableSet.of((Object)new /* Unavailable Anonymous Inner Class!! */);
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected NetworkConfigRegistry cfgService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected PacketService packetService;
    private DhcpPacketProcessor processor = new DhcpPacketProcessor(this, null);
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected CoreService coreService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected DhcpStore dhcpStore;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected HostProviderRegistry hostProviderRegistry;
    protected HostProviderService hostProviderService;
    private final HostProvider hostProvider = new InternalHostProvider(this);
    private ApplicationId appId;
    private static Ip4Address myIP = Ip4Address.valueOf((String)"10.0.0.2");
    private static MacAddress myMAC = MacAddress.valueOf((String)"4f:4f:4f:4f:4f:4f");
    private static int leaseTime = 600;
    private static int renewalTime = 300;
    private static int rebindingTime = 360;
    private static byte packetTTL = (byte)127;
    private static Ip4Address subnetMask = Ip4Address.valueOf((String)"255.0.0.0");
    private static Ip4Address broadcastAddress = Ip4Address.valueOf((String)"10.255.255.255");
    private static Ip4Address routerAddress = Ip4Address.valueOf((String)"10.0.0.2");
    private static Ip4Address domainServer = Ip4Address.valueOf((String)"10.0.0.2");
    private static final Ip4Address IP_BROADCAST = Ip4Address.valueOf((String)"255.255.255.255");
    protected Timeout timeout;
    protected static int timerDelay = 2;

    @Activate
    protected void activate() {
        this.appId = this.coreService.registerApplication("org.onosproject.dhcp");
        this.cfgService.addListener((EventListener)this.cfgListener);
        this.factories.forEach(arg_0 -> ((NetworkConfigRegistry)this.cfgService).registerConfigFactory(arg_0));
        InternalConfigListener.access$200((InternalConfigListener)this.cfgListener, (DhcpConfig)((DhcpConfig)this.cfgService.getConfig((Object)this.appId, DhcpConfig.class)));
        this.hostProviderService = (HostProviderService)this.hostProviderRegistry.register((Provider)this.hostProvider);
        this.packetService.addProcessor((PacketProcessor)this.processor, PacketProcessor.director((int)0));
        this.requestPackets();
        this.timeout = Timer.getTimer().newTimeout((TimerTask)new PurgeListTask(this, null), (long)timerDelay, TimeUnit.MINUTES);
        this.log.info("Started");
    }

    @Deactivate
    protected void deactivate() {
        this.cfgService.removeListener((EventListener)this.cfgListener);
        this.factories.forEach(arg_0 -> ((NetworkConfigRegistry)this.cfgService).unregisterConfigFactory(arg_0));
        this.packetService.removeProcessor((PacketProcessor)this.processor);
        this.hostProviderRegistry.unregister((Provider)this.hostProvider);
        this.hostProviderService = null;
        this.cancelPackets();
        this.timeout.cancel();
        this.log.info("Stopped");
    }

    private void requestPackets() {
        TrafficSelector.Builder selectorServer = DefaultTrafficSelector.builder().matchEthType(Ethernet.TYPE_IPV4).matchIPProtocol((byte)17).matchUdpDst(TpPort.tpPort((int)67)).matchUdpSrc(TpPort.tpPort((int)68));
        this.packetService.requestPackets(selectorServer.build(), PacketPriority.CONTROL, this.appId);
        selectorServer = DefaultTrafficSelector.builder().matchEthType(Ethernet.TYPE_ARP);
        this.packetService.requestPackets(selectorServer.build(), PacketPriority.CONTROL, this.appId);
    }

    private void cancelPackets() {
        TrafficSelector.Builder selectorServer = DefaultTrafficSelector.builder().matchEthType(Ethernet.TYPE_IPV4).matchIPProtocol((byte)17).matchUdpDst(TpPort.tpPort((int)67)).matchUdpSrc(TpPort.tpPort((int)68));
        this.packetService.cancelPackets(selectorServer.build(), PacketPriority.CONTROL, this.appId);
        selectorServer = DefaultTrafficSelector.builder().matchEthType(Ethernet.TYPE_ARP);
        this.packetService.cancelPackets(selectorServer.build(), PacketPriority.CONTROL, this.appId);
    }

    public Map<HostId, IpAssignment> listMapping() {
        return this.dhcpStore.listAssignedMapping();
    }

    public int getLeaseTime() {
        return leaseTime;
    }

    public int getRenewalTime() {
        return renewalTime;
    }

    public int getRebindingTime() {
        return rebindingTime;
    }

    public boolean setStaticMapping(MacAddress macID, Ip4Address ipAddress, boolean rangeNotEnforced, List<Ip4Address> addressList) {
        this.log.debug("setStaticMapping is called with Mac: {}, Ip: {} addressList: {}", new Object[]{macID.toString(), ipAddress.toString(), addressList.toString()});
        return this.dhcpStore.assignStaticIP(macID, ipAddress, rangeNotEnforced, addressList);
    }

    public boolean removeStaticMapping(MacAddress macID) {
        return this.dhcpStore.removeStaticIP(macID);
    }

    public Iterable<Ip4Address> getAvailableIPs() {
        return this.dhcpStore.getAvailableIPs();
    }

    static /* synthetic */ Ip4Address access$400() {
        return subnetMask;
    }

    static /* synthetic */ Ip4Address access$500() {
        return myIP;
    }

    static /* synthetic */ Ip4Address access$600() {
        return routerAddress;
    }

    static /* synthetic */ Ip4Address access$700() {
        return domainServer;
    }

    static /* synthetic */ MacAddress access$800() {
        return myMAC;
    }

    static /* synthetic */ byte access$900() {
        return packetTTL;
    }

    static /* synthetic */ Ip4Address access$1000() {
        return IP_BROADCAST;
    }

    static /* synthetic */ int access$1100() {
        return leaseTime;
    }

    static /* synthetic */ int access$1200() {
        return renewalTime;
    }

    static /* synthetic */ int access$1300() {
        return rebindingTime;
    }

    static /* synthetic */ Ip4Address access$1400() {
        return broadcastAddress;
    }

    static /* synthetic */ Ip4Address access$502(Ip4Address x0) {
        myIP = x0;
        return myIP;
    }

    static /* synthetic */ MacAddress access$802(MacAddress x0) {
        myMAC = x0;
        return myMAC;
    }

    static /* synthetic */ Ip4Address access$402(Ip4Address x0) {
        subnetMask = x0;
        return subnetMask;
    }

    static /* synthetic */ Ip4Address access$1402(Ip4Address x0) {
        broadcastAddress = x0;
        return broadcastAddress;
    }

    static /* synthetic */ Ip4Address access$602(Ip4Address x0) {
        routerAddress = x0;
        return routerAddress;
    }

    static /* synthetic */ Ip4Address access$702(Ip4Address x0) {
        domainServer = x0;
        return domainServer;
    }

    static /* synthetic */ byte access$902(byte x0) {
        packetTTL = x0;
        return packetTTL;
    }

    static /* synthetic */ int access$1102(int x0) {
        leaseTime = x0;
        return leaseTime;
    }

    static /* synthetic */ int access$1202(int x0) {
        renewalTime = x0;
        return renewalTime;
    }

    static /* synthetic */ int access$1302(int x0) {
        rebindingTime = x0;
        return rebindingTime;
    }

    static /* synthetic */ ApplicationId access$1500(DhcpManager x0) {
        return x0.appId;
    }

    static /* synthetic */ Logger access$1600(DhcpManager x0) {
        return x0.log;
    }

    static /* synthetic */ ProviderId access$1700() {
        return PID;
    }

    protected void bindCfgService(NetworkConfigRegistry networkConfigRegistry) {
        this.cfgService = networkConfigRegistry;
    }

    protected void unbindCfgService(NetworkConfigRegistry networkConfigRegistry) {
        if (this.cfgService == networkConfigRegistry) {
            this.cfgService = null;
        }
    }

    protected void bindPacketService(PacketService packetService) {
        this.packetService = packetService;
    }

    protected void unbindPacketService(PacketService packetService) {
        if (this.packetService == packetService) {
            this.packetService = null;
        }
    }

    protected void bindCoreService(CoreService coreService) {
        this.coreService = coreService;
    }

    protected void unbindCoreService(CoreService coreService) {
        if (this.coreService == coreService) {
            this.coreService = null;
        }
    }

    protected void bindDhcpStore(DhcpStore dhcpStore) {
        this.dhcpStore = dhcpStore;
    }

    protected void unbindDhcpStore(DhcpStore dhcpStore) {
        if (this.dhcpStore == dhcpStore) {
            this.dhcpStore = null;
        }
    }

    protected void bindHostProviderRegistry(HostProviderRegistry hostProviderRegistry) {
        this.hostProviderRegistry = hostProviderRegistry;
    }

    protected void unbindHostProviderRegistry(HostProviderRegistry hostProviderRegistry) {
        if (this.hostProviderRegistry == hostProviderRegistry) {
            this.hostProviderRegistry = null;
        }
    }
}

