/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.dhcp.impl;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onlab.packet.Ip4Address;
import org.onlab.packet.MacAddress;
import org.onlab.util.KryoNamespace;
import org.onlab.util.Tools;
import org.onosproject.dhcp.DhcpStore;
import org.onosproject.dhcp.IpAssignment;
import org.onosproject.dhcp.impl.DistributedDhcpStore;
import org.onosproject.net.HostId;
import org.onosproject.store.serializers.KryoNamespaces;
import org.onosproject.store.service.ConsistentMap;
import org.onosproject.store.service.ConsistentMapException;
import org.onosproject.store.service.DistributedSet;
import org.onosproject.store.service.Serializer;
import org.onosproject.store.service.StorageService;
import org.onosproject.store.service.Versioned;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
public class DistributedDhcpStore
implements DhcpStore {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected StorageService storageService;
    private ConsistentMap<HostId, IpAssignment> allocationMap;
    private DistributedSet<Ip4Address> freeIPPool;
    private static Ip4Address startIPRange;
    private static Ip4Address endIPRange;
    private static int timeoutForPendingAssignments;
    private static final int MAX_RETRIES = 3;
    private static final int MAX_BACKOFF = 10;

    @Activate
    protected void activate() {
        this.allocationMap = this.storageService.consistentMapBuilder().withName("onos-dhcp-assignedIP").withSerializer(Serializer.using((KryoNamespace)new KryoNamespace.Builder().register(KryoNamespaces.API).register(new Class[]{IpAssignment.class, IpAssignment.AssignmentStatus.class, Date.class, Long.TYPE, Ip4Address.class}).build())).build();
        this.freeIPPool = this.storageService.setBuilder().withName("onos-dhcp-freeIP").withSerializer(Serializer.using((KryoNamespace)KryoNamespaces.API)).build();
        this.log.info("Started");
    }

    @Deactivate
    protected void deactivate() {
        this.log.info("Stopped");
    }

    public Ip4Address suggestIP(HostId hostId, Ip4Address requestedIP) {
        Ip4Address nextIPAddr;
        IpAssignment assignmentInfo;
        if (this.allocationMap.containsKey((Object)hostId)) {
            assignmentInfo = (IpAssignment)this.allocationMap.get((Object)hostId).value();
            IpAssignment.AssignmentStatus status = assignmentInfo.assignmentStatus();
            Ip4Address ipAddr = assignmentInfo.ipAddress();
            if (assignmentInfo.rangeNotEnforced()) {
                return assignmentInfo.ipAddress();
            }
            if (status == IpAssignment.AssignmentStatus.Option_Assigned || status == IpAssignment.AssignmentStatus.Option_Requested) {
                if (this.ipWithinRange(ipAddr)) {
                    return ipAddr;
                }
            } else if (status == IpAssignment.AssignmentStatus.Option_Expired && this.freeIPPool.contains((Object)ipAddr)) {
                assignmentInfo = IpAssignment.builder().ipAddress(ipAddr).timestamp(new Date()).leasePeriod(timeoutForPendingAssignments).assignmentStatus(IpAssignment.AssignmentStatus.Option_Requested).build();
                if (this.freeIPPool.remove((Object)ipAddr)) {
                    this.allocationMap.put((Object)hostId, (Object)assignmentInfo);
                    return ipAddr;
                }
            }
        } else if (requestedIP.toInt() != 0 && this.freeIPPool.contains((Object)requestedIP)) {
            assignmentInfo = IpAssignment.builder().ipAddress(requestedIP).timestamp(new Date()).leasePeriod(timeoutForPendingAssignments).assignmentStatus(IpAssignment.AssignmentStatus.Option_Requested).build();
            if (this.freeIPPool.remove((Object)requestedIP)) {
                this.allocationMap.put((Object)hostId, (Object)assignmentInfo);
                return requestedIP;
            }
        }
        if ((nextIPAddr = this.fetchNextIP()) != null) {
            assignmentInfo = IpAssignment.builder().ipAddress(nextIPAddr).timestamp(new Date()).leasePeriod(timeoutForPendingAssignments).assignmentStatus(IpAssignment.AssignmentStatus.Option_Requested).build();
            this.allocationMap.put((Object)hostId, (Object)assignmentInfo);
        }
        return nextIPAddr;
    }

    public boolean assignIP(HostId hostId, Ip4Address ipAddr, int leaseTime, boolean rangeNotEnforced, List<Ip4Address> addressList) {
        this.log.debug("Assign IP Called w/ Ip4Address: {}, HostId: {}", (Object)ipAddr.toString(), (Object)hostId.mac().toString());
        AtomicBoolean assigned = (AtomicBoolean)Tools.retryable(() -> {
            AtomicBoolean result = new AtomicBoolean(false);
            this.allocationMap.compute((Object)hostId, (h, existingAssignment) -> {
                IpAssignment assignment = existingAssignment;
                if (existingAssignment == null) {
                    if (rangeNotEnforced) {
                        assignment = IpAssignment.builder().ipAddress(ipAddr).timestamp(new Date()).leasePeriod(leaseTime).rangeNotEnforced(true).assignmentStatus(IpAssignment.AssignmentStatus.Option_RangeNotEnforced).subnetMask((Ip4Address)addressList.toArray()[0]).dhcpServer((Ip4Address)addressList.toArray()[1]).routerAddress((Ip4Address)addressList.toArray()[2]).domainServer((Ip4Address)addressList.toArray()[3]).build();
                        result.set(true);
                    } else if (this.freeIPPool.remove((Object)ipAddr)) {
                        assignment = IpAssignment.builder().ipAddress(ipAddr).timestamp(new Date()).leasePeriod(leaseTime).assignmentStatus(IpAssignment.AssignmentStatus.Option_Assigned).build();
                        result.set(true);
                    }
                } else if (Objects.equals(existingAssignment.ipAddress(), ipAddr) && (existingAssignment.rangeNotEnforced() || this.ipWithinRange(ipAddr))) {
                    switch (1.$SwitchMap$org$onosproject$dhcp$IpAssignment$AssignmentStatus[existingAssignment.assignmentStatus().ordinal()]) {
                        case 1: {
                            assignment = IpAssignment.builder().ipAddress(ipAddr).timestamp(new Date()).leasePeriod(leaseTime).rangeNotEnforced(true).assignmentStatus(IpAssignment.AssignmentStatus.Option_RangeNotEnforced).subnetMask(existingAssignment.subnetMask()).dhcpServer(existingAssignment.dhcpServer()).routerAddress(existingAssignment.routerAddress()).domainServer(existingAssignment.domainServer()).build();
                            result.set(true);
                            break;
                        }
                        case 2: 
                        case 3: {
                            assignment = IpAssignment.builder().ipAddress(ipAddr).timestamp(new Date()).leasePeriod(leaseTime).assignmentStatus(IpAssignment.AssignmentStatus.Option_Assigned).build();
                            result.set(true);
                            break;
                        }
                        case 4: {
                            if (!this.freeIPPool.remove((Object)ipAddr)) break;
                            assignment = IpAssignment.builder().ipAddress(ipAddr).timestamp(new Date()).leasePeriod(leaseTime).assignmentStatus(IpAssignment.AssignmentStatus.Option_Assigned).build();
                            result.set(true);
                            break;
                        }
                    }
                }
                return assignment;
            });
            return result;
        }, ConsistentMapException.class, (int)3, (int)10).get();
        return assigned.get();
    }

    public Ip4Address releaseIP(HostId hostId) {
        if (this.allocationMap.containsKey((Object)hostId)) {
            IpAssignment newAssignment = IpAssignment.builder((IpAssignment)((IpAssignment)this.allocationMap.get((Object)hostId).value())).assignmentStatus(IpAssignment.AssignmentStatus.Option_Expired).build();
            Ip4Address freeIP = newAssignment.ipAddress();
            this.allocationMap.put((Object)hostId, (Object)newAssignment);
            if (this.ipWithinRange(freeIP)) {
                this.freeIPPool.add((Object)freeIP);
            }
            return freeIP;
        }
        return null;
    }

    public void setDefaultTimeoutForPurge(int timeInSeconds) {
        timeoutForPendingAssignments = timeInSeconds;
    }

    public Map<HostId, IpAssignment> listAssignedMapping() {
        HashMap<HostId, IpAssignment> validMapping = new HashMap<HostId, IpAssignment>();
        for (Map.Entry entry : this.allocationMap.entrySet()) {
            IpAssignment assignment = (IpAssignment)((Versioned)entry.getValue()).value();
            if (assignment.assignmentStatus() != IpAssignment.AssignmentStatus.Option_Assigned && assignment.assignmentStatus() != IpAssignment.AssignmentStatus.Option_RangeNotEnforced) continue;
            validMapping.put((HostId)entry.getKey(), assignment);
        }
        return validMapping;
    }

    public Map<HostId, IpAssignment> listAllMapping() {
        HashMap<HostId, IpAssignment> validMapping = new HashMap<HostId, IpAssignment>();
        for (Map.Entry entry : this.allocationMap.entrySet()) {
            validMapping.put((HostId)entry.getKey(), (IpAssignment)((Versioned)entry.getValue()).value());
        }
        return validMapping;
    }

    public boolean assignStaticIP(MacAddress macID, Ip4Address ipAddr, boolean rangeNotEnforced, List<Ip4Address> addressList) {
        HostId host = HostId.hostId((MacAddress)macID);
        return this.assignIP(host, ipAddr, -1, rangeNotEnforced, addressList);
    }

    public boolean removeStaticIP(MacAddress macID) {
        HostId host = HostId.hostId((MacAddress)macID);
        if (this.allocationMap.containsKey((Object)host)) {
            IpAssignment assignment = (IpAssignment)this.allocationMap.get((Object)host).value();
            if (assignment.rangeNotEnforced()) {
                this.allocationMap.remove((Object)host);
                return true;
            }
            Ip4Address freeIP = assignment.ipAddress();
            if (assignment.leasePeriod() < 0) {
                this.allocationMap.remove((Object)host);
                if (this.ipWithinRange(freeIP)) {
                    this.freeIPPool.add((Object)freeIP);
                }
                return true;
            }
        }
        return false;
    }

    public Iterable<Ip4Address> getAvailableIPs() {
        return ImmutableSet.copyOf((Collection)this.freeIPPool);
    }

    public void populateIPPoolfromRange(Ip4Address startIP, Ip4Address endIP) {
        this.allocationMap.clear();
        this.freeIPPool.clear();
        startIPRange = startIP;
        endIPRange = endIP;
        int lastIP = endIP.toInt();
        for (int loopCounter = startIP.toInt(); loopCounter <= lastIP; ++loopCounter) {
            Ip4Address nextIP = Ip4Address.valueOf((int)loopCounter);
            this.freeIPPool.add((Object)nextIP);
        }
    }

    public IpAssignment getIpAssignmentFromAllocationMap(HostId hostId) {
        return (IpAssignment)this.allocationMap.get((Object)hostId).value();
    }

    private Ip4Address fetchNextIP() {
        for (Ip4Address freeIP : this.freeIPPool) {
            if (!this.freeIPPool.remove((Object)freeIP)) continue;
            return freeIP;
        }
        return null;
    }

    private boolean ipWithinRange(Ip4Address ip) {
        return ip.toInt() >= startIPRange.toInt() && ip.toInt() <= endIPRange.toInt();
    }

    static {
        timeoutForPendingAssignments = 60;
    }

    protected void bindStorageService(StorageService storageService) {
        this.storageService = storageService;
    }

    protected void unbindStorageService(StorageService storageService) {
        if (this.storageService == storageService) {
            this.storageService = null;
        }
    }
}

