/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.dhcp.rest;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Response;
import org.onlab.packet.Ip4Address;
import org.onlab.packet.MacAddress;
import org.onosproject.dhcp.DhcpService;
import org.onosproject.dhcp.IpAssignment;
import org.onosproject.net.HostId;
import org.onosproject.rest.AbstractWebResource;

/*
 * Exception performing whole class analysis ignored.
 */
@Path(value="dhcp")
public class DhcpWebResource
extends AbstractWebResource {
    private final DhcpService service = (DhcpService)this.get(DhcpService.class);

    @GET
    @Path(value="config")
    public Response getConfigs() {
        ObjectNode node = this.mapper().createObjectNode().put("leaseTime", this.service.getLeaseTime()).put("renewalTime", this.service.getRenewalTime()).put("rebindingTime", this.service.getRebindingTime());
        return DhcpWebResource.ok((Object)node).build();
    }

    @GET
    @Path(value="mappings")
    public Response listMappings() {
        ObjectNode root = this.mapper().createObjectNode();
        Map intents = this.service.listMapping();
        ArrayNode arrayNode = root.putArray("mappings");
        intents.entrySet().forEach(i -> arrayNode.add((JsonNode)this.mapper().createObjectNode().put("host", ((HostId)i.getKey()).toString()).put("ip", ((IpAssignment)i.getValue()).ipAddress().toString())));
        return DhcpWebResource.ok((Object)root).build();
    }

    @GET
    @Path(value="available")
    public Response listAvailableIPs() {
        Iterable availableIPList = this.service.getAvailableIPs();
        ObjectNode root = this.mapper().createObjectNode();
        ArrayNode arrayNode = root.putArray("availableIP");
        availableIPList.forEach(i -> arrayNode.add(i.toString()));
        return DhcpWebResource.ok((Object)root).build();
    }

    @POST
    @Path(value="mappings")
    @Consumes(value={"application/json"})
    public Response setMapping(InputStream stream) {
        ObjectNode root = this.mapper().createObjectNode();
        try {
            ObjectNode jsonTree = (ObjectNode)this.mapper().readTree(stream);
            JsonNode macID = jsonTree.get("mac");
            JsonNode ip = jsonTree.get("ip");
            if (macID != null && ip != null && !this.service.setStaticMapping(MacAddress.valueOf((String)macID.asText()), Ip4Address.valueOf((String)ip.asText()), false, (List)Lists.newArrayList())) {
                throw new IllegalArgumentException("Static Mapping Failed. The IP maybe unavailable.");
            }
            Map intents = this.service.listMapping();
            ArrayNode arrayNode = root.putArray("mappings");
            intents.entrySet().forEach(i -> arrayNode.add((JsonNode)this.mapper().createObjectNode().put("host", ((HostId)i.getKey()).toString()).put("ip", ((IpAssignment)i.getValue()).ipAddress().toString())));
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        return DhcpWebResource.ok((Object)root).build();
    }

    @DELETE
    @Path(value="mappings/{macID}")
    public Response deleteMapping(@PathParam(value="macID") String macID) {
        ObjectNode root = this.mapper().createObjectNode();
        if (!this.service.removeStaticMapping(MacAddress.valueOf((String)macID))) {
            throw new IllegalArgumentException("Static Mapping Removal Failed.");
        }
        Map intents = this.service.listMapping();
        ArrayNode arrayNode = root.putArray("mappings");
        intents.entrySet().forEach(i -> arrayNode.add((JsonNode)this.mapper().createObjectNode().put("host", ((HostId)i.getKey()).toString()).put("ip", ((IpAssignment)i.getValue()).ipAddress().toString())));
        return DhcpWebResource.ok((Object)root).build();
    }
}

