/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.faultmanagement.alarms.cli;

import java.util.Map;
import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.incubator.net.faultmanagement.alarm.Alarm;
import org.onosproject.incubator.net.faultmanagement.alarm.AlarmService;
import org.onosproject.net.DeviceId;

@Command(scope="onos", name="alarm-counts-device", description="Lists alarm counts across specified device.")
public class GetDeviceAlarmsCounts
extends AbstractShellCommand {
    @Argument(index=0, name="deviceId", description="Device identity", required=true, multiValued=false)
    String deviceId = null;

    protected void execute() {
        Map alarmCounts = ((AlarmService)AbstractShellCommand.get(AlarmService.class)).getAlarmCounts(DeviceId.deviceId((String)this.deviceId));
        this.printCounts(alarmCounts);
    }

    void printCounts(Map<Alarm.SeverityLevel, Long> alarmCounts) {
        alarmCounts.entrySet().stream().forEach(countEntry -> this.print(String.format("%s, %d", countEntry.getKey(), countEntry.getValue()), new Object[0]));
    }
}

