/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.faultmanagement.impl;

import com.google.common.base.Strings;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Modified;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onlab.util.ItemNotFoundException;
import org.onlab.util.Tools;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreService;
import org.onosproject.core.IdGenerator;
import org.onosproject.incubator.net.faultmanagement.alarm.Alarm;
import org.onosproject.incubator.net.faultmanagement.alarm.AlarmEntityId;
import org.onosproject.incubator.net.faultmanagement.alarm.AlarmEvent;
import org.onosproject.incubator.net.faultmanagement.alarm.AlarmId;
import org.onosproject.incubator.net.faultmanagement.alarm.AlarmListener;
import org.onosproject.incubator.net.faultmanagement.alarm.AlarmService;
import org.onosproject.incubator.net.faultmanagement.alarm.DefaultAlarm;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DeviceId;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
public class AlarmsManager
implements AlarmService {
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected CoreService coreService;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private ApplicationId appId;
    private IdGenerator idGenerator;
    @Property(name="fmDevices", value={"127.0.0.1"}, label="Instance-specific configurations")
    private String devConfigs;
    private final Map<AlarmId, Alarm> alarms = new ConcurrentHashMap<AlarmId, Alarm>();
    private final AtomicLong alarmIdGenerator = new AtomicLong(0L);
    private static final String NOT_SUPPORTED_YET = "Not supported yet.";

    public Alarm update(Alarm replacement) {
        Alarm found = this.alarms.get(replacement.id());
        if (found == null) {
            throw new ItemNotFoundException("Alarm with id " + replacement.id() + " found");
        }
        DefaultAlarm updated = new DefaultAlarm.Builder(found).withAcknowledged(replacement.acknowledged()).withAssignedUser(replacement.assignedUser()).build();
        this.alarms.put(replacement.id(), (Alarm)updated);
        return updated;
    }

    public int getActiveAlarmCount(DeviceId deviceId) {
        throw new UnsupportedOperationException(NOT_SUPPORTED_YET);
    }

    public Alarm getAlarm(AlarmId alarmId) {
        return (Alarm)Tools.nullIsNotFound((Object)this.alarms.get(alarmId), (String)"Alarm is not found");
    }

    public Set<Alarm> getAlarms() {
        throw new UnsupportedOperationException(NOT_SUPPORTED_YET);
    }

    public Set<Alarm> getActiveAlarms() {
        return this.alarms.isEmpty() ? new HashSet<Alarm>() : new HashSet<Alarm>(this.alarms.values());
    }

    private static DefaultAlarm generateFake(DeviceId deviceId, AlarmId alarmId) {
        return new DefaultAlarm.Builder(alarmId, deviceId, "NE is not reachable", Alarm.SeverityLevel.MAJOR, System.currentTimeMillis()).withTimeUpdated(System.currentTimeMillis()).withServiceAffecting(true).withAcknowledged(true).withManuallyClearable(true).withAssignedUser("user1").build();
    }

    public Set<Alarm> getAlarms(Alarm.SeverityLevel severity) {
        throw new UnsupportedOperationException(NOT_SUPPORTED_YET);
    }

    public Set<Alarm> getAlarms(DeviceId deviceId) {
        throw new UnsupportedOperationException(NOT_SUPPORTED_YET);
    }

    public Set<Alarm> getAlarms(DeviceId deviceId, AlarmEntityId source) {
        throw new UnsupportedOperationException(NOT_SUPPORTED_YET);
    }

    public Set<Alarm> getAlarmsForLink(ConnectPoint src, ConnectPoint dst) {
        throw new UnsupportedOperationException(NOT_SUPPORTED_YET);
    }

    public Set<Alarm> getAlarmsForFlow(DeviceId deviceId, long flowId) {
        throw new UnsupportedOperationException(NOT_SUPPORTED_YET);
    }

    private void discoverAlarmsForDevice(DeviceId deviceId) {
        AlarmId alarmId = new AlarmId(this.alarmIdGenerator.incrementAndGet());
        this.alarms.put(alarmId, (Alarm)AlarmsManager.generateFake(deviceId, alarmId));
    }

    @Activate
    public void activate(ComponentContext context) {
        this.log.info("Activate ...");
        this.appId = this.coreService.registerApplication("org.onos.faultmanagement.alarms");
        this.idGenerator = this.coreService.getIdGenerator("alarm-ids");
        this.log.info("Started with appId={} idGenerator={}", (Object)this.appId, (Object)this.idGenerator);
        boolean result = this.modified(context);
        this.log.info("modified result = {}", (Object)result);
    }

    @Deactivate
    public void deactivate(ComponentContext context) {
        this.log.info("Deactivate ...");
        this.log.info("Stopped");
    }

    @Modified
    public boolean modified(ComponentContext context) {
        this.log.info("context={}", (Object)context);
        if (context == null) {
            this.log.info("No configuration file");
            return false;
        }
        Dictionary properties = context.getProperties();
        String ipaddresses = Tools.get((Dictionary)properties, (String)"fmDevices");
        this.log.info("Settings: devConfigs={}", (Object)ipaddresses);
        if (!Strings.isNullOrEmpty((String)ipaddresses)) {
            this.discover(ipaddresses);
        }
        return true;
    }

    private void discover(String ipaddresses) {
        for (String deviceEntry : ipaddresses.split(",")) {
            DeviceId deviceId = DeviceId.deviceId((String)deviceEntry);
            if (deviceId == null) continue;
            this.log.info("Device {} needs to have its alarms refreshed!", (Object)deviceId);
            this.discoverAlarmsForDevice(deviceId);
        }
    }

    protected void bindCoreService(CoreService coreService) {
        this.coreService = coreService;
    }

    protected void unbindCoreService(CoreService coreService) {
        if (this.coreService == coreService) {
            this.coreService = null;
        }
    }

    private class InternalAlarmListener
    implements AlarmListener {
        private InternalAlarmListener() {
        }

        public void event(AlarmEvent event) {
            throw new UnsupportedOperationException(AlarmsManager.NOT_SUPPORTED_YET);
        }
    }
}

