/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.faultmanagement.impl;

import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.onlab.util.ItemNotFoundException;
import org.onosproject.faultmanagement.impl.AlarmsManager;
import org.onosproject.incubator.net.faultmanagement.alarm.Alarm;
import org.onosproject.incubator.net.faultmanagement.alarm.AlarmEntityId;
import org.onosproject.incubator.net.faultmanagement.alarm.AlarmId;
import org.onosproject.incubator.net.faultmanagement.alarm.DefaultAlarm;
import org.onosproject.net.DeviceId;

public class AlarmsManagerTest {
    private static final DeviceId DEVICE_ID = DeviceId.deviceId((String)"foo:bar");
    private static final DefaultAlarm ALARM_A = new DefaultAlarm.Builder(DEVICE_ID, "aaa", Alarm.SeverityLevel.CRITICAL, 0L).build();
    private static final DefaultAlarm ALARM_A_WITHSRC = new DefaultAlarm.Builder((Alarm)ALARM_A).forSource(AlarmEntityId.alarmEntityId((String)"port:foo")).build();
    private static final DefaultAlarm ALARM_B = new DefaultAlarm.Builder(DEVICE_ID, "bbb", Alarm.SeverityLevel.CRITICAL, 0L).build();

    @Test
    public void testGettersWhenNoAlarms() {
        AlarmsManager am = new AlarmsManager();
        Assert.assertTrue((String)"No alarms", (boolean)am.getAlarms().isEmpty());
        Assert.assertTrue((String)"No active alarms", (boolean)am.getActiveAlarms().isEmpty());
        Assert.assertTrue((String)"No alarms gives empty map per unknown device", (boolean)am.getAlarmCounts(DeviceId.NONE).keySet().isEmpty());
        Assert.assertTrue((String)"No alarms gives empty map", (boolean)am.getAlarmCounts().keySet().isEmpty());
        Assert.assertEquals((String)"Zero alarms for that device", (long)0L, (long)am.getAlarms(DeviceId.NONE).size());
        Assert.assertEquals((String)"Zero major alarms", (long)0L, (long)am.getAlarms(Alarm.SeverityLevel.MAJOR).size());
        try {
            Assert.assertEquals((String)"no alarms", (Object)0, (Object)am.getAlarm(null));
        }
        catch (NullPointerException ex) {
            Assert.assertThat((Object)ex.getMessage(), (Matcher)Matchers.containsString((String)"cannot be null"));
        }
        try {
            Assert.assertEquals((String)"no alarms", (Object)0, (Object)am.getAlarm(AlarmId.alarmId((long)1L)));
        }
        catch (ItemNotFoundException ex) {
            Assert.assertThat((Object)ex.getMessage(), (Matcher)Matchers.containsString((String)"not found"));
        }
    }

    @Test
    public void testAlarmUpdates() {
        AlarmsManager am = new AlarmsManager();
        Assert.assertTrue((String)"no alarms", (boolean)am.getAlarms().isEmpty());
        am.updateAlarms(new HashSet(), DEVICE_ID);
        Assert.assertTrue((String)"still no alarms", (boolean)am.getAlarms().isEmpty());
        Map<Alarm.SeverityLevel, Long> zeroAlarms = new CountsMapBuilder().create();
        Assert.assertEquals(zeroAlarms, (Object)am.getAlarmCounts());
        Assert.assertEquals(zeroAlarms, (Object)am.getAlarmCounts(DEVICE_ID));
        am.updateAlarms((Set)Sets.newHashSet((Object[])new Alarm[]{ALARM_B, ALARM_A}), DEVICE_ID);
        this.verifyGettingSetsOfAlarms(am, 2, 2);
        Map<Alarm.SeverityLevel, Long> critical2 = new CountsMapBuilder().with(Alarm.SeverityLevel.CRITICAL, 2L).create();
        Assert.assertEquals(critical2, (Object)am.getAlarmCounts());
        Assert.assertEquals(critical2, (Object)am.getAlarmCounts(DEVICE_ID));
        am.updateAlarms((Set)Sets.newHashSet((Object[])new Alarm[]{ALARM_A}), DEVICE_ID);
        this.verifyGettingSetsOfAlarms(am, 2, 1);
        Map<Alarm.SeverityLevel, Long> critical1cleared1 = new CountsMapBuilder().with(Alarm.SeverityLevel.CRITICAL, 1L).with(Alarm.SeverityLevel.CLEARED, 1L).create();
        Assert.assertEquals(critical1cleared1, (Object)am.getAlarmCounts());
        Assert.assertEquals(critical1cleared1, (Object)am.getAlarmCounts(DEVICE_ID));
        am.updateAlarms((Set)Sets.newHashSet((Object[])new Alarm[]{ALARM_A}), DEVICE_ID);
        this.verifyGettingSetsOfAlarms(am, 2, 1);
        Assert.assertEquals(critical1cleared1, (Object)am.getAlarmCounts());
        Assert.assertEquals(critical1cleared1, (Object)am.getAlarmCounts(DEVICE_ID));
        am.updateAlarms((Set)Sets.newHashSet((Object[])new Alarm[]{ALARM_A, ALARM_A_WITHSRC}), DEVICE_ID);
        this.verifyGettingSetsOfAlarms(am, 3, 2);
        Map<Alarm.SeverityLevel, Long> critical2cleared1 = new CountsMapBuilder().with(Alarm.SeverityLevel.CRITICAL, 2L).with(Alarm.SeverityLevel.CLEARED, 1L).create();
        Assert.assertEquals(critical2cleared1, (Object)am.getAlarmCounts());
        Assert.assertEquals(critical2cleared1, (Object)am.getAlarmCounts(DEVICE_ID));
        am.updateAlarms((Set)Sets.newHashSet(), DEVICE_ID);
        this.verifyGettingSetsOfAlarms(am, 3, 0);
        Assert.assertEquals(new CountsMapBuilder().with(Alarm.SeverityLevel.CLEARED, 3L).create(), (Object)am.getAlarmCounts(DEVICE_ID));
        Assert.assertEquals((String)"No alarms for unknown devices", zeroAlarms, (Object)am.getAlarmCounts(DeviceId.NONE));
        Assert.assertEquals((String)"No alarms for unknown devices", zeroAlarms, (Object)am.getAlarmCounts(DeviceId.deviceId((String)"junk:junk")));
    }

    private void verifyGettingSetsOfAlarms(AlarmsManager am, int expectedTotal, int expectedActive) {
        Assert.assertEquals((String)"Wrong total", (long)expectedTotal, (long)am.getAlarms().size());
        Assert.assertEquals((String)"Wrong active count", (long)expectedActive, (long)am.getActiveAlarms().size());
    }

    private static class CountsMapBuilder {
        private final Map<Alarm.SeverityLevel, Long> map = new HashMap<Alarm.SeverityLevel, Long>();

        private CountsMapBuilder() {
        }

        public CountsMapBuilder with(Alarm.SeverityLevel sev, Long count) {
            this.map.put(sev, count);
            return this;
        }

        public Map<Alarm.SeverityLevel, Long> create() {
            return Collections.unmodifiableMap(this.map);
        }
    }
}

