/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.faultmanagement.impl;

import com.google.common.base.Preconditions;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Modified;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onlab.util.ItemNotFoundException;
import org.onlab.util.Tools;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreService;
import org.onosproject.core.IdGenerator;
import org.onosproject.incubator.net.faultmanagement.alarm.Alarm;
import org.onosproject.incubator.net.faultmanagement.alarm.AlarmEntityId;
import org.onosproject.incubator.net.faultmanagement.alarm.AlarmEvent;
import org.onosproject.incubator.net.faultmanagement.alarm.AlarmId;
import org.onosproject.incubator.net.faultmanagement.alarm.AlarmListener;
import org.onosproject.incubator.net.faultmanagement.alarm.AlarmProvider;
import org.onosproject.incubator.net.faultmanagement.alarm.AlarmService;
import org.onosproject.incubator.net.faultmanagement.alarm.DefaultAlarm;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.device.DeviceService;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
public class AlarmsManager
implements AlarmService {
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected CoreService coreService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected DeviceService deviceService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected AlarmProvider alarmProvider;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private ApplicationId appId;
    private IdGenerator idGenerator;
    private ScheduledExecutorService alarmPollExecutor;
    private final AtomicLong alarmIdGenerator = new AtomicLong(0L);
    private static final int DEFAULT_POLL_FREQUENCY_SECONDS = 120;
    @Property(name="alarmPollFrequencySeconds", intValue={120}, label="Frequency (in seconds) for polling alarm from devices")
    private int alarmPollFrequencySeconds = 120;
    private static final int DEFAULT_CLEAR_FREQUENCY_SECONDS = 500;
    @Property(name="clearedAlarmPurgeSeconds", intValue={500}, label="Frequency (in seconds) for deleting cleared alarms")
    private int clearedAlarmPurgeFrequencySeconds = 500;
    private final Map<AlarmId, Alarm> alarms = new ConcurrentHashMap<AlarmId, Alarm>();
    private static final String NOT_SUPPORTED_YET = "Not supported yet.";
    private final AlarmListener alarmListener = new InternalAlarmListener();

    private AlarmId generateAlarmId() {
        return AlarmId.alarmId((long)this.alarmIdGenerator.incrementAndGet());
    }

    public Alarm updateBookkeepingFields(AlarmId id, boolean isAcknowledged, String assignedUser) {
        Alarm found = this.alarms.get(id);
        if (found == null) {
            throw new ItemNotFoundException("Alarm with id " + id + " found");
        }
        DefaultAlarm updated = new DefaultAlarm.Builder(found).withAcknowledged(isAcknowledged).withAssignedUser(assignedUser).build();
        this.alarms.put(id, (Alarm)updated);
        return updated;
    }

    public Alarm clear(AlarmId id) {
        Alarm found = this.alarms.get(id);
        if (found == null) {
            this.log.warn("id {} cant be cleared as it is already gone.", (Object)id);
            return null;
        }
        DefaultAlarm updated = new DefaultAlarm.Builder(found).clear().build();
        this.alarms.put(id, (Alarm)updated);
        return updated;
    }

    public Map<Alarm.SeverityLevel, Long> getAlarmCounts(DeviceId deviceId) {
        return this.getAlarms(deviceId).stream().collect(Collectors.groupingBy(Alarm::severity, Collectors.counting()));
    }

    public Map<Alarm.SeverityLevel, Long> getAlarmCounts() {
        return this.getAlarms().stream().collect(Collectors.groupingBy(Alarm::severity, Collectors.counting()));
    }

    public Alarm getAlarm(AlarmId alarmId) {
        return (Alarm)Tools.nullIsNotFound((Object)this.alarms.get(Preconditions.checkNotNull((Object)alarmId, (Object)"Alarm Id cannot be null")), (String)"Alarm is not found");
    }

    public Set<Alarm> getAlarms() {
        return new HashSet<Alarm>(this.alarms.values());
    }

    public Set<Alarm> getActiveAlarms() {
        return this.alarms.values().stream().filter(a -> !a.severity().equals((Object)Alarm.SeverityLevel.CLEARED)).collect(Collectors.toSet());
    }

    public Set<Alarm> getAlarms(Alarm.SeverityLevel severity) {
        return this.alarms.values().stream().filter(a -> a.severity().equals((Object)severity)).collect(Collectors.toSet());
    }

    public Set<Alarm> getAlarms(DeviceId deviceId) {
        return this.alarms.values().stream().filter(a -> deviceId.equals((Object)a.deviceId())).collect(Collectors.toSet());
    }

    private Set<Alarm> getActiveAlarms(DeviceId deviceId) {
        return this.getActiveAlarms().stream().filter(a -> deviceId.equals((Object)a.deviceId())).collect(Collectors.toSet());
    }

    public Set<Alarm> getAlarms(DeviceId deviceId, AlarmEntityId source) {
        return this.getAlarms(deviceId).stream().filter(a -> source.equals((Object)a.source())).collect(Collectors.toSet());
    }

    public Set<Alarm> getAlarmsForLink(ConnectPoint src, ConnectPoint dst) {
        throw new UnsupportedOperationException(NOT_SUPPORTED_YET);
    }

    public Set<Alarm> getAlarmsForFlow(DeviceId deviceId, long flowId) {
        throw new UnsupportedOperationException(NOT_SUPPORTED_YET);
    }

    @Activate
    public void activate(ComponentContext context) {
        this.appId = this.coreService.registerApplication("org.onosproject.faultmanagement.alarms");
        this.idGenerator = this.coreService.getIdGenerator("alarm-ids");
        this.log.info("Started with appId={}", (Object)this.appId);
        this.alarmProvider.addAlarmListener(this.alarmListener);
        this.probeActiveDevices();
        boolean result = this.modified(context);
        this.log.info("modified result = {}", (Object)result);
        this.alarmPollExecutor = Executors.newSingleThreadScheduledExecutor(Tools.groupedThreads((String)"onos/fm", (String)"alarms-poll-%d"));
        this.alarmPollExecutor.scheduleAtFixedRate(new PollAlarmsTask(), this.alarmPollFrequencySeconds, this.alarmPollFrequencySeconds, TimeUnit.SECONDS);
    }

    private void probeActiveDevices() {
        Iterable devices = this.deviceService.getAvailableDevices();
        this.log.info("Refresh alarms for all available devices={} ...", (Object)devices);
        for (Device d : devices) {
            this.log.info("Lets tell alarm provider to refresh alarms for {} ...", (Object)d.id());
            this.alarmProvider.triggerProbe(d.id());
        }
    }

    @Deactivate
    public void deactivate(ComponentContext context) {
        this.log.info("Deactivate ...");
        this.alarmProvider.removeAlarmListener(this.alarmListener);
        if (this.alarmPollExecutor != null) {
            this.alarmPollExecutor.shutdownNow();
        }
        this.alarms.clear();
        this.log.info("Stopped");
    }

    @Modified
    public boolean modified(ComponentContext context) {
        this.log.info("context={}", (Object)context);
        if (context == null) {
            this.log.info("No configuration file");
            return false;
        }
        Dictionary properties = context.getProperties();
        String clearedAlarmPurgeSeconds = Tools.get((Dictionary)properties, (String)"clearedAlarmPurgeSeconds");
        this.log.info("Settings: clearedAlarmPurgeSeconds={}", (Object)clearedAlarmPurgeSeconds);
        return true;
    }

    synchronized void updateAlarms(Set<Alarm> discoveredSet, DeviceId deviceId) {
        Set<Alarm> storedSet = this.getActiveAlarms(deviceId);
        this.log.trace("currentNeAlarms={}. discoveredAlarms={}", storedSet, discoveredSet);
        if (CollectionUtils.isEqualCollection(storedSet, discoveredSet)) {
            this.log.debug("Alarm lists are equivalent so no update for {}.", (Object)deviceId);
            return;
        }
        storedSet.stream().filter(stored -> !discoveredSet.contains(stored)).forEach(stored -> {
            this.log.info("Alarm will be cleared as it is not on the element. Cleared alarm: {}.", stored);
            this.clear(stored.id());
        });
        discoveredSet.stream().filter(discovered -> !storedSet.contains(discovered)).forEach(discovered -> {
            this.log.info("Alarm will be raised as it is missing. New alarm: {}.", discovered);
            AlarmId id = this.generateAlarmId();
            this.alarms.put(id, (Alarm)new DefaultAlarm.Builder(discovered).withId(id).build());
        });
    }

    protected void bindCoreService(CoreService coreService) {
        this.coreService = coreService;
    }

    protected void unbindCoreService(CoreService coreService) {
        if (this.coreService == coreService) {
            this.coreService = null;
        }
    }

    protected void bindDeviceService(DeviceService deviceService) {
        this.deviceService = deviceService;
    }

    protected void unbindDeviceService(DeviceService deviceService) {
        if (this.deviceService == deviceService) {
            this.deviceService = null;
        }
    }

    protected void bindAlarmProvider(AlarmProvider alarmProvider) {
        this.alarmProvider = alarmProvider;
    }

    protected void unbindAlarmProvider(AlarmProvider alarmProvider) {
        if (this.alarmProvider == alarmProvider) {
            this.alarmProvider = null;
        }
    }

    private final class PollAlarmsTask
    implements Runnable {
        private PollAlarmsTask() {
        }

        @Override
        public void run() {
            if (Thread.currentThread().isInterrupted()) {
                AlarmsManager.this.log.info("Interrupted, quitting");
                return;
            }
            try {
                AlarmsManager.this.probeActiveDevices();
            }
            catch (RuntimeException e) {
                AlarmsManager.this.log.error("Exception thrown during alarm synchronization process", (Throwable)e);
            }
        }
    }

    private class InternalAlarmListener
    implements AlarmListener {
        private InternalAlarmListener() {
        }

        public void event(AlarmEvent event) {
            AlarmsManager.this.log.debug("AlarmsManager. InternalAlarmListener received {}", (Object)event);
            try {
                switch ((AlarmEvent.Type)event.type()) {
                    case DEVICE_DISCOVERY: {
                        DeviceId deviceId = (DeviceId)Preconditions.checkNotNull((Object)event.getDeviceRefreshed(), (Object)"Listener cannot be null");
                        AlarmsManager.this.log.info("New alarm set for {} received!", (Object)deviceId);
                        AlarmsManager.this.updateAlarms((Set)event.subject(), deviceId);
                        break;
                    }
                    case NOTIFICATION: {
                        throw new IllegalArgumentException("Alarm Notifications (Traps) not expected or implemented yet. Received =" + event);
                    }
                }
            }
            catch (Exception e) {
                AlarmsManager.this.log.warn("Failed to process {}", (Object)event, (Object)e);
            }
        }
    }
}

